/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.PublicIpv4PoolRange;
import software.amazon.awssdk.services.ec2.model.PublicIpv4PoolRangeSetCopier;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PublicIpv4Pool
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PublicIpv4Pool> {
    private static final SdkField<String> POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PoolId").getter(PublicIpv4Pool.getter(PublicIpv4Pool::poolId)).setter(PublicIpv4Pool.setter(Builder::poolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolId").unmarshallLocationName("poolId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(PublicIpv4Pool.getter(PublicIpv4Pool::description)).setter(PublicIpv4Pool.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("description").build()}).build();
    private static final SdkField<List<PublicIpv4PoolRange>> POOL_ADDRESS_RANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PoolAddressRanges").getter(PublicIpv4Pool.getter(PublicIpv4Pool::poolAddressRanges)).setter(PublicIpv4Pool.setter(Builder::poolAddressRanges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolAddressRangeSet").unmarshallLocationName("poolAddressRangeSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PublicIpv4PoolRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Integer> TOTAL_ADDRESS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalAddressCount").getter(PublicIpv4Pool.getter(PublicIpv4Pool::totalAddressCount)).setter(PublicIpv4Pool.setter(Builder::totalAddressCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalAddressCount").unmarshallLocationName("totalAddressCount").build()}).build();
    private static final SdkField<Integer> TOTAL_AVAILABLE_ADDRESS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalAvailableAddressCount").getter(PublicIpv4Pool.getter(PublicIpv4Pool::totalAvailableAddressCount)).setter(PublicIpv4Pool.setter(Builder::totalAvailableAddressCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalAvailableAddressCount").unmarshallLocationName("totalAvailableAddressCount").build()}).build();
    private static final SdkField<String> NETWORK_BORDER_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkBorderGroup").getter(PublicIpv4Pool.getter(PublicIpv4Pool::networkBorderGroup)).setter(PublicIpv4Pool.setter(Builder::networkBorderGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkBorderGroup").unmarshallLocationName("networkBorderGroup").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(PublicIpv4Pool.getter(PublicIpv4Pool::tags)).setter(PublicIpv4Pool.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POOL_ID_FIELD, DESCRIPTION_FIELD, POOL_ADDRESS_RANGES_FIELD, TOTAL_ADDRESS_COUNT_FIELD, TOTAL_AVAILABLE_ADDRESS_COUNT_FIELD, NETWORK_BORDER_GROUP_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PublicIpv4Pool.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String poolId;
    private final String description;
    private final List<PublicIpv4PoolRange> poolAddressRanges;
    private final Integer totalAddressCount;
    private final Integer totalAvailableAddressCount;
    private final String networkBorderGroup;
    private final List<Tag> tags;

    private PublicIpv4Pool(BuilderImpl builder) {
        this.poolId = builder.poolId;
        this.description = builder.description;
        this.poolAddressRanges = builder.poolAddressRanges;
        this.totalAddressCount = builder.totalAddressCount;
        this.totalAvailableAddressCount = builder.totalAvailableAddressCount;
        this.networkBorderGroup = builder.networkBorderGroup;
        this.tags = builder.tags;
    }

    public final String poolId() {
        return this.poolId;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasPoolAddressRanges() {
        return this.poolAddressRanges != null && !(this.poolAddressRanges instanceof SdkAutoConstructList);
    }

    public final List<PublicIpv4PoolRange> poolAddressRanges() {
        return this.poolAddressRanges;
    }

    public final Integer totalAddressCount() {
        return this.totalAddressCount;
    }

    public final Integer totalAvailableAddressCount() {
        return this.totalAvailableAddressCount;
    }

    public final String networkBorderGroup() {
        return this.networkBorderGroup;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.poolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPoolAddressRanges() ? this.poolAddressRanges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.totalAddressCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalAvailableAddressCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkBorderGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublicIpv4Pool)) {
            return false;
        }
        PublicIpv4Pool other = (PublicIpv4Pool)obj;
        return Objects.equals(this.poolId(), other.poolId()) && Objects.equals(this.description(), other.description()) && this.hasPoolAddressRanges() == other.hasPoolAddressRanges() && Objects.equals(this.poolAddressRanges(), other.poolAddressRanges()) && Objects.equals(this.totalAddressCount(), other.totalAddressCount()) && Objects.equals(this.totalAvailableAddressCount(), other.totalAvailableAddressCount()) && Objects.equals(this.networkBorderGroup(), other.networkBorderGroup()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"PublicIpv4Pool").add("PoolId", (Object)this.poolId()).add("Description", (Object)this.description()).add("PoolAddressRanges", this.hasPoolAddressRanges() ? this.poolAddressRanges() : null).add("TotalAddressCount", (Object)this.totalAddressCount()).add("TotalAvailableAddressCount", (Object)this.totalAvailableAddressCount()).add("NetworkBorderGroup", (Object)this.networkBorderGroup()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PoolId": {
                return Optional.ofNullable(clazz.cast(this.poolId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "PoolAddressRanges": {
                return Optional.ofNullable(clazz.cast(this.poolAddressRanges()));
            }
            case "TotalAddressCount": {
                return Optional.ofNullable(clazz.cast(this.totalAddressCount()));
            }
            case "TotalAvailableAddressCount": {
                return Optional.ofNullable(clazz.cast(this.totalAvailableAddressCount()));
            }
            case "NetworkBorderGroup": {
                return Optional.ofNullable(clazz.cast(this.networkBorderGroup()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PoolId", POOL_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("PoolAddressRangeSet", POOL_ADDRESS_RANGES_FIELD);
        map.put("TotalAddressCount", TOTAL_ADDRESS_COUNT_FIELD);
        map.put("TotalAvailableAddressCount", TOTAL_AVAILABLE_ADDRESS_COUNT_FIELD);
        map.put("NetworkBorderGroup", NETWORK_BORDER_GROUP_FIELD);
        map.put("TagSet", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PublicIpv4Pool, T> g) {
        return obj -> g.apply((PublicIpv4Pool)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String poolId;
        private String description;
        private List<PublicIpv4PoolRange> poolAddressRanges = DefaultSdkAutoConstructList.getInstance();
        private Integer totalAddressCount;
        private Integer totalAvailableAddressCount;
        private String networkBorderGroup;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PublicIpv4Pool model) {
            this.poolId(model.poolId);
            this.description(model.description);
            this.poolAddressRanges(model.poolAddressRanges);
            this.totalAddressCount(model.totalAddressCount);
            this.totalAvailableAddressCount(model.totalAvailableAddressCount);
            this.networkBorderGroup(model.networkBorderGroup);
            this.tags(model.tags);
        }

        public final String getPoolId() {
            return this.poolId;
        }

        public final void setPoolId(String poolId) {
            this.poolId = poolId;
        }

        @Override
        public final Builder poolId(String poolId) {
            this.poolId = poolId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<PublicIpv4PoolRange.Builder> getPoolAddressRanges() {
            List<PublicIpv4PoolRange.Builder> result = PublicIpv4PoolRangeSetCopier.copyToBuilder(this.poolAddressRanges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPoolAddressRanges(Collection<PublicIpv4PoolRange.BuilderImpl> poolAddressRanges) {
            this.poolAddressRanges = PublicIpv4PoolRangeSetCopier.copyFromBuilder(poolAddressRanges);
        }

        @Override
        public final Builder poolAddressRanges(Collection<PublicIpv4PoolRange> poolAddressRanges) {
            this.poolAddressRanges = PublicIpv4PoolRangeSetCopier.copy(poolAddressRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder poolAddressRanges(PublicIpv4PoolRange ... poolAddressRanges) {
            this.poolAddressRanges(Arrays.asList(poolAddressRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder poolAddressRanges(Consumer<PublicIpv4PoolRange.Builder> ... poolAddressRanges) {
            this.poolAddressRanges(Stream.of(poolAddressRanges).map(c -> (PublicIpv4PoolRange)((PublicIpv4PoolRange.Builder)PublicIpv4PoolRange.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getTotalAddressCount() {
            return this.totalAddressCount;
        }

        public final void setTotalAddressCount(Integer totalAddressCount) {
            this.totalAddressCount = totalAddressCount;
        }

        @Override
        public final Builder totalAddressCount(Integer totalAddressCount) {
            this.totalAddressCount = totalAddressCount;
            return this;
        }

        public final Integer getTotalAvailableAddressCount() {
            return this.totalAvailableAddressCount;
        }

        public final void setTotalAvailableAddressCount(Integer totalAvailableAddressCount) {
            this.totalAvailableAddressCount = totalAvailableAddressCount;
        }

        @Override
        public final Builder totalAvailableAddressCount(Integer totalAvailableAddressCount) {
            this.totalAvailableAddressCount = totalAvailableAddressCount;
            return this;
        }

        public final String getNetworkBorderGroup() {
            return this.networkBorderGroup;
        }

        public final void setNetworkBorderGroup(String networkBorderGroup) {
            this.networkBorderGroup = networkBorderGroup;
        }

        @Override
        public final Builder networkBorderGroup(String networkBorderGroup) {
            this.networkBorderGroup = networkBorderGroup;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public PublicIpv4Pool build() {
            return new PublicIpv4Pool(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PublicIpv4Pool> {
        public Builder poolId(String var1);

        public Builder description(String var1);

        public Builder poolAddressRanges(Collection<PublicIpv4PoolRange> var1);

        public Builder poolAddressRanges(PublicIpv4PoolRange ... var1);

        public Builder poolAddressRanges(Consumer<PublicIpv4PoolRange.Builder> ... var1);

        public Builder totalAddressCount(Integer var1);

        public Builder totalAvailableAddressCount(Integer var1);

        public Builder networkBorderGroup(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

