/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement.action;

import java.util.LinkedHashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.admin.indices.alias.Alias;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.indexmanagement.indexstatemanagement.step.shrink.AttemptMoveShardsStep;
import org.opensearch.indexmanagement.indexstatemanagement.step.shrink.AttemptShrinkStep;
import org.opensearch.indexmanagement.indexstatemanagement.step.shrink.ShrinkStep;
import org.opensearch.indexmanagement.indexstatemanagement.step.shrink.WaitForMoveShardsStep;
import org.opensearch.indexmanagement.indexstatemanagement.step.shrink.WaitForShrinkStep;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.spi.indexstatemanagement.Action;
import org.opensearch.indexmanagement.spi.indexstatemanagement.Step;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.StepContext;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.StepMetaData;
import org.opensearch.script.Script;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 =2\u00020\u0001:\u0001=B[\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e\u0012\u0006\u0010\u0010\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000e\u00101\u001a\b\u0012\u0004\u0012\u00020/0\u000bH\u0016J\u0010\u00102\u001a\u00020/2\u0006\u00103\u001a\u000204H\u0016J\u0018\u00105\u001a\u0002062\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:H\u0016J\u0010\u00105\u001a\u0002062\u0006\u0010;\u001a\u00020<H\u0016R\u0015\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\n\n\u0002\u0010\u001a\u001a\u0004\b\u0018\u0010\u0019R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0019\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0015\u0010\u000f\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\n\n\u0002\u0010#\u001a\u0004\b!\u0010\"R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010,\u001a\u001e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020/0-j\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020/`0X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/action/ShrinkAction;", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/Action;", "numNewShards", "", "maxShardSize", "Lorg/opensearch/core/common/unit/ByteSizeValue;", "percentageOfSourceShards", "", "targetIndexTemplate", "Lorg/opensearch/script/Script;", "aliases", "", "Lorg/opensearch/action/admin/indices/alias/Alias;", "switchAliases", "", "forceUnsafe", "index", "<init>", "(Ljava/lang/Integer;Lorg/opensearch/core/common/unit/ByteSizeValue;Ljava/lang/Double;Lorg/opensearch/script/Script;Ljava/util/List;ZLjava/lang/Boolean;I)V", "getNumNewShards", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getMaxShardSize", "()Lorg/opensearch/core/common/unit/ByteSizeValue;", "getPercentageOfSourceShards", "()Ljava/lang/Double;", "Ljava/lang/Double;", "getTargetIndexTemplate", "()Lorg/opensearch/script/Script;", "getAliases", "()Ljava/util/List;", "getSwitchAliases", "()Z", "getForceUnsafe", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "attemptMoveShardsStep", "Lorg/opensearch/indexmanagement/indexstatemanagement/step/shrink/AttemptMoveShardsStep;", "waitForMoveShardsStep", "Lorg/opensearch/indexmanagement/indexstatemanagement/step/shrink/WaitForMoveShardsStep;", "attemptShrinkStep", "Lorg/opensearch/indexmanagement/indexstatemanagement/step/shrink/AttemptShrinkStep;", "waitForShrinkStep", "Lorg/opensearch/indexmanagement/indexstatemanagement/step/shrink/WaitForShrinkStep;", "stepNameToStep", "Ljava/util/LinkedHashMap;", "", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/Step;", "Lkotlin/collections/LinkedHashMap;", "getSteps", "getStepToExecute", "context", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/StepContext;", "populateAction", "", "builder", "Lorg/opensearch/core/xcontent/XContentBuilder;", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "Companion", "opensearch-index-management"})
@SourceDebugExtension(value={"SMAP\nShrinkAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShrinkAction.kt\norg/opensearch/indexmanagement/indexstatemanagement/action/ShrinkAction\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,148:1\n12797#2,3:149\n1#3:152\n*S KotlinDebug\n*F\n+ 1 ShrinkAction.kt\norg/opensearch/indexmanagement/indexstatemanagement/action/ShrinkAction\n*L\n36#1:149,3\n*E\n"})
public final class ShrinkAction
extends Action {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Integer numNewShards;
    @Nullable
    private final ByteSizeValue maxShardSize;
    @Nullable
    private final Double percentageOfSourceShards;
    @Nullable
    private final Script targetIndexTemplate;
    @Nullable
    private final List<Alias> aliases;
    private final boolean switchAliases;
    @Nullable
    private final Boolean forceUnsafe;
    @NotNull
    private final AttemptMoveShardsStep attemptMoveShardsStep;
    @NotNull
    private final WaitForMoveShardsStep waitForMoveShardsStep;
    @NotNull
    private final AttemptShrinkStep attemptShrinkStep;
    @NotNull
    private final WaitForShrinkStep waitForShrinkStep;
    @NotNull
    private final LinkedHashMap<String, Step> stepNameToStep;
    @NotNull
    public static final String name = "shrink";
    @NotNull
    public static final String NUM_NEW_SHARDS_FIELD = "num_new_shards";
    @NotNull
    public static final String PERCENTAGE_OF_SOURCE_SHARDS_FIELD = "percentage_of_source_shards";
    @NotNull
    public static final String MAX_SHARD_SIZE_FIELD = "max_shard_size";
    @NotNull
    public static final String TARGET_INDEX_TEMPLATE_FIELD = "target_index_name_template";
    @NotNull
    public static final String ALIASES_FIELD = "aliases";
    @NotNull
    public static final String SWITCH_ALIASES = "switch_aliases";
    @NotNull
    public static final String FORCE_UNSAFE_FIELD = "force_unsafe";
    @NotNull
    public static final String LOCK_SOURCE_JOB_ID = "shrink-node_name";

    public ShrinkAction(@Nullable Integer numNewShards, @Nullable ByteSizeValue maxShardSize, @Nullable Double percentageOfSourceShards, @Nullable Script targetIndexTemplate, @Nullable List<? extends Alias> aliases, boolean switchAliases2, @Nullable Boolean forceUnsafe, int index2) {
        super(name, index2);
        this.numNewShards = numNewShards;
        this.maxShardSize = maxShardSize;
        this.percentageOfSourceShards = percentageOfSourceShards;
        this.targetIndexTemplate = targetIndexTemplate;
        this.aliases = aliases;
        this.switchAliases = switchAliases2;
        this.forceUnsafe = forceUnsafe;
        Boolean[] booleanArray = new Boolean[]{this.maxShardSize != null, this.percentageOfSourceShards != null, this.numNewShards != null};
        Boolean[] $this$count$iv = booleanArray;
        boolean $i$f$count = false;
        int count$iv = 0;
        for (Boolean element$iv : $this$count$iv) {
            boolean it = element$iv;
            boolean bl = false;
            if (!it) continue;
            ++count$iv;
        }
        int numSet = count$iv;
        if (!(numSet == 1)) {
            boolean $i$a$-require-ShrinkAction$62 = false;
            String $i$a$-require-ShrinkAction$62 = "Exactly one option specifying the number of shards to shrink to must be used.";
            throw new IllegalArgumentException($i$a$-require-ShrinkAction$62.toString());
        }
        if (this.maxShardSize != null && !(this.maxShardSize.getBytes() > 0L)) {
            boolean $i$a$-require-ShrinkAction$72 = false;
            String $i$a$-require-ShrinkAction$72 = "Shrink action maxShardSize must be greater than 0.";
            throw new IllegalArgumentException($i$a$-require-ShrinkAction$72.toString());
        }
        if (this.percentageOfSourceShards != null && !(this.percentageOfSourceShards > 0.0 && this.percentageOfSourceShards < 1.0)) {
            boolean $i$a$-require-ShrinkAction$82 = false;
            String $i$a$-require-ShrinkAction$82 = "Percentage of source shards must be between 0.0 and 1.0 exclusively";
            throw new IllegalArgumentException($i$a$-require-ShrinkAction$82.toString());
        }
        if (this.numNewShards != null && !(this.numNewShards > 0)) {
            boolean $i$a$-require-ShrinkAction$92 = false;
            String $i$a$-require-ShrinkAction$92 = "Shrink action numNewShards must be greater than 0.";
            throw new IllegalArgumentException($i$a$-require-ShrinkAction$92.toString());
        }
        if (this.targetIndexTemplate != null && !Intrinsics.areEqual((Object)this.targetIndexTemplate.getLang(), (Object)"mustache")) {
            boolean bl = false;
            String string = "Target index name template must be a mustache script";
            throw new IllegalArgumentException(string.toString());
        }
        this.attemptMoveShardsStep = new AttemptMoveShardsStep(this);
        this.waitForMoveShardsStep = new WaitForMoveShardsStep(this);
        this.attemptShrinkStep = new AttemptShrinkStep(this);
        this.waitForShrinkStep = new WaitForShrinkStep(this);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"attempt_move_shards_step", (Object)((Object)this.attemptMoveShardsStep)), TuplesKt.to((Object)"wait_for_move_shards_step", (Object)((Object)this.waitForMoveShardsStep)), TuplesKt.to((Object)"attempt_shrink_step", (Object)((Object)this.attemptShrinkStep)), TuplesKt.to((Object)"wait_for_shrink_step", (Object)((Object)this.waitForShrinkStep))};
        this.stepNameToStep = MapsKt.linkedMapOf((Pair[])pairArray);
    }

    public /* synthetic */ ShrinkAction(Integer n, ByteSizeValue byteSizeValue, Double d, Script script, List list, boolean bl, Boolean bl2, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 0x20) != 0) {
            bl = false;
        }
        this(n, byteSizeValue, d, script, list, bl, bl2, n2);
    }

    @Nullable
    public final Integer getNumNewShards() {
        return this.numNewShards;
    }

    @Nullable
    public final ByteSizeValue getMaxShardSize() {
        return this.maxShardSize;
    }

    @Nullable
    public final Double getPercentageOfSourceShards() {
        return this.percentageOfSourceShards;
    }

    @Nullable
    public final Script getTargetIndexTemplate() {
        return this.targetIndexTemplate;
    }

    @Nullable
    public final List<Alias> getAliases() {
        return this.aliases;
    }

    public final boolean getSwitchAliases() {
        return this.switchAliases;
    }

    @Nullable
    public final Boolean getForceUnsafe() {
        return this.forceUnsafe;
    }

    @NotNull
    public List<Step> getSteps() {
        ShrinkStep[] shrinkStepArray = new ShrinkStep[]{this.attemptMoveShardsStep, this.waitForMoveShardsStep, this.attemptShrinkStep, this.waitForShrinkStep};
        return CollectionsKt.listOf((Object[])shrinkStepArray);
    }

    @NotNull
    public Step getStepToExecute(@NotNull StepContext context) {
        Step.StepStatus currentStepStatus;
        StepMetaData stepMetaData;
        block32: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            StepMetaData stepMetaData2 = context.getMetadata().getStepMetaData();
            if (stepMetaData2 == null) {
                return this.attemptMoveShardsStep;
            }
            stepMetaData = stepMetaData2;
            String currentStep = stepMetaData.getName();
            if (!this.stepNameToStep.containsKey(currentStep)) {
                return this.attemptMoveShardsStep;
            }
            currentStepStatus = stepMetaData.getStepStatus();
            if (currentStepStatus != Step.StepStatus.COMPLETED) break block32;
            return switch (currentStep) {
                case "attempt_move_shards_step" -> this.waitForMoveShardsStep;
                case "wait_for_move_shards_step" -> this.attemptShrinkStep;
                case "attempt_shrink_step" -> this.waitForShrinkStep;
                default -> this.attemptMoveShardsStep;
            };
        }
        if (currentStepStatus == Step.StepStatus.FAILED) {
            return this.attemptMoveShardsStep;
        }
        return switch (stepMetaData.getName()) {
            case "attempt_move_shards_step" -> this.attemptMoveShardsStep;
            case "wait_for_move_shards_step" -> this.waitForMoveShardsStep;
            case "attempt_shrink_step" -> this.attemptShrinkStep;
            case "wait_for_shrink_step" -> this.waitForShrinkStep;
            default -> this.attemptMoveShardsStep;
        };
    }

    public void populateAction(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        builder.startObject(this.getType());
        if (this.numNewShards != null) {
            builder.field(NUM_NEW_SHARDS_FIELD, this.numNewShards.intValue());
        }
        if (this.maxShardSize != null) {
            builder.field(MAX_SHARD_SIZE_FIELD, this.maxShardSize.getStringRep());
        }
        if (this.percentageOfSourceShards != null) {
            builder.field(PERCENTAGE_OF_SOURCE_SHARDS_FIELD, this.percentageOfSourceShards.doubleValue());
        }
        if (this.targetIndexTemplate != null) {
            builder.field(TARGET_INDEX_TEMPLATE_FIELD, (ToXContent)this.targetIndexTemplate);
        }
        if (this.aliases != null) {
            OpenSearchExtensionsKt.aliasesField(builder, this.aliases);
        }
        builder.field(SWITCH_ALIASES, this.switchAliases);
        if (this.forceUnsafe != null) {
            builder.field(FORCE_UNSAFE_FIELD, this.forceUnsafe.booleanValue());
        }
        builder.endObject();
    }

    public void populateAction(@NotNull StreamOutput out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeOptionalInt(this.numNewShards);
        out.writeOptionalWriteable((Writeable)this.maxShardSize);
        out.writeOptionalDouble(this.percentageOfSourceShards);
        out.writeBoolean(this.targetIndexTemplate != null);
        Script script = this.targetIndexTemplate;
        if (script != null) {
            script.writeTo(out);
        }
        if (this.aliases != null) {
            out.writeBoolean(true);
            out.writeList(this.aliases);
        } else {
            out.writeBoolean(false);
        }
        out.writeBoolean(this.switchAliases);
        out.writeOptionalBoolean(this.forceUnsafe);
        out.writeInt(this.getActionIndex());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/action/ShrinkAction$Companion;", "", "<init>", "()V", "name", "", "NUM_NEW_SHARDS_FIELD", "PERCENTAGE_OF_SOURCE_SHARDS_FIELD", "MAX_SHARD_SIZE_FIELD", "TARGET_INDEX_TEMPLATE_FIELD", "ALIASES_FIELD", "SWITCH_ALIASES", "FORCE_UNSAFE_FIELD", "LOCK_SOURCE_JOB_ID", "getSecurityFailureMessage", "failure", "opensearch-index-management"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getSecurityFailureMessage(@NotNull String failure) {
            Intrinsics.checkNotNullParameter((Object)failure, (String)"failure");
            return "Shrink action failed because of missing permissions: " + failure;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

