/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.cv.translator;

import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.ImageFactory;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.types.Shape;
import ai.djl.translate.NoBatchifyTranslator;
import ai.djl.translate.TranslatorContext;

public final class BigGANTranslator
implements NoBatchifyTranslator<int[], Image[]> {
    private static final int NUMBER_OF_CATEGORIES = 1000;
    private static final int SEED_COLUMN_SIZE = 128;
    private float truncation;

    public BigGANTranslator(float truncation) {
        this.truncation = truncation;
    }

    @Override
    public Image[] processOutput(TranslatorContext ctx, NDList list) {
        NDArray output = ((NDArray)list.get(0)).duplicate().addi(1).muli(128).clip(0, 255);
        int sampleSize = (int)output.getShape().get(0);
        Image[] images = new Image[sampleSize];
        for (int i = 0; i < sampleSize; ++i) {
            images[i] = ImageFactory.getInstance().fromNDArray(output.get(i));
        }
        return images;
    }

    @Override
    public NDList processInput(TranslatorContext ctx, int[] input) throws Exception {
        NDManager manager = ctx.getNDManager();
        NDArray classes = manager.create(input).oneHot(1000);
        NDArray seed = manager.truncatedNormal(new Shape(input.length, 128L)).muli(Float.valueOf(this.truncation));
        return new NDList(seed, classes, manager.create(this.truncation));
    }
}

