/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class LatLonGeoLocation
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, LatLonGeoLocation> {
    private final double lat;
    private final double lon;
    public static final JsonpDeserializer<LatLonGeoLocation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, LatLonGeoLocation::setupLatLonGeoLocationDeserializer);

    private LatLonGeoLocation(Builder builder) {
        this.lat = ApiTypeHelper.requireNonNull(builder.lat, this, "lat");
        this.lon = ApiTypeHelper.requireNonNull(builder.lon, this, "lon");
    }

    public static LatLonGeoLocation of(Function<Builder, ObjectBuilder<LatLonGeoLocation>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final double lat() {
        return this.lat;
    }

    public final double lon() {
        return this.lon;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("lat");
        generator.write(this.lat);
        generator.writeKey("lon");
        generator.write(this.lon);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupLatLonGeoLocationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::lat, JsonpDeserializer.doubleDeserializer(), "lat");
        op.add(Builder::lon, JsonpDeserializer.doubleDeserializer(), "lon");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Double.hashCode(this.lat);
        result = 31 * result + Double.hashCode(this.lon);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LatLonGeoLocation other = (LatLonGeoLocation)o;
        return this.lat == other.lat && this.lon == other.lon;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, LatLonGeoLocation> {
        private Double lat;
        private Double lon;

        public Builder() {
        }

        private Builder(LatLonGeoLocation o) {
            this.lat = o.lat;
            this.lon = o.lon;
        }

        private Builder(Builder o) {
            this.lat = o.lat;
            this.lon = o.lon;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder lat(double value) {
            this.lat = value;
            return this;
        }

        @Nonnull
        public final Builder lon(double value) {
            this.lon = value;
            return this;
        }

        @Override
        @Nonnull
        public LatLonGeoLocation build() {
            this._checkSingleUse();
            return new LatLonGeoLocation(this);
        }
    }
}

