/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.search;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.json.UnionDeserializer;
import org.opensearch.client.opensearch.core.search.BuiltinHighlighterType;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.TaggedUnion;
import org.opensearch.client.util.TaggedUnionUtils;

@JsonpDeserializable
public class HighlighterType
implements TaggedUnion<Kind, Object>,
PlainJsonSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<HighlighterType> _DESERIALIZER = JsonpDeserializer.lazy(HighlighterType::buildHighlighterTypeDeserializer);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    private HighlighterType(Kind kind, Object value) {
        this._kind = kind;
        this._value = value;
    }

    private HighlighterType(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static HighlighterType of(Function<Builder, ObjectBuilder<HighlighterType>> fn) {
        return fn.apply(new Builder()).build();
    }

    public String _toJsonString() {
        switch (this._kind.ordinal()) {
            case 0: {
                return this.builtin().jsonValue();
            }
            case 1: {
                return this.custom();
            }
        }
        throw new IllegalStateException("Unknown kind " + (Object)((Object)this._kind));
    }

    public boolean isBuiltin() {
        return this._kind == Kind.Builtin;
    }

    public BuiltinHighlighterType builtin() {
        return (BuiltinHighlighterType)TaggedUnionUtils.get(this, Kind.Builtin);
    }

    public boolean isCustom() {
        return this._kind == Kind.Custom;
    }

    public String custom() {
        return (String)TaggedUnionUtils.get(this, Kind.Custom);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        } else {
            switch (this._kind.ordinal()) {
                case 1: {
                    generator.write((String)this._value);
                }
            }
        }
    }

    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    private static JsonpDeserializer<HighlighterType> buildHighlighterTypeDeserializer() {
        return new UnionDeserializer.Builder<HighlighterType, Kind, Object>(HighlighterType::new, true).addMember(Kind.Builtin, BuiltinHighlighterType._DESERIALIZER).addMember(Kind.Custom, JsonpDeserializer.stringDeserializer()).build();
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode((Object)this._kind);
        result = 31 * result + Objects.hashCode(this._value);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HighlighterType other = (HighlighterType)o;
        return Objects.equals((Object)this._kind, (Object)other._kind) && Objects.equals(this._value, other._value);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<HighlighterType> {
        private Kind _kind;
        private Object _value;

        public Builder() {
        }

        private Builder(HighlighterType o) {
            this._kind = o._kind;
            this._value = o._value;
        }

        public ObjectBuilder<HighlighterType> builtin(BuiltinHighlighterType v) {
            this._kind = Kind.Builtin;
            this._value = v;
            return this;
        }

        public ObjectBuilder<HighlighterType> custom(String v) {
            this._kind = Kind.Custom;
            this._value = v;
            return this;
        }

        @Override
        public HighlighterType build() {
            this._checkSingleUse();
            return new HighlighterType(this);
        }
    }

    public static enum Kind {
        Builtin,
        Custom;

    }
}

