/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BackupType {
    USER("USER"),
    SYSTEM("SYSTEM"),
    AWS_BACKUP("AWS_BACKUP"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BackupType> VALUE_MAP;
    private final String value;

    private BackupType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BackupType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BackupType> knownValues() {
        EnumSet<BackupType> knownValues = EnumSet.allOf(BackupType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BackupType.class, BackupType::toString);
    }
}

