/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.xbill.DNS.spi;

import [Ljava.net.InetAddress;;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import org.apache.hadoop.shaded.org.xbill.DNS.AAAARecord;
import org.apache.hadoop.shaded.org.xbill.DNS.ARecord;
import org.apache.hadoop.shaded.org.xbill.DNS.ExtendedResolver;
import org.apache.hadoop.shaded.org.xbill.DNS.Lookup;
import org.apache.hadoop.shaded.org.xbill.DNS.Name;
import org.apache.hadoop.shaded.org.xbill.DNS.PTRRecord;
import org.apache.hadoop.shaded.org.xbill.DNS.Record;
import org.apache.hadoop.shaded.org.xbill.DNS.ReverseMap;
import org.apache.hadoop.shaded.org.xbill.DNS.TextParseException;

public class DNSJavaNameService
implements InvocationHandler {
    private static final String nsProperty = "sun.net.spi.nameservice.nameservers";
    private static final String domainProperty = "sun.net.spi.nameservice.domain";
    private static final String v6Property = "java.net.preferIPv6Addresses";
    private boolean preferV6 = false;

    protected DNSJavaNameService() {
        String nameServers = System.getProperty(nsProperty);
        String domain = System.getProperty(domainProperty);
        String v6 = System.getProperty(v6Property);
        if (nameServers != null) {
            StringTokenizer st = new StringTokenizer(nameServers, ",");
            String[] servers = new String[st.countTokens()];
            int n = 0;
            while (st.hasMoreTokens()) {
                servers[n++] = st.nextToken();
            }
            try {
                ExtendedResolver res = new ExtendedResolver(servers);
                Lookup.setDefaultResolver(res);
            }
            catch (UnknownHostException e) {
                System.err.println("DNSJavaNameService: invalid sun.net.spi.nameservice.nameservers");
            }
        }
        if (domain != null) {
            try {
                Lookup.setDefaultSearchPath(new String[]{domain});
            }
            catch (TextParseException e) {
                System.err.println("DNSJavaNameService: invalid sun.net.spi.nameservice.domain");
            }
        }
        if (v6 != null && v6.equalsIgnoreCase("true")) {
            this.preferV6 = true;
        }
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            if (method.getName().equals("getHostByAddr")) {
                return this.getHostByAddr((byte[])args[0]);
            }
            if (method.getName().equals("lookupAllHostAddr")) {
                InetAddress[] addresses = this.lookupAllHostAddr((String)args[0]);
                Class<?> returnType = method.getReturnType();
                if (returnType.equals(InetAddress;.class)) {
                    return addresses;
                }
                if (returnType.equals([[B.class)) {
                    int naddrs = addresses.length;
                    byte[][] byteAddresses = new byte[naddrs][];
                    for (int i = 0; i < naddrs; ++i) {
                        byte[] addr = addresses[i].getAddress();
                        byteAddresses[i] = addr;
                    }
                    return byteAddresses;
                }
            }
        }
        catch (Throwable e) {
            System.err.println("DNSJavaNameService: Unexpected error.");
            e.printStackTrace();
            throw e;
        }
        throw new IllegalArgumentException("Unknown function name or arguments.");
    }

    public InetAddress[] lookupAllHostAddr(String host) throws UnknownHostException {
        Name name = null;
        try {
            name = new Name(host);
        }
        catch (TextParseException e) {
            throw new UnknownHostException(host);
        }
        Record[] records = null;
        if (this.preferV6) {
            records = new Lookup(name, 28).run();
        }
        if (records == null) {
            records = new Lookup(name, 1).run();
        }
        if (records == null && !this.preferV6) {
            records = new Lookup(name, 28).run();
        }
        if (records == null) {
            throw new UnknownHostException(host);
        }
        InetAddress[] array = new InetAddress[records.length];
        for (int i = 0; i < records.length; ++i) {
            Record record = records[i];
            if (records[i] instanceof ARecord) {
                ARecord a = (ARecord)records[i];
                array[i] = a.getAddress();
                continue;
            }
            AAAARecord aaaa = (AAAARecord)records[i];
            array[i] = aaaa.getAddress();
        }
        return array;
    }

    public String getHostByAddr(byte[] addr) throws UnknownHostException {
        Name name = ReverseMap.fromAddress(InetAddress.getByAddress(addr));
        Record[] records = new Lookup(name, 12).run();
        if (records == null) {
            throw new UnknownHostException();
        }
        return ((PTRRecord)records[0]).getTarget().toString();
    }
}

