/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.yarn.api.records.NodeAttribute;
import org.apache.hadoop.yarn.api.records.impl.pb.NodeAttributePBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeToAttributes;

public class NodeToAttributesPBImpl
extends NodeToAttributes {
    private YarnProtos.NodeToAttributesProto proto = YarnProtos.NodeToAttributesProto.getDefaultInstance();
    private YarnProtos.NodeToAttributesProto.Builder builder = null;
    private boolean viaProto = false;
    private List<NodeAttribute> nodeAttributes = null;

    public NodeToAttributesPBImpl() {
        this.builder = YarnProtos.NodeToAttributesProto.newBuilder();
    }

    public NodeToAttributesPBImpl(YarnProtos.NodeToAttributesProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        if (this.nodeAttributes != null) {
            for (NodeAttribute nodeAttribute : this.nodeAttributes) {
                this.builder.addNodeAttributes(((NodeAttributePBImpl)nodeAttribute).getProto());
            }
        }
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    public YarnProtos.NodeToAttributesProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnProtos.NodeToAttributesProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    @Override
    public String getNode() {
        YarnProtos.NodeToAttributesProtoOrBuilder p;
        YarnProtos.NodeToAttributesProtoOrBuilder nodeToAttributesProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasNode()) {
            return null;
        }
        return p.getNode();
    }

    @Override
    public void setNode(String node) {
        this.maybeInitBuilder();
        this.builder.setNode(node);
    }

    private void initNodeAttributes() {
        if (this.nodeAttributes != null) {
            return;
        }
        YarnProtos.NodeToAttributesProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnProtos.NodeAttributeProto> nodeAttributesProtoList = p.getNodeAttributesList();
        ArrayList<NodeAttribute> attributes = new ArrayList<NodeAttribute>();
        if (nodeAttributesProtoList == null || nodeAttributesProtoList.size() == 0) {
            this.nodeAttributes = attributes;
            return;
        }
        for (YarnProtos.NodeAttributeProto nodeAttributeProto : nodeAttributesProtoList) {
            attributes.add(new NodeAttributePBImpl(nodeAttributeProto));
        }
        this.nodeAttributes = attributes;
    }

    @Override
    public List<NodeAttribute> getNodeAttributes() {
        this.initNodeAttributes();
        return this.nodeAttributes;
    }

    @Override
    public void setNodeAttributes(List<NodeAttribute> attributes) {
        if (this.nodeAttributes == null) {
            this.nodeAttributes = new ArrayList<NodeAttribute>();
        }
        this.nodeAttributes.clear();
        this.nodeAttributes.addAll(attributes);
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof NodeToAttributes) {
            NodeToAttributes other = (NodeToAttributes)obj;
            if (this.getNodeAttributes() == null ? other.getNodeAttributes() != null : !this.getNodeAttributes().containsAll(other.getNodeAttributes())) {
                return false;
            }
            return !(this.getNode() == null ? other.getNode() != null : !this.getNode().equals(other.getNode()));
        }
        return false;
    }
}

