/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.io;

import software.amazon.awssdk.crt.CrtResource;
import software.amazon.awssdk.crt.io.Pkcs11Lib;

public class TlsContextPkcs11Options
extends CrtResource {
    Pkcs11Lib pkcs11Lib;
    String userPin;
    Long slotId;
    String tokenLabel;
    String privateKeyObjectLabel;
    String certificateFilePath;
    String certificateFileContents;

    public TlsContextPkcs11Options(Pkcs11Lib pkcs11Lib) {
        this.addReferenceTo(pkcs11Lib);
        this.pkcs11Lib = pkcs11Lib;
    }

    public TlsContextPkcs11Options withUserPin(String pin) {
        this.userPin = pin;
        return this;
    }

    public TlsContextPkcs11Options withSlotId(long slotId) {
        this.slotId = slotId;
        return this;
    }

    public TlsContextPkcs11Options withTokenLabel(String label) {
        this.tokenLabel = label;
        return this;
    }

    public TlsContextPkcs11Options withPrivateKeyObjectLabel(String label) {
        this.privateKeyObjectLabel = label;
        return this;
    }

    public TlsContextPkcs11Options withCertificateFilePath(String path) {
        this.certificateFilePath = path;
        return this;
    }

    public TlsContextPkcs11Options withCertificateFileContents(String contents) {
        this.certificateFileContents = contents;
        return this;
    }

    @Override
    protected void releaseNativeHandle() {
    }

    @Override
    protected boolean canReleaseReferencesImmediately() {
        return true;
    }
}

