/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.font;

import java.awt.Font;
import java.util.Objects;
import net.sourceforge.plantuml.klimt.font.FontStack;
import net.sourceforge.plantuml.klimt.font.UFontContext;

public class UFont {
    private final FontStack fontStack;
    private final int style;
    private final int size;

    public static UFont build(String fullDefinition, int fontStyle, int fontSize) {
        FontStack fontStack = new FontStack(fullDefinition);
        return new UFont(fontStack, fontStyle, fontSize);
    }

    private UFont(FontStack fontStack, int style, int size) {
        this.fontStack = fontStack;
        this.style = style;
        this.size = size;
    }

    public static UFont serif(int size) {
        return UFont.build("Serif", 0, size);
    }

    public static UFont sansSerif(int size) {
        return UFont.build("SansSerif", 0, size);
    }

    public static UFont courier(int size) {
        return UFont.build("Courier", 0, size);
    }

    public static UFont byDefault(int size) {
        return UFont.sansSerif(12);
    }

    public static UFont monospaced(int size) {
        return UFont.build("Monospaced", 0, size);
    }

    public final Font getUnderlayingFont(String text) {
        return this.fontStack.getFont(text, this.style, this.size);
    }

    public UFont withSize(float size) {
        return new UFont(this.fontStack, this.style, (int)size);
    }

    public UFont withStyle(int style) {
        return new UFont(this.fontStack, style, this.size);
    }

    public UFont bold() {
        return this.withStyle(1);
    }

    public UFont italic() {
        return this.withStyle(2);
    }

    public int getStyle() {
        return this.style;
    }

    public int getSize() {
        return this.size;
    }

    public double getSize2D() {
        return this.size;
    }

    public boolean isBold() {
        return (this.style & 1) != 0;
    }

    public boolean isItalic() {
        return (this.style & 2) != 0;
    }

    public String getFamily(String text, UFontContext context) {
        if (context == UFontContext.EPS) {
            return this.getUnderlayingFont(text).getPSName();
        }
        if (context == UFontContext.SVG) {
            String result = this.fontStack.getFullDefinition().replace('\"', '\'');
            result = result.replaceAll("(?i)sansserif", "sans-serif");
            return result;
        }
        throw new IllegalArgumentException();
    }

    private String getPortableFontName() {
        Font font = this.getUnderlayingFont(null);
        String name = font.getFontName();
        if (font.isBold() && font.isItalic()) {
            return name.endsWith(".bolditalic") ? name : name + ".bolditalic";
        }
        if (font.isBold()) {
            return name.endsWith(".bold") ? name : name + ".bold";
        }
        if (font.isItalic()) {
            return name.endsWith(".italic") ? name : name + ".italic";
        }
        return name.endsWith(".plain") ? name : name + ".plain";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getPortableFontName());
        sb.append("/");
        sb.append(this.getSize());
        return sb.toString();
    }

    public int hashCode() {
        return Objects.hash(this.fontStack, this.style, this.size);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof UFont)) {
            return false;
        }
        UFont other = (UFont)obj;
        return Objects.equals(this.fontStack, other.fontStack) && this.style == other.style && this.size == other.size;
    }
}

