/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.options;

import com.google.common.collect.Lists;
import com.google.common.math.DoubleMath;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LLabel;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.core.data.LayoutMetaDataService;
import org.eclipse.elk.core.data.LayoutOptionData;
import org.eclipse.elk.core.util.ElkSpacings;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.IPropertyHolder;

public final class LayeredSpacings {
    public static final BiFunction<IPropertyHolder, IProperty<?>, Boolean> OPTION_TARGET_FILTER = (e, property) -> {
        LayoutOptionData optionData = LayoutMetaDataService.getInstance().getOptionData(property.getId());
        if (optionData != null) {
            Set<LayoutOptionData.Target> targets = optionData.getTargets();
            if (e instanceof LGraph) {
                if (!targets.contains((Object)LayoutOptionData.Target.NODES) && !targets.contains((Object)LayoutOptionData.Target.PARENTS)) {
                    return false;
                }
                return true;
            }
            if (e instanceof LNode) {
                return targets.contains((Object)LayoutOptionData.Target.NODES);
            }
            if (e instanceof LEdge) {
                return targets.contains((Object)LayoutOptionData.Target.EDGES);
            }
            if (e instanceof LPort) {
                return targets.contains((Object)LayoutOptionData.Target.PORTS);
            }
            if (e instanceof LLabel) {
                return targets.contains((Object)LayoutOptionData.Target.LABELS);
            }
        }
        return true;
    };

    private LayeredSpacings() {
    }

    public static LayeredSpacingsBuilder withBaseValue(double baseSpacing) {
        return new LayeredSpacingsBuilder(baseSpacing);
    }

    public static final class LayeredSpacingsBuilder
    extends ElkSpacings.AbstractSpacingsBuilder<LayeredSpacingsBuilder> {
        public static final IProperty<Double> BASE_SPACING_OPTION = LayeredOptions.SPACING_NODE_NODE;
        private static final List<IProperty<Double>> DEPENDENT_SPACING_OPTIONS = Lists.newArrayList(LayeredOptions.SPACING_COMPONENT_COMPONENT, LayeredOptions.SPACING_EDGE_EDGE, LayeredOptions.SPACING_EDGE_LABEL, LayeredOptions.SPACING_EDGE_NODE, LayeredOptions.SPACING_LABEL_LABEL, LayeredOptions.SPACING_LABEL_NODE, LayeredOptions.SPACING_LABEL_PORT_HORIZONTAL, LayeredOptions.SPACING_LABEL_PORT_VERTICAL, LayeredOptions.SPACING_NODE_SELF_LOOP, LayeredOptions.SPACING_PORT_PORT, LayeredOptions.SPACING_EDGE_EDGE_BETWEEN_LAYERS, LayeredOptions.SPACING_EDGE_NODE_BETWEEN_LAYERS, LayeredOptions.SPACING_NODE_NODE_BETWEEN_LAYERS);

        static {
            assert (BASE_SPACING_OPTION.getDefault() != null) : "Base spacing default value must be non-null.";
            assert (!DoubleMath.fuzzyEquals(0.0, BASE_SPACING_OPTION.getDefault(), 1.0E-4)) : "Base spacing default value must be different from 0.0d.";
        }

        private LayeredSpacingsBuilder(double d) {
            super(d);
        }

        @Override
        public LayeredSpacingsBuilder thisT() {
            return this;
        }

        @Override
        protected IProperty<Double> getBaseSpacingOption() {
            return BASE_SPACING_OPTION;
        }

        protected List<IProperty<Double>> getDependendSpacingOptions() {
            return DEPENDENT_SPACING_OPTIONS;
        }
    }
}

