/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.ssl;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.ssl.ASN1Helper;
import com.oracle.graal.python.builtins.objects.ssl.LazyBouncyCastleProvider;
import com.oracle.graal.python.builtins.objects.ssl.SSLErrorCode;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PConstructAndRaiseNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.strings.TruffleString;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Reader;
import java.math.BigInteger;
import java.nio.file.LinkOption;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8DecryptorProviderBuilder;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.PKCSException;
import org.bouncycastle.util.encoders.DecoderException;

public final class CertUtils {
    private static final TruffleString T_UNSUPPORTED = PythonUtils.tsLiteral("<unsupported>");
    private static final TruffleString T_OTHERNAME = PythonUtils.tsLiteral("othername");
    private static final TruffleString T_EMAIL = PythonUtils.tsLiteral("email");
    private static final TruffleString T_DNS = PythonUtils.tsLiteral("DNS");
    private static final TruffleString T_X_400_NAME = PythonUtils.tsLiteral("X400Name");
    private static final TruffleString T_DIR_NAME = PythonUtils.tsLiteral("DirName");
    private static final TruffleString T_EDI_PARTY_NAME = PythonUtils.tsLiteral("EdiPartyName");
    private static final TruffleString T_URI = PythonUtils.tsLiteral("URI");
    private static final TruffleString T_IP_ADDRESS = PythonUtils.tsLiteral("IP Address");
    private static final TruffleString T_REGISTERED_ID = PythonUtils.tsLiteral("Registered ID");
    private static final ZoneId zoneId = ZoneId.of("GMT");
    private static final DateTimeFormatter DF = DateTimeFormatter.ofPattern("MMM ppd HH:mm:ss yyyy z");

    @CompilerDirectives.TruffleBoundary
    static boolean isCA(X509Certificate cert, boolean[] keyUsage) {
        return keyUsage != null && keyUsage.length > 5 && keyUsage[5] || cert.getBasicConstraints() != -1 || cert.getVersion() == 1 && CertUtils.isSelfSigned(cert);
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean[] getKeyUsage(X509Certificate cert) {
        return cert.getKeyUsage();
    }

    @CompilerDirectives.TruffleBoundary
    public static byte[] getEncoded(X509Certificate cert) throws CertificateEncodingException {
        return cert.getEncoded();
    }

    @CompilerDirectives.TruffleBoundary
    static boolean isSelfSigned(X509Certificate cert) {
        try {
            cert.verify(cert.getPublicKey());
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CertificateException e) {
            return false;
        }
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    static boolean isCrl(boolean[] keyUsage) {
        return keyUsage != null && keyUsage.length > 6 && keyUsage[6];
    }

    @CompilerDirectives.TruffleBoundary
    public static PDict decodeCertificate(X509Certificate cert, PythonLanguage language) throws CertificateParsingException {
        PDict dict = PFactory.createDict(language);
        HashingStorage storage = dict.getDictStorage();
        try {
            storage = CertUtils.setItem(storage, ASN1Helper.T_JAVA_X509_OCSP, CertUtils.parseOCSP(cert, language));
            storage = CertUtils.setItem(storage, ASN1Helper.T_JAVA_X509_CA_ISSUERS, CertUtils.parseCAIssuers(cert, language));
            storage = CertUtils.setItem(storage, ASN1Helper.T_JAVA_X509_ISSUER, CertUtils.createTupleForX509Name(cert.getIssuerX500Principal().getName("RFC1779"), language));
            storage = CertUtils.setItem(storage, ASN1Helper.T_JAVA_X509_NOT_AFTER, CertUtils.getNotAfter(cert));
            storage = CertUtils.setItem(storage, ASN1Helper.T_JAVA_X509_NOT_BEFORE, CertUtils.getNotBefore(cert));
            storage = CertUtils.setItem(storage, ASN1Helper.T_JAVA_X509_SERIAL_NUMBER, CertUtils.getSerialNumber(cert));
            storage = CertUtils.setItem(storage, ASN1Helper.T_JAVA_X509_CRL_DISTRIBUTION_POINTS, CertUtils.parseCRLPoints(cert, language));
            storage = CertUtils.setItem(storage, ASN1Helper.T_JAVA_X509_SUBJECT, CertUtils.createTupleForX509Name(cert.getSubjectX500Principal().getName("RFC1779"), language));
            storage = CertUtils.setItem(storage, ASN1Helper.T_JAVA_X509_SUBJECT_ALT_NAME, CertUtils.parseSubjectAltName(cert, language));
            storage = CertUtils.setItem(storage, ASN1Helper.T_JAVA_X509_VERSION, CertUtils.getVersion(cert));
        }
        catch (RuntimeException re) {
            throw PConstructAndRaiseNode.raiseUncachedSSLError(SSLErrorCode.ERROR_SSL, re);
        }
        dict.setDictStorage(storage);
        return dict;
    }

    private static HashingStorage setItem(HashingStorage storage, TruffleString key, Object value) {
        if (value != null) {
            return HashingStorageNodes.HashingStorageSetItem.executeUncached(storage, key, value);
        }
        return storage;
    }

    @CompilerDirectives.TruffleBoundary
    private static TruffleString getSerialNumber(X509Certificate x509Certificate) {
        String sn = x509Certificate.getSerialNumber().toString(16).toUpperCase();
        return PythonUtils.toTruffleStringUncached((String)(sn.length() % 2 == 0 ? sn : "0" + sn));
    }

    @CompilerDirectives.TruffleBoundary
    private static int getVersion(X509Certificate x509Certificate) {
        return x509Certificate.getVersion();
    }

    @CompilerDirectives.TruffleBoundary
    private static TruffleString getNotAfter(X509Certificate x509Certificate) {
        return CertUtils.formatDate(x509Certificate.getNotAfter());
    }

    @CompilerDirectives.TruffleBoundary
    private static TruffleString getNotBefore(X509Certificate x509Certificate) {
        return CertUtils.formatDate(x509Certificate.getNotBefore());
    }

    @CompilerDirectives.TruffleBoundary
    private static TruffleString formatDate(Date d) {
        return PythonUtils.toTruffleStringUncached(ZonedDateTime.ofInstant(d.toInstant(), zoneId).format(DF));
    }

    @CompilerDirectives.TruffleBoundary
    private static PTuple createTupleForX509Name(String name, PythonLanguage language) {
        ArrayList<PTuple> result = new ArrayList<PTuple>();
        for (String component : name.split(",")) {
            String[] kv = component.split("=");
            if (kv.length != 2) continue;
            PTuple innerTuple = PFactory.createTuple(language, new Object[]{ASN1Helper.translateKeyToPython(kv[0].trim()), PythonUtils.toTruffleStringUncached(kv[1].trim())});
            result.add(PFactory.createTuple(language, new Object[]{innerTuple}));
        }
        Collections.reverse(result);
        return PFactory.createTuple(language, result.toArray(new Object[0]));
    }

    @CompilerDirectives.TruffleBoundary
    private static PTuple parseSubjectAltName(X509Certificate certificate, PythonLanguage language) throws CertificateParsingException {
        ArrayList<PTuple> tuples = new ArrayList<PTuple>(16);
        Collection<List<?>> altNames = certificate.getSubjectAlternativeNames();
        if (altNames != null) {
            block11: for (List<?> altName : altNames) {
                if (altName.size() != 2 || !(altName.get(0) instanceof Integer)) continue;
                int type = (Integer)altName.get(0);
                Object value = altName.get(1);
                TruffleString stringValue = value instanceof String ? PythonUtils.toTruffleStringUncached((String)value) : T_UNSUPPORTED;
                switch (type) {
                    case 0: {
                        tuples.add(PFactory.createTuple(language, new Object[]{T_OTHERNAME, stringValue}));
                        continue block11;
                    }
                    case 1: {
                        tuples.add(PFactory.createTuple(language, new Object[]{T_EMAIL, stringValue}));
                        continue block11;
                    }
                    case 2: {
                        tuples.add(PFactory.createTuple(language, new Object[]{T_DNS, stringValue}));
                        continue block11;
                    }
                    case 3: {
                        tuples.add(PFactory.createTuple(language, new Object[]{T_X_400_NAME, stringValue}));
                        continue block11;
                    }
                    case 4: {
                        tuples.add(PFactory.createTuple(language, new Object[]{T_DIR_NAME, value instanceof String ? CertUtils.createTupleForX509Name((String)value, language) : PFactory.createEmptyTuple(language)}));
                        continue block11;
                    }
                    case 5: {
                        tuples.add(PFactory.createTuple(language, new Object[]{T_EDI_PARTY_NAME, stringValue}));
                        continue block11;
                    }
                    case 6: {
                        tuples.add(PFactory.createTuple(language, new Object[]{T_URI, stringValue}));
                        continue block11;
                    }
                    case 7: {
                        tuples.add(PFactory.createTuple(language, new Object[]{T_IP_ADDRESS, stringValue}));
                        continue block11;
                    }
                    case 8: {
                        tuples.add(PFactory.createTuple(language, new Object[]{T_REGISTERED_ID, stringValue}));
                        continue block11;
                    }
                }
            }
            return PFactory.createTuple(language, tuples.toArray(new Object[tuples.size()]));
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    private static PTuple parseCRLPoints(X509Certificate cert, PythonLanguage language) throws CertificateParsingException {
        ArrayList result = new ArrayList();
        byte[] bytes = cert.getExtensionValue("2.5.29.31");
        if (bytes == null) {
            return null;
        }
        DerValue data = new DerValue(bytes).getOctetString();
        if (data == null) {
            return null;
        }
        data.iterateSequence((element, r) -> {
            DerValue fullName;
            DerValue dpn;
            DerValue dp = element.getSequence();
            if (dp != null && (dpn = dp.getContextTag(0)) != null && (fullName = dp.getContextTag(0)) != null) {
                fullName.contentTag = 16;
                fullName.iterateSequence((name, r2) -> {
                    String nextUri = name.getGeneralNameURI();
                    if (nextUri != null) {
                        r2.add(PythonUtils.toTruffleStringUncached(nextUri));
                    }
                }, r);
            }
        }, result);
        if (result.size() > 0) {
            return PFactory.createTuple(language, result.toArray(new Object[result.size()]));
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    private static PTuple parseCAIssuers(X509Certificate cert, PythonLanguage language) throws CertificateParsingException {
        ArrayList result = new ArrayList();
        byte[] bytes = cert.getExtensionValue("1.3.6.1.5.5.7.1.1");
        if (bytes == null) {
            return null;
        }
        DerValue data = new DerValue(bytes).getOctetString();
        if (data == null) {
            return null;
        }
        data.iterateSequence((element, r) -> {
            String uri;
            DerValue accessMethod;
            List<DerValue> elements = element.getSequenceElements();
            if (elements.size() == 2 && (accessMethod = elements.get(0).getObjectIdentifier()) != null && Arrays.equals(accessMethod.getRawData(), ASN1Helper.OID_CA_ISSUERS) && (uri = elements.get(1).getGeneralNameURI()) != null) {
                r.add(PythonUtils.toTruffleStringUncached(uri));
            }
        }, result);
        if (result.size() > 0) {
            return PFactory.createTuple(language, result.toArray(new Object[result.size()]));
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    private static PTuple parseOCSP(X509Certificate cert, PythonLanguage language) throws CertificateParsingException {
        ArrayList result = new ArrayList();
        byte[] bytes = cert.getExtensionValue("1.3.6.1.5.5.7.1.1");
        if (bytes == null) {
            return null;
        }
        DerValue data = new DerValue(bytes).getOctetString();
        if (data == null) {
            return null;
        }
        data.iterateSequence((element, r) -> {
            String uri;
            DerValue accessMethod;
            List<DerValue> elements = element.getSequenceElements();
            if (elements.size() == 2 && (accessMethod = elements.get(0).getObjectIdentifier()) != null && Arrays.equals(accessMethod.getRawData(), ASN1Helper.OID_OCSP) && (uri = elements.get(1).getGeneralNameURI()) != null) {
                r.add(PythonUtils.toTruffleStringUncached(uri));
            }
        }, result);
        if (result.size() > 0) {
            return PFactory.createTuple(language, result.toArray(new Object[result.size()]));
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    public static List<Object> loadVerifyLocations(TruffleFile file, TruffleFile path) throws IOException, CertificateException, CRLException, NoCertificateFoundException {
        ArrayList<TruffleFile> files = new ArrayList<TruffleFile>();
        if (file != null) {
            files.add(file);
        }
        if (path != null && path.isDirectory(new LinkOption[0])) {
            files.addAll(path.list());
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (TruffleFile f : files) {
            BufferedReader r = f.newBufferedReader();
            try {
                List<Object> certificates = CertUtils.getCertificates(r);
                if (certificates.isEmpty()) {
                    throw new NoCertificateFoundException();
                }
                result.addAll(certificates);
            }
            finally {
                if (r == null) continue;
                r.close();
            }
        }
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    public static List<Object> getCertificates(BufferedReader r) throws IOException, CertificateException, CRLException {
        return CertUtils.getCertificates(r, false);
    }

    @CompilerDirectives.TruffleBoundary
    public static List<Object> getCertificates(BufferedReader r, boolean onlyCertificates) throws IOException, CertificateException, CRLException {
        Object object;
        ArrayList<Object> l = new ArrayList<Object>();
        PEMParser pemParser = new PEMParser((Reader)r);
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        while ((object = pemParser.readObject()) != null) {
            if (object instanceof X509CertificateHolder) {
                l.add(factory.generateCertificate(new ByteArrayInputStream(((X509CertificateHolder)object).getEncoded())));
            }
            if (onlyCertificates || !(object instanceof X509CRLHolder)) continue;
            l.add(factory.generateCRL(new ByteArrayInputStream(((X509CRLHolder)object).getEncoded())));
        }
        return l;
    }

    @CompilerDirectives.TruffleBoundary
    static PrivateKey getPrivateKey(PythonContext context, BufferedReader reader, char[] password, X509Certificate cert) throws NeedsPasswordException {
        PEMParser pemParser = new PEMParser((Reader)reader);
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
        Provider provider = LazyBouncyCastleProvider.initProvider();
        converter.setProvider(provider);
        PrivateKey privateKey = null;
        try {
            Object object;
            while ((object = pemParser.readObject()) != null) {
                PrivateKeyInfo pkInfo;
                if (object instanceof PEMKeyPair) {
                    pkInfo = ((PEMKeyPair)object).getPrivateKeyInfo();
                } else if (object instanceof PEMEncryptedKeyPair) {
                    if (password == null) {
                        throw new NeedsPasswordException();
                    }
                    JcePEMDecryptorProviderBuilder decryptor = new JcePEMDecryptorProviderBuilder();
                    decryptor.setProvider(provider);
                    PEMKeyPair keyPair = ((PEMEncryptedKeyPair)object).decryptKeyPair(decryptor.build(password));
                    pkInfo = keyPair.getPrivateKeyInfo();
                } else if (object instanceof PKCS8EncryptedPrivateKeyInfo) {
                    if (password == null) {
                        throw new NeedsPasswordException();
                    }
                    JceOpenSSLPKCS8DecryptorProviderBuilder decryptor = new JceOpenSSLPKCS8DecryptorProviderBuilder();
                    decryptor.setProvider(provider);
                    pkInfo = ((PKCS8EncryptedPrivateKeyInfo)object).decryptPrivateKeyInfo(decryptor.build(password));
                } else {
                    if (!(object instanceof PrivateKeyInfo)) continue;
                    pkInfo = (PrivateKeyInfo)object;
                }
                privateKey = converter.getPrivateKey(pkInfo);
                break;
            }
        }
        catch (IOException | OperatorCreationException | PKCSException | DecoderException e) {
            throw PConstructAndRaiseNode.raiseUncachedSSLError(SSLErrorCode.ERROR_SSL_PEM_LIB, ErrorMessages.SSL_PEM_LIB, new Object[0]);
        }
        if (privateKey == null) {
            throw PConstructAndRaiseNode.raiseUncachedSSLError(SSLErrorCode.ERROR_SSL_PEM_LIB, ErrorMessages.SSL_PEM_LIB, new Object[0]);
        }
        PublicKey publicKey = cert.getPublicKey();
        CertUtils.checkPrivateKey(context, privateKey, publicKey);
        return privateKey;
    }

    private static void checkPrivateKey(PythonContext context, PrivateKey privateKey, PublicKey publicKey) {
        try {
            Signature sign;
            try {
                sign = Signature.getInstance(String.format("SHA256with%s", privateKey.getAlgorithm()));
            }
            catch (NoSuchAlgorithmException e) {
                sign = Signature.getInstance(String.format("SHA1with%s", privateKey.getAlgorithm()));
            }
            sign.initSign(privateKey);
            byte[] data = new byte[128];
            context.getSecureRandom().nextBytes(data);
            sign.update(data);
            byte[] signature = sign.sign();
            sign.initVerify(publicKey);
            sign.update(data);
            if (sign.verify(signature)) {
                return;
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw PConstructAndRaiseNode.raiseUncachedSSLError(SSLErrorCode.ERROR_SSL, e);
        }
        catch (InvalidKeyException | SignatureException generalSecurityException) {
            // empty catch block
        }
        throw PConstructAndRaiseNode.raiseUncachedSSLError(SSLErrorCode.ERROR_KEY_VALUES_MISMATCH, ErrorMessages.KEY_VALUES_MISMATCH, new Object[0]);
    }

    @CompilerDirectives.TruffleBoundary
    static Collection<?> generateCertificates(byte[] bytes) throws CertificateException {
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        ArrayList<Certificate> list = new ArrayList<Certificate>();
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        while (is.available() > 0) {
            list.add(factory.generateCertificate(is));
        }
        return list;
    }

    @CompilerDirectives.TruffleBoundary
    static String getAlias(X509Certificate cert) throws NoSuchAlgorithmException, CertificateEncodingException {
        return CertUtils.md5(cert.getEncoded());
    }

    @CompilerDirectives.TruffleBoundary
    static String getAlias(PrivateKey pk) throws NoSuchAlgorithmException {
        return CertUtils.md5(pk.getEncoded());
    }

    @CompilerDirectives.TruffleBoundary
    private static String md5(byte[] bytes) throws NoSuchAlgorithmException {
        byte[] digest = MessageDigest.getInstance("md5").digest(bytes);
        return new BigInteger(1, digest).toString(16);
    }

    private static final class DerValue {
        private static final byte OCTET_STRING = 4;
        private static final byte OBJECT_IDENTIFIER = 6;
        private static final byte SEQUENCE = 16;
        private static final String ERROR_MESSAGE = "Invalid DER encoded data";
        final byte[] data;
        final boolean isContextTag;
        final int contentLen;
        final int contentStart;
        int contentTag;

        DerValue(byte[] data) throws CertificateParsingException {
            this(data, 0, data.length);
        }

        DerValue(byte[] data, int offset, int end) throws CertificateParsingException {
            if (offset == data.length) {
                this.data = data;
                this.contentTag = 0;
                this.isContextTag = false;
                this.contentStart = offset;
                this.contentLen = 0;
            } else if (offset < data.length) {
                this.data = data;
                this.contentTag = data[offset] & 0x1F;
                this.isContextTag = (data[offset] & 0xC0) == 128;
                int[] lenAndOffset = DerValue.readLength(data, offset);
                this.contentStart = lenAndOffset[0];
                this.contentLen = lenAndOffset[1];
                assert (this.contentTag != 31) : "extended tag range not supported";
                assert (this.contentStart + this.contentLen <= end);
            } else {
                throw new CertificateParsingException(ERROR_MESSAGE);
            }
        }

        private static int[] readLength(byte[] data, int offset) throws CertificateParsingException {
            try {
                int lenBase = data[offset + 1] & 0xFF;
                if (lenBase < 128) {
                    return new int[]{offset + 2, lenBase};
                }
                int lengthOfLength = lenBase - 128;
                if (lengthOfLength > 4) {
                    throw new IllegalArgumentException("longer than int-range DER values not supported");
                }
                int fullLength = 0;
                for (int i = 0; i < lengthOfLength; ++i) {
                    fullLength = fullLength << 8 | data[offset + 2 + i] & 0xFF;
                }
                return new int[]{offset + 2 + lengthOfLength, fullLength};
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new CertificateParsingException(ERROR_MESSAGE);
            }
        }

        byte[] getRawData() {
            return Arrays.copyOfRange(this.data, this.contentStart, this.contentStart + this.contentLen);
        }

        DerValue getObjectIdentifier() throws CertificateParsingException {
            if (this.contentTag != 6) {
                return null;
            }
            return new DerValue(this.data, this.contentStart, this.contentStart + this.contentLen);
        }

        DerValue getContextTag(int tag) throws CertificateParsingException {
            if (this.contentTag != tag || !this.isContextTag) {
                return null;
            }
            return new DerValue(this.data, this.contentStart, this.contentStart + this.contentLen);
        }

        DerValue getOctetString() throws CertificateParsingException {
            if (this.contentTag != 4) {
                return null;
            }
            return new DerValue(this.data, this.contentStart, this.contentStart + this.contentLen);
        }

        DerValue getSequence() throws CertificateParsingException {
            if (this.contentTag != 16) {
                return null;
            }
            return new DerValue(this.data, this.contentStart, this.contentStart + this.contentLen);
        }

        String getGeneralNameURI() {
            if (this.contentTag == 6) {
                return new String(this.getRawData());
            }
            return null;
        }

        List<DerValue> getSequenceElements() throws CertificateParsingException {
            ArrayList<DerValue> result = new ArrayList<DerValue>();
            this.iterateSequence((e, r) -> result.add((DerValue)e), result);
            return result;
        }

        <T> void iterateSequence(DerSequenceConsumer<DerValue, T> consumer, T value) throws CertificateParsingException {
            int sequenceStart = this.contentStart;
            int sequenceEnd = this.contentStart + this.contentLen;
            DerValue sequenceData = this.getSequence();
            if (sequenceData == null) {
                return;
            }
            int i = sequenceStart;
            while (i < sequenceEnd) {
                DerValue element = new DerValue(this.data, i, sequenceEnd);
                i = element.contentStart + element.contentLen;
                consumer.accept(element, value);
            }
        }

        @FunctionalInterface
        private static interface DerSequenceConsumer<A, B> {
            public void accept(A var1, B var2) throws CertificateParsingException;
        }
    }

    public static class NoCertificateFoundException
    extends Exception {
        private static final long serialVersionUID = 5489472143646552420L;

        public NoCertificateFoundException() {
            super("No certificate found");
        }
    }

    public static class NeedsPasswordException
    extends Exception {
        private static final long serialVersionUID = -5153912585672596522L;

        public NeedsPasswordException() {
            super("Needs password to decrypt private key");
        }
    }
}

