/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.interop;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.interop.GetInteropBehaviorValueNodeGen;
import com.oracle.graal.python.nodes.interop.InteropBehavior;
import com.oracle.graal.python.nodes.interop.InteropBehaviorMethod;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaBooleanNode;
import com.oracle.graal.python.nodes.util.CastToJavaByteNode;
import com.oracle.graal.python.nodes.util.CastToJavaDoubleNode;
import com.oracle.graal.python.nodes.util.CastToJavaIntExactNode;
import com.oracle.graal.python.nodes.util.CastToJavaLongExactNode;
import com.oracle.graal.python.nodes.util.CastToJavaShortNode;
import com.oracle.graal.python.nodes.util.CastToJavaStringNode;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;

@GenerateUncached
@GenerateInline
public abstract class GetInteropBehaviorValueNode
extends PNodeWithContext {
    public final boolean executeBoolean(Node inliningTarget, InteropBehavior behavior, InteropBehaviorMethod method, CastToJavaBooleanNode toBooleanNode, PRaiseNode raiseNode, PythonAbstractObject receiver, Object ... extraArguments) {
        assert (extraArguments.length == method.extraArguments) : "number of passed arguments to GetInteropBehaviorValueNode does not match expected number of arguments for method";
        try {
            Object value = this.execute(inliningTarget, behavior, method, receiver, extraArguments);
            try {
                return toBooleanNode.execute(inliningTarget, value);
            }
            catch (CannotCastException cce) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.S_MUST_BE_S_NOT_P, "return value", "a boolean", value);
            }
        }
        catch (UnsupportedMessageException usm) {
            return false;
        }
    }

    public final byte executeByte(Node inliningTarget, InteropBehavior behavior, InteropBehaviorMethod method, CastToJavaByteNode toByteNode, PRaiseNode raiseNode, PythonAbstractObject receiver, Object ... extraArguments) throws UnsupportedMessageException {
        assert (extraArguments.length == method.extraArguments) : "number of passed arguments to GetInteropBehaviorValueNode does not match expected number of arguments for method";
        Object value = this.execute(inliningTarget, behavior, method, receiver, extraArguments);
        try {
            return toByteNode.execute(inliningTarget, value);
        }
        catch (CannotCastException cce) {
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.S_MUST_BE_S_NOT_P, "return value", "a byte", value);
        }
    }

    public final short executeShort(Node inliningTarget, InteropBehavior behavior, InteropBehaviorMethod method, CastToJavaShortNode toShortNode, PRaiseNode raiseNode, PythonAbstractObject receiver, Object ... extraArguments) throws UnsupportedMessageException {
        assert (extraArguments.length == method.extraArguments) : "number of passed arguments to GetInteropBehaviorValueNode does not match expected number of arguments for method";
        Object value = this.execute(inliningTarget, behavior, method, receiver, extraArguments);
        try {
            return toShortNode.execute(inliningTarget, value);
        }
        catch (CannotCastException cce) {
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.S_MUST_BE_S_NOT_P, "return value", "a short", value);
        }
    }

    public final int executeInt(Node inliningTarget, InteropBehavior behavior, InteropBehaviorMethod method, CastToJavaIntExactNode toIntNode, PRaiseNode raiseNode, PythonAbstractObject receiver, Object ... extraArguments) throws UnsupportedMessageException {
        assert (extraArguments.length == method.extraArguments) : "number of passed arguments to GetInteropBehaviorValueNode does not match expected number of arguments for method";
        Object value = this.execute(inliningTarget, behavior, method, receiver, extraArguments);
        try {
            return toIntNode.execute(inliningTarget, value);
        }
        catch (CannotCastException cce) {
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.S_MUST_BE_S_NOT_P, "return value", "an int", value);
        }
    }

    public final long executeLong(Node inliningTarget, InteropBehavior behavior, InteropBehaviorMethod method, CastToJavaLongExactNode toLongNode, PRaiseNode raiseNode, PythonAbstractObject receiver, Object ... extraArguments) throws UnsupportedMessageException {
        assert (extraArguments.length == method.extraArguments) : "number of passed arguments to GetInteropBehaviorValueNode does not match expected number of arguments for method";
        Object value = this.execute(inliningTarget, behavior, method, receiver, extraArguments);
        try {
            return toLongNode.execute(inliningTarget, value);
        }
        catch (CannotCastException cce) {
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.S_MUST_BE_S_NOT_P, "return value", "a long", value);
        }
    }

    public final double executeDouble(Node inliningTarget, InteropBehavior behavior, InteropBehaviorMethod method, CastToJavaDoubleNode toDoubleNode, PRaiseNode raiseNode, PythonAbstractObject receiver, Object ... extraArguments) throws UnsupportedMessageException {
        assert (extraArguments.length == method.extraArguments) : "number of passed arguments to GetInteropBehaviorValueNode does not match expected number of arguments for method";
        Object value = this.execute(inliningTarget, behavior, method, receiver, extraArguments);
        try {
            return toDoubleNode.execute(inliningTarget, value);
        }
        catch (CannotCastException cce) {
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.S_MUST_BE_S_NOT_P, "return value", "a double", value);
        }
    }

    public final String executeString(Node inliningTarget, InteropBehavior behavior, InteropBehaviorMethod method, CastToJavaStringNode toStringNode, PRaiseNode raiseNode, PythonAbstractObject receiver, Object ... extraArguments) throws UnsupportedMessageException {
        assert (extraArguments.length == method.extraArguments) : "number of passed arguments to GetInteropBehaviorValueNode does not match expected number of arguments for method";
        Object value = this.execute(inliningTarget, behavior, method, receiver, extraArguments);
        try {
            return toStringNode.execute(value);
        }
        catch (CannotCastException cce) {
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.S_MUST_BE_S_NOT_P, "return value", "a string", value);
        }
    }

    public final Object execute(Node inliningTarget, InteropBehavior behavior, InteropBehaviorMethod method, PythonAbstractObject receiver, Object arg1, Object arg2) throws UnsupportedMessageException {
        assert (method.extraArguments == 2) : "method must take 2 arguments only";
        return this.execute(inliningTarget, behavior, method, receiver, new Object[]{arg1, arg2});
    }

    public final Object execute(Node inliningTarget, InteropBehavior behavior, InteropBehaviorMethod method, PythonAbstractObject receiver, Object arg1) throws UnsupportedMessageException {
        assert (method.extraArguments == 1) : "method must take 1 argument only";
        return this.execute(inliningTarget, behavior, method, receiver, new Object[]{arg1});
    }

    public final Object execute(Node inliningTarget, InteropBehavior behavior, InteropBehaviorMethod method, PythonAbstractObject receiver) throws UnsupportedMessageException {
        assert (method.extraArguments == 0) : "method must not take arguments";
        return this.execute(inliningTarget, behavior, method, receiver, PythonUtils.EMPTY_OBJECT_ARRAY);
    }

    public abstract Object execute(Node var1, InteropBehavior var2, InteropBehaviorMethod var3, PythonAbstractObject var4, Object[] var5) throws UnsupportedMessageException;

    @Specialization(guards={"behavior.isConstant(method)"})
    static Object getValueConstantBoolean(Node inliningTarget, InteropBehavior behavior, InteropBehaviorMethod method, PythonAbstractObject receiver, Object[] extraArguments) throws UnsupportedMessageException {
        assert (behavior.isDefined(method)) : "interop behavior method is not defined!";
        return behavior.getConstantValue(method);
    }

    @Specialization(guards={"!behavior.isConstant(method)", "method.checkArity(extraArguments)"})
    static Object getValue(Node inliningTarget, InteropBehavior behavior, InteropBehaviorMethod method, PythonAbstractObject receiver, Object[] extraArguments, @Cached SimpleInvokeNodeDispatch invokeNode2, @Cached ConvertJavaStringArguments convertArgs, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile unsupportedMessageProfile, @Cached GilNode gil) throws UnsupportedMessageException {
        assert (behavior.isDefined(method)) : "interop behavior method is not defined!";
        CallTarget callTarget = behavior.getCallTarget(method);
        Object[] pArguments = behavior.createArguments(method, receiver, convertArgs.execute(inliningTarget, extraArguments));
        boolean mustRelease = gil.acquire();
        try {
            Object object = invokeNode2.execute(inliningTarget, callTarget, pArguments);
            return object;
        }
        catch (PException pe) {
            pe.expect(inliningTarget, PythonBuiltinClassType.UnsupportedMessage, unsupportedMessageProfile);
            throw UnsupportedMessageException.create();
        }
        finally {
            gil.release(mustRelease);
        }
    }

    @Specialization(guards={"!behavior.isConstant(method)", "!method.checkArity(extraArguments)"})
    static Object getValueComputedWrongArity(Node inliningTarget, InteropBehavior behavior, InteropBehaviorMethod method, PythonAbstractObject receiver, Object[] extraArguments, @Cached PRaiseNode raiseNode) throws UnsupportedMessageException {
        assert (behavior.isDefined(method)) : "interop behavior method is not defined!";
        throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.FUNC_TAKES_EXACTLY_D_ARGS, method.extraArguments, extraArguments.length);
    }

    @NeverDefault
    public static GetInteropBehaviorValueNode create() {
        return GetInteropBehaviorValueNodeGen.create();
    }

    public static GetInteropBehaviorValueNode getUncached() {
        return GetInteropBehaviorValueNodeGen.getUncached();
    }

    @GenerateUncached
    @GenerateInline
    static abstract class ConvertJavaStringArguments
    extends Node {
        ConvertJavaStringArguments() {
        }

        public abstract Object[] execute(Node var1, Object[] var2);

        static boolean containsJavaString(Object[] arguments) {
            for (Object arg : arguments) {
                if (!(arg instanceof String)) continue;
                return true;
            }
            return false;
        }

        @Specialization(guards={"containsJavaString(arguments)"})
        @CompilerDirectives.TruffleBoundary
        static Object[] converted(Node inliningTarget, Object[] arguments) {
            Object[] convertedArgs = new Object[arguments.length];
            for (int i = 0; i < arguments.length; ++i) {
                Object arg = arguments[i];
                if (arg instanceof String) {
                    String javaString = (String)arg;
                    convertedArgs[i] = PythonUtils.tsLiteral(javaString);
                    continue;
                }
                convertedArgs[i] = arg;
            }
            return convertedArgs;
        }

        @Specialization(guards={"!containsJavaString(arguments)"})
        static Object[] notConverted(Node inliningTarget, Object[] arguments) {
            return arguments;
        }
    }

    @GenerateUncached
    @GenerateInline
    static abstract class SimpleInvokeNodeDispatch
    extends Node {
        SimpleInvokeNodeDispatch() {
        }

        public abstract Object execute(Node var1, CallTarget var2, Object[] var3);

        @Specialization(guards={"cachedCallTarget == callTarget"}, limit="3")
        static Object doDirectCall(CallTarget callTarget, Object[] arguments, @Cached(value="callTarget") CallTarget cachedCallTarget, @Cached(value="create(callTarget)") DirectCallNode directCallNode) {
            return directCallNode.call(arguments);
        }

        @Specialization(replaces={"doDirectCall"})
        static Object doIndirectCall(CallTarget callTarget, Object[] arguments, @Cached IndirectCallNode indirectCallNode) {
            return indirectCallNode.call(callTarget, arguments);
        }
    }
}

