/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.internal.core;

import com.ibm.db2.cmx.internal.core.CMXConnection;
import com.ibm.db2.cmx.internal.core.CMXConnectionEventListener;
import com.ibm.db2.cmx.internal.core.CMXConnectionFactory;
import com.ibm.db2.cmx.internal.core.Message;
import com.ibm.db2.cmx.internal.core.Processor;
import com.ibm.db2.cmx.runtime.internal.trace.DataLogger;
import com.ibm.db2.cmx.runtime.internal.trace.Log;
import com.ibm.db2.cmx.server.CMXServerException;
import com.ibm.db2.cmx.server.Server;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ServerImpl
implements Server,
CMXConnectionEventListener {
    protected int port_;
    private Processor[] processors_ = null;
    private boolean isDaemon_ = true;
    public ArrayList<CMXConnection> connectionList_ = new ArrayList();
    private Thread listenerThread_ = null;
    private RunnableServer runnableServer_;
    ServerSocketChannel serverSocketChannel;
    protected volatile boolean isShutDown_ = true;
    private String serverType_ = null;
    protected static Logger logger__ = Log.getCMXServerLogger();

    public ServerImpl(int n2, boolean bl2, String string) {
        this.port_ = n2;
        this.isDaemon_ = bl2;
        this.runnableServer_ = new RunnableServer(this);
        this.listenerThread_ = new Thread(this.runnableServer_);
        this.listenerThread_.setDaemon(this.isDaemon_);
        String string2 = this.getClass().getSimpleName();
        this.serverType_ = string2.substring(0, string2.indexOf("ServerImpl")).toLowerCase();
    }

    public void setProcessors(Processor[] processorArray) {
        this.processors_ = processorArray;
    }

    @Override
    public void start() throws CMXServerException {
        try {
            this.serverSocketChannel = ServerSocketChannel.open();
            this.serverSocketChannel.socket().bind(new InetSocketAddress(this.port_));
        }
        catch (Exception exception) {
            String string = this.getClass().getSimpleName();
            string = string.substring(0, string.indexOf("ServerImpl"));
            DataLogger.lowImpactLogger(logger__, this, "start", "The Extended Insight " + string + " server failed to start on port: " + this.port_ + ".", exception);
            DataLogger.logUserLevel(Log.getUserLevelLogger(), this, "start", "The Extended Insight " + string + " server failed to start on port: " + this.port_ + ".", exception);
            throw new CMXServerException(exception);
        }
        if (logger__.isLoggable(Level.CONFIG)) {
            DataLogger.lowImpactLogger(logger__, this, "start", "The Extended Insight " + this.serverType_ + " server is started on port " + this.port_ + ".", null);
        }
        DataLogger.logUserLevel(Log.getUserLevelLogger(), this, "start", "The Extended Insight " + this.serverType_ + " server is started on port " + this.port_ + ".");
        this.isShutDown_ = false;
        if (!this.listenerThread_.isAlive()) {
            this.listenerThread_ = new Thread(this.runnableServer_);
            this.listenerThread_.setName("listener:" + DataLogger.getShortName(this));
            this.listenerThread_.setDaemon(this.isDaemon_);
            this.listenerThread_.start();
        }
    }

    public void queueMessage(Message message) throws Exception {
        ListIterator<CMXConnection> listIterator = this.connectionList_.listIterator();
        if (!listIterator.hasNext()) {
            DataLogger.logMonitorMessage(logger__, this, "queueMessage", "no active connections");
        }
        while (listIterator.hasNext()) {
            CMXConnection cMXConnection = (CMXConnection)listIterator.next();
            if (!cMXConnection.isConnected()) continue;
            if (logger__.isLoggable(Level.FINER)) {
                DataLogger.logMonitorMessage(logger__, this, "queueMessage", "Sending message to: " + cMXConnection);
            }
            cMXConnection.queueMessage(message);
        }
    }

    @Override
    public void processEvent(int n2, CMXConnection cMXConnection) {
        if (n2 == 0) {
            this.connectionList_.remove(cMXConnection);
            if (logger__.isLoggable(Level.FINER)) {
                DataLogger.logMonitorMessage(logger__, this, "processEvent", "Connection removed from server list: " + cMXConnection);
            }
        }
    }

    public CMXConnection[] getConnections() {
        return this.connectionList_.toArray(new CMXConnection[this.connectionList_.size()]);
    }

    @Override
    public void shutdown() {
        this.isShutDown_ = true;
        try {
            if (this.serverSocketChannel != null) {
                this.serverSocketChannel.close();
            }
        }
        catch (Throwable throwable) {
            DataLogger.logTrappedMonitoringException(logger__, this, "shutdown", throwable, "error closing server socket channel");
        }
        Iterator<CMXConnection> iterator = this.connectionList_.iterator();
        while (iterator.hasNext()) {
            CMXConnection cMXConnection = iterator.next();
            iterator.remove();
            try {
                cMXConnection.close();
            }
            catch (Throwable throwable) {
                DataLogger.logTrappedMonitoringException(logger__, this, "shutdown", throwable, "error closing connection: " + cMXConnection);
            }
        }
        if (logger__.isLoggable(Level.INFO)) {
            DataLogger.lowImpactLogger(logger__, this, "start", "The Extended Insight " + this.serverType_ + " server has shut down.", null);
        }
        DataLogger.logUserLevel(Log.getUserLevelLogger(), this, "start", "The Extended Insight " + this.serverType_ + " server has shut down.", null);
    }

    @Override
    public boolean isActive() {
        return this.serverSocketChannel != null ? this.serverSocketChannel.isOpen() : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getActiveClientURLs() {
        String[] stringArray = null;
        if (this.connectionList_ != null) {
            int n2 = 0;
            ArrayList<CMXConnection> arrayList = this.connectionList_;
            synchronized (arrayList) {
                stringArray = new String[this.connectionList_.size()];
                for (CMXConnection cMXConnection : this.connectionList_) {
                    stringArray[n2++] = cMXConnection.getUrl();
                }
            }
        }
        return stringArray;
    }

    @Override
    public Logger getLogger() {
        return logger__;
    }

    class RunnableServer
    implements Runnable {
        CMXConnectionEventListener cmxEventListener_ = null;

        public RunnableServer(CMXConnectionEventListener cMXConnectionEventListener) {
            this.cmxEventListener_ = cMXConnectionEventListener;
        }

        @Override
        public void run() {
            block5: {
                try {
                    while (!ServerImpl.this.isShutDown_) {
                        if (logger__.isLoggable(Level.FINER)) {
                            DataLogger.logMonitorMessage(logger__, this, "run", "Waiting for new client connection.");
                        }
                        SocketChannel socketChannel = ServerImpl.this.serverSocketChannel.accept();
                        CMXConnection cMXConnection = CMXConnectionFactory.getConnection(socketChannel, ServerImpl.this.processors_, logger__);
                        cMXConnection.addConnectionEventListner(this.cmxEventListener_);
                        ServerImpl.this.connectionList_.add(cMXConnection);
                        if (logger__.isLoggable(Level.FINE)) {
                            DataLogger.logConnectedComponents(logger__, this, "run", "The Extended Insight " + ServerImpl.this.serverType_ + " at port " + ServerImpl.this.port_ + " accepted connection from client at: " + cMXConnection.getUrl());
                        }
                        DataLogger.logUserLevel(Log.getUserLevelLogger(), this, "run", "The Extended Insight " + ServerImpl.this.serverType_ + " at port " + ServerImpl.this.port_ + " accepted connection from client at: " + cMXConnection.getUrl());
                    }
                }
                catch (IOException iOException) {
                    if (ServerImpl.this.isShutDown_ || !logger__.isLoggable(Level.INFO)) break block5;
                    DataLogger.lowImpactLogger(logger__, this, "run", "Server thread terminating: ", iOException);
                }
            }
        }
    }
}

