/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.firebirdsql.gds.impl.GDSFactory;

public final class GDSType
implements Serializable {
    private static final Map<String, GDSType> typeMap = new HashMap<String, GDSType>();
    private static final long serialVersionUID = 817804953480527534L;
    private final String name;

    public static GDSType getType(String type) {
        if (type == null) {
            return null;
        }
        return typeMap.get(type.toUpperCase(Locale.ROOT));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static GDSType registerType(String typeName) {
        Map<String, GDSType> map = typeMap;
        synchronized (map) {
            return typeMap.computeIfAbsent(typeName.toUpperCase(Locale.ROOT), GDSType::new);
        }
    }

    private GDSType(String name) {
        this.name = name;
    }

    private Object readResolve() {
        return GDSType.registerType(this.name);
    }

    public String toString() {
        return this.name;
    }

    static {
        GDSFactory.getDefaultGDSType();
    }
}

