/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.proxy;

import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.internal.trace.DataLogger;
import com.ibm.db2.cmx.runtime.internal.trace.Log;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;

public class PDQResultSetProxyHandler
implements InvocationHandler {
    private ResultSet physicalResultSet_;
    private boolean isCallable_;
    protected static Logger logger_ = Log.getCMXClientLogger();

    public PDQResultSetProxyHandler(ResultSet resultSet, boolean bl2) {
        this.physicalResultSet_ = resultSet;
        this.isCallable_ = bl2;
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        block6: {
            String string = method.getName();
            try {
                if (string.startsWith("update") || string.equals("cancelRowUpdates") || string.equals("deleteRow") || string.equals("getURL") || string.equals("insertRow") || string.equals("refreshRow") || string.equals("rowDeleted") || string.equals("rowInserted") || string.equals("rowUpdated")) {
                    this.throwUnsupportedFunction();
                    break block6;
                }
                if (string.equals("close")) {
                    this.close();
                    break block6;
                }
                if (string.equals("getStatement")) {
                    this.getStatement();
                    break block6;
                }
                return method.invoke((Object)this.physicalResultSet_, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                DataLogger.logThrowable(logger_, throwable);
                throw throwable;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_PROFILER_ILLEGAL_ACCESS_EXCEPTION", method.getName(), illegalAccessException.getMessage()), illegalAccessException, 10451);
            }
        }
        return null;
    }

    public void close() throws SQLException {
        Statement statement = null;
        try {
            if (!this.isCallable_) {
                statement = this.physicalResultSet_.getStatement();
            }
            this.physicalResultSet_.close();
        }
        finally {
            if (statement != null && !this.isCallable_) {
                statement.close();
            }
        }
    }

    public Statement getStatement() throws SQLException {
        return null;
    }

    private void throwUnsupportedFunction() throws SQLException {
        throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_UNSUPP_FUNC", new Object[0]), null, 10237);
    }
}

