/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.cast.JSDoubleToStringNode;
import com.oracle.truffle.js.nodes.cast.JSToPrimitiveNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNodeGen;
import com.oracle.truffle.js.nodes.unary.JSUnaryNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.Set;

public abstract class JSToStringNode
extends JavaScriptBaseNode {
    private final boolean undefinedToEmpty;
    private final boolean symbolToString;

    protected JSToStringNode() {
        this(false, false);
    }

    protected JSToStringNode(boolean undefinedToEmpty, boolean symbolToString) {
        this.undefinedToEmpty = undefinedToEmpty;
        this.symbolToString = symbolToString;
    }

    @NeverDefault
    public static JSToStringNode create() {
        return JSToStringNodeGen.create(false, false);
    }

    @NeverDefault
    public static JSToStringNode createUndefinedToEmpty() {
        return JSToStringNodeGen.create(true, false);
    }

    @NeverDefault
    public static JSToStringNode createSymbolToString() {
        return JSToStringNodeGen.create(false, true);
    }

    public abstract TruffleString executeString(Object var1);

    @Specialization
    protected TruffleString doString(TruffleString value) {
        return value;
    }

    @Specialization(guards={"isJSNull(value)"})
    protected TruffleString doNull(Object value) {
        return Null.NAME;
    }

    @Specialization(guards={"isUndefined(value)"})
    protected TruffleString doUndefined(Object value) {
        return this.undefinedToEmpty ? Strings.EMPTY_STRING : Undefined.NAME;
    }

    @Specialization
    protected TruffleString doBoolean(boolean value) {
        return JSRuntime.booleanToString(value);
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization
    protected TruffleString doInteger(int value, @Cached.Shared @Cached JSDoubleToStringNode doubleToStringNode) {
        return doubleToStringNode.executeString(value);
    }

    @Specialization
    protected TruffleString doBigInt(BigInt value) {
        return Strings.fromBigInt(value);
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization
    protected TruffleString doLong(long value, @Cached.Shared @Cached JSDoubleToStringNode doubleToStringNode) {
        return doubleToStringNode.executeString(value);
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization
    protected TruffleString doDouble(double d, @Cached.Shared @Cached JSDoubleToStringNode doubleToStringNode) {
        return doubleToStringNode.executeString(d);
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization(replaces={"doUndefined"})
    protected TruffleString doJSObject(JSDynamicObject value, @Cached.Shared @Cached JSToPrimitiveNode toPrimitiveHintStringNode, @Cached.Shared @Cached JSToStringNode toStringNode) {
        if (this.undefinedToEmpty && value == Undefined.instance) {
            return Strings.EMPTY_STRING;
        }
        return toStringNode.executeString(toPrimitiveHintStringNode.executeHintString((Object)value));
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization
    protected TruffleString doSymbol(Symbol value) {
        if (this.symbolToString) {
            return value.toTString();
        }
        throw Errors.createTypeErrorCannotConvertToString("a Symbol value", this);
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization(guards={"isForeignObject(object)"})
    protected TruffleString doTruffleObject(Object object, @Cached.Shared @Cached JSToPrimitiveNode toPrimitiveHintStringNode, @Cached.Shared @Cached JSToStringNode toStringNode) {
        return toStringNode.executeString(toPrimitiveHintStringNode.executeHintString(object));
    }

    @NeverDefault
    public static JSToStringNode getUncached() {
        return Uncached.INSTANCE;
    }

    static class Uncached
    extends JSToStringNode {
        static final Uncached INSTANCE = new Uncached();

        Uncached() {
        }

        @Override
        public TruffleString executeString(Object operand) {
            return JSRuntime.toString(operand);
        }
    }

    public static abstract class JSToStringWrapperNode
    extends JSUnaryNode {
        protected JSToStringWrapperNode(JavaScriptNode operand) {
            super(operand);
        }

        public static JSToStringWrapperNode create(JavaScriptNode child) {
            return JSToStringNodeGen.JSToStringWrapperNodeGen.create(child);
        }

        @Override
        public boolean isResultAlwaysOfType(Class<?> clazz) {
            return clazz == TruffleString.class;
        }

        @Specialization
        protected static Object doDefault(Object value, @Cached JSToStringNode toStringNode) {
            return toStringNode.executeString(value);
        }

        @Override
        protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return JSToStringNodeGen.JSToStringWrapperNodeGen.create(JSToStringWrapperNode.cloneUninitialized(this.getOperand(), materializedTags));
        }
    }
}

