/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.WrapForValidIteratorPrototypeBuiltins;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.builtins.JSIterator;
import com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.builtins.JSWrapForValidIteratorObject;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.objects.IteratorRecord;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;

public final class JSWrapForValidIterator
extends JSNonProxy
implements JSConstructorFactory.Default,
PrototypeSupplier {
    public static final JSWrapForValidIterator INSTANCE = new JSWrapForValidIterator();

    private JSWrapForValidIterator() {
    }

    public static JSWrapForValidIteratorObject create(JSContext context, JSRealm realm, IteratorRecord iteratorRecord) {
        JSObjectFactory factory = context.getWrapForIteratorFactory();
        JSDynamicObject proto = factory.getPrototype(realm);
        Shape shape = factory.getShape(realm, proto);
        JSWrapForValidIteratorObject newObj = factory.initProto(new JSWrapForValidIteratorObject(shape, proto, iteratorRecord), realm, proto);
        return factory.trackAllocation(newObj);
    }

    public static boolean isWrapForIterator(Object obj) {
        return obj instanceof JSWrapForValidIteratorObject;
    }

    @Override
    public JSDynamicObject createPrototype(JSRealm realm, JSFunctionObject ctor) {
        JSDynamicObject iteratorPrototype = realm.getIteratorPrototype();
        JSObject wrapForIteratorPrototype = JSObjectUtil.createOrdinaryPrototypeObject(realm, iteratorPrototype);
        JSObjectUtil.putFunctionsFromContainer(realm, wrapForIteratorPrototype, WrapForValidIteratorPrototypeBuiltins.BUILTINS);
        return wrapForIteratorPrototype;
    }

    @Override
    public Shape makeInitialShape(JSContext ctx, JSDynamicObject prototype) {
        Shape initialShape = JSObjectUtil.getProtoChildShape(prototype, INSTANCE, ctx);
        return initialShape;
    }

    @Override
    public JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getWrapForIteratorPrototype();
    }

    @Override
    public TruffleString getClassName() {
        return JSIterator.CLASS_NAME;
    }
}

