/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.network;

import com.tigervnc.rdr.FdInStream;
import com.tigervnc.rdr.FdOutStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLSession;

public class SSLEngineManager {
    private SSLEngine engine = null;
    private ByteBuffer myNetData;
    private ByteBuffer peerNetData;
    private Executor executor;
    private FdInStream in;
    private FdOutStream os;

    public SSLEngineManager(SSLEngine sSLEngine, FdInStream fdInStream, FdOutStream fdOutStream) throws IOException {
        this.in = fdInStream;
        this.os = fdOutStream;
        this.engine = sSLEngine;
        this.executor = Executors.newSingleThreadExecutor();
        int n = this.engine.getSession().getPacketBufferSize();
        this.myNetData = ByteBuffer.allocate(n);
        this.peerNetData = ByteBuffer.allocate(n);
    }

    public void doHandshake() throws Exception {
        this.engine.beginHandshake();
        SSLEngineResult.HandshakeStatus handshakeStatus = this.engine.getHandshakeStatus();
        SSLEngineResult sSLEngineResult = null;
        int n = this.engine.getSession().getApplicationBufferSize();
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(n);
        while (handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED && handshakeStatus != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            switch (handshakeStatus) {
                case NEED_UNWRAP: {
                    this.peerNetData.flip();
                    sSLEngineResult = this.engine.unwrap(this.peerNetData, byteBuffer);
                    this.peerNetData.compact();
                    handshakeStatus = sSLEngineResult.getHandshakeStatus();
                    switch (sSLEngineResult.getStatus()) {
                        case BUFFER_UNDERFLOW: {
                            int n2 = this.in.check(1, this.peerNetData.remaining(), false);
                            this.in.readBytes(this.peerNetData, n2);
                            break;
                        }
                        case OK: {
                            break;
                        }
                        case CLOSED: {
                            this.engine.closeInbound();
                        }
                    }
                    break;
                }
                case NEED_WRAP: {
                    sSLEngineResult = this.engine.wrap(byteBuffer2, this.myNetData);
                    handshakeStatus = sSLEngineResult.getHandshakeStatus();
                    switch (sSLEngineResult.getStatus()) {
                        case OK: {
                            this.myNetData.flip();
                            this.os.writeBytes(this.myNetData, this.myNetData.remaining());
                            this.os.flush();
                            this.myNetData.compact();
                            break;
                        }
                        case CLOSED: {
                            this.engine.closeOutbound();
                        }
                    }
                    break;
                }
                case NEED_TASK: {
                    this.executeTasks();
                }
            }
            handshakeStatus = this.engine.getHandshakeStatus();
        }
    }

    private void executeTasks() {
        Runnable runnable;
        while ((runnable = this.engine.getDelegatedTask()) != null) {
            this.executor.execute(runnable);
        }
    }

    public int read(ByteBuffer byteBuffer, int n) throws IOException {
        this.peerNetData.flip();
        SSLEngineResult sSLEngineResult = this.engine.unwrap(this.peerNetData, byteBuffer);
        this.peerNetData.compact();
        switch (sSLEngineResult.getStatus()) {
            case OK: {
                return sSLEngineResult.bytesProduced();
            }
            case BUFFER_UNDERFLOW: {
                int n2 = this.peerNetData.remaining();
                this.in.readBytes(this.peerNetData, this.in.check(1, n2, true));
                break;
            }
            case CLOSED: {
                this.engine.closeInbound();
            }
        }
        return 0;
    }

    public int write(ByteBuffer byteBuffer, int n) throws IOException {
        int n2 = 0;
        while (byteBuffer.hasRemaining()) {
            SSLEngineResult sSLEngineResult = this.engine.wrap(byteBuffer, this.myNetData);
            n2 += sSLEngineResult.bytesConsumed();
            switch (sSLEngineResult.getStatus()) {
                case OK: {
                    this.myNetData.flip();
                    this.os.writeBytes(this.myNetData, this.myNetData.remaining());
                    this.os.flush();
                    this.myNetData.compact();
                    break;
                }
                case BUFFER_OVERFLOW: {
                    this.myNetData.flip();
                    this.os.writeBytes(this.myNetData, this.myNetData.remaining());
                    this.myNetData.compact();
                    break;
                }
                case CLOSED: {
                    this.engine.closeOutbound();
                }
            }
        }
        return n2;
    }

    public SSLSession getSession() {
        return this.engine.getSession();
    }
}

