﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/budgets/BudgetsRequest.h>
#include <aws/budgets/Budgets_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Budgets {
namespace Model {

/**
 * <p> Request of DescribeBudget </p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/budgets-2016-10-20/DescribeBudgetRequest">AWS
 * API Reference</a></p>
 */
class DescribeBudgetRequest : public BudgetsRequest {
 public:
  AWS_BUDGETS_API DescribeBudgetRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DescribeBudget"; }

  AWS_BUDGETS_API Aws::String SerializePayload() const override;

  AWS_BUDGETS_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The <code>accountId</code> that is associated with the budget that you want a
   * description of.</p>
   */
  inline const Aws::String& GetAccountId() const { return m_accountId; }
  inline bool AccountIdHasBeenSet() const { return m_accountIdHasBeenSet; }
  template <typename AccountIdT = Aws::String>
  void SetAccountId(AccountIdT&& value) {
    m_accountIdHasBeenSet = true;
    m_accountId = std::forward<AccountIdT>(value);
  }
  template <typename AccountIdT = Aws::String>
  DescribeBudgetRequest& WithAccountId(AccountIdT&& value) {
    SetAccountId(std::forward<AccountIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the budget that you want a description of.</p>
   */
  inline const Aws::String& GetBudgetName() const { return m_budgetName; }
  inline bool BudgetNameHasBeenSet() const { return m_budgetNameHasBeenSet; }
  template <typename BudgetNameT = Aws::String>
  void SetBudgetName(BudgetNameT&& value) {
    m_budgetNameHasBeenSet = true;
    m_budgetName = std::forward<BudgetNameT>(value);
  }
  template <typename BudgetNameT = Aws::String>
  DescribeBudgetRequest& WithBudgetName(BudgetNameT&& value) {
    SetBudgetName(std::forward<BudgetNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Specifies whether the response includes the filter expression associated with
   * the budget. By showing the filter expression, you can see detailed filtering
   * logic applied to the budget, such as Amazon Web Services services or tags that
   * are being tracked.</p>
   */
  inline bool GetShowFilterExpression() const { return m_showFilterExpression; }
  inline bool ShowFilterExpressionHasBeenSet() const { return m_showFilterExpressionHasBeenSet; }
  inline void SetShowFilterExpression(bool value) {
    m_showFilterExpressionHasBeenSet = true;
    m_showFilterExpression = value;
  }
  inline DescribeBudgetRequest& WithShowFilterExpression(bool value) {
    SetShowFilterExpression(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_accountId;

  Aws::String m_budgetName;

  bool m_showFilterExpression{false};
  bool m_accountIdHasBeenSet = false;
  bool m_budgetNameHasBeenSet = false;
  bool m_showFilterExpressionHasBeenSet = false;
};

}  // namespace Model
}  // namespace Budgets
}  // namespace Aws
