﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/lexv2-models/LexModelsV2_EXPORTS.h>
#include <aws/lexv2-models/model/AnalyticsIntentStageMetricName.h>
#include <aws/lexv2-models/model/AnalyticsMetricStatistic.h>
#include <aws/lexv2-models/model/AnalyticsSortOrder.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace LexModelsV2 {
namespace Model {

/**
 * <p>Contains the metric and the summary statistic you want to calculate, and the
 * order in which to sort the results, for the intent stages across the user
 * sessions with the bot.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/AnalyticsIntentStageMetric">AWS
 * API Reference</a></p>
 */
class AnalyticsIntentStageMetric {
 public:
  AWS_LEXMODELSV2_API AnalyticsIntentStageMetric() = default;
  AWS_LEXMODELSV2_API AnalyticsIntentStageMetric(Aws::Utils::Json::JsonView jsonValue);
  AWS_LEXMODELSV2_API AnalyticsIntentStageMetric& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_LEXMODELSV2_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The metric for which you want to get intent stage summary statistics. See <a
   * href="https://docs.aws.amazon.com/lexv2/latest/dg/analytics-key-definitions.html">Key
   * definitions</a> for more details about these metrics.</p> <ul> <li> <p>
   * <code>Count</code> – The number of times the intent stage occurred.</p> </li>
   * <li> <p> <code>Success</code> – The number of times the intent stage
   * succeeded.</p> </li> <li> <p> <code>Failure</code> – The number of times the
   * intent stage failed.</p> </li> <li> <p> <code>Dropped</code> – The number of
   * times the user dropped the intent stage.</p> </li> <li> <p> <code>Retry</code> –
   * The number of times the bot tried to elicit a response from the user at this
   * stage.</p> </li> </ul>
   */
  inline AnalyticsIntentStageMetricName GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  inline void SetName(AnalyticsIntentStageMetricName value) {
    m_nameHasBeenSet = true;
    m_name = value;
  }
  inline AnalyticsIntentStageMetric& WithName(AnalyticsIntentStageMetricName value) {
    SetName(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The summary statistic to calculate.</p> <ul> <li> <p> <code>Sum</code> – The
   * total count for the category you provide in <code>name</code>.</p> </li> <li>
   * <p> <code>Average</code> – The total count divided by the number of intent
   * stages in the category you provide in <code>name</code>.</p> </li> <li> <p>
   * <code>Max</code> – The highest count in the category you provide in
   * <code>name</code>.</p> </li> </ul>
   */
  inline AnalyticsMetricStatistic GetStatistic() const { return m_statistic; }
  inline bool StatisticHasBeenSet() const { return m_statisticHasBeenSet; }
  inline void SetStatistic(AnalyticsMetricStatistic value) {
    m_statisticHasBeenSet = true;
    m_statistic = value;
  }
  inline AnalyticsIntentStageMetric& WithStatistic(AnalyticsMetricStatistic value) {
    SetStatistic(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Specifies whether to sort the results in ascending or descending order of the
   * summary statistic (<code>value</code> in the response).</p>
   */
  inline AnalyticsSortOrder GetOrder() const { return m_order; }
  inline bool OrderHasBeenSet() const { return m_orderHasBeenSet; }
  inline void SetOrder(AnalyticsSortOrder value) {
    m_orderHasBeenSet = true;
    m_order = value;
  }
  inline AnalyticsIntentStageMetric& WithOrder(AnalyticsSortOrder value) {
    SetOrder(value);
    return *this;
  }
  ///@}
 private:
  AnalyticsIntentStageMetricName m_name{AnalyticsIntentStageMetricName::NOT_SET};

  AnalyticsMetricStatistic m_statistic{AnalyticsMetricStatistic::NOT_SET};

  AnalyticsSortOrder m_order{AnalyticsSortOrder::NOT_SET};
  bool m_nameHasBeenSet = false;
  bool m_statisticHasBeenSet = false;
  bool m_orderHasBeenSet = false;
};

}  // namespace Model
}  // namespace LexModelsV2
}  // namespace Aws
