﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/mediaconnect/MediaConnect_EXPORTS.h>
#include <aws/mediaconnect/model/Reservation.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace MediaConnect {
namespace Model {
class ListReservationsResult {
 public:
  AWS_MEDIACONNECT_API ListReservationsResult() = default;
  AWS_MEDIACONNECT_API ListReservationsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_MEDIACONNECT_API ListReservationsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p> The token that identifies the batch of results that you want to see. </p>
   * <p>For example, you submit a <code>ListReservations</code> request with
   * <code>MaxResults</code> set at 5. The service returns the first batch of results
   * (up to 5) and a <code>NextToken</code> value. To see the next batch of results,
   * you can submit the <code>ListReservations</code> request a second time and
   * specify the <code>NextToken</code> value.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListReservationsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> A list of all reservations that have been purchased by this account in the
   * current Amazon Web Services Region. </p>
   */
  inline const Aws::Vector<Reservation>& GetReservations() const { return m_reservations; }
  template <typename ReservationsT = Aws::Vector<Reservation>>
  void SetReservations(ReservationsT&& value) {
    m_reservationsHasBeenSet = true;
    m_reservations = std::forward<ReservationsT>(value);
  }
  template <typename ReservationsT = Aws::Vector<Reservation>>
  ListReservationsResult& WithReservations(ReservationsT&& value) {
    SetReservations(std::forward<ReservationsT>(value));
    return *this;
  }
  template <typename ReservationsT = Reservation>
  ListReservationsResult& AddReservations(ReservationsT&& value) {
    m_reservationsHasBeenSet = true;
    m_reservations.emplace_back(std::forward<ReservationsT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListReservationsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_nextToken;

  Aws::Vector<Reservation> m_reservations;

  Aws::String m_requestId;
  bool m_nextTokenHasBeenSet = false;
  bool m_reservationsHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace MediaConnect
}  // namespace Aws
