﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/neptune/Neptune_EXPORTS.h>
#include <aws/neptune/model/DBCluster.h>
#include <aws/neptune/model/ResponseMetadata.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Xml {
class XmlDocument;
}  // namespace Xml
}  // namespace Utils
namespace Neptune {
namespace Model {
class DescribeDBClustersResult {
 public:
  AWS_NEPTUNE_API DescribeDBClustersResult() = default;
  AWS_NEPTUNE_API DescribeDBClustersResult(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
  AWS_NEPTUNE_API DescribeDBClustersResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);

  ///@{
  /**
   * <p>A pagination token that can be used in a subsequent DescribeDBClusters
   * request.</p>
   */
  inline const Aws::String& GetMarker() const { return m_marker; }
  template <typename MarkerT = Aws::String>
  void SetMarker(MarkerT&& value) {
    m_markerHasBeenSet = true;
    m_marker = std::forward<MarkerT>(value);
  }
  template <typename MarkerT = Aws::String>
  DescribeDBClustersResult& WithMarker(MarkerT&& value) {
    SetMarker(std::forward<MarkerT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Contains a list of DB clusters for the user.</p>
   */
  inline const Aws::Vector<DBCluster>& GetDBClusters() const { return m_dBClusters; }
  template <typename DBClustersT = Aws::Vector<DBCluster>>
  void SetDBClusters(DBClustersT&& value) {
    m_dBClustersHasBeenSet = true;
    m_dBClusters = std::forward<DBClustersT>(value);
  }
  template <typename DBClustersT = Aws::Vector<DBCluster>>
  DescribeDBClustersResult& WithDBClusters(DBClustersT&& value) {
    SetDBClusters(std::forward<DBClustersT>(value));
    return *this;
  }
  template <typename DBClustersT = DBCluster>
  DescribeDBClustersResult& AddDBClusters(DBClustersT&& value) {
    m_dBClustersHasBeenSet = true;
    m_dBClusters.emplace_back(std::forward<DBClustersT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const ResponseMetadata& GetResponseMetadata() const { return m_responseMetadata; }
  template <typename ResponseMetadataT = ResponseMetadata>
  void SetResponseMetadata(ResponseMetadataT&& value) {
    m_responseMetadataHasBeenSet = true;
    m_responseMetadata = std::forward<ResponseMetadataT>(value);
  }
  template <typename ResponseMetadataT = ResponseMetadata>
  DescribeDBClustersResult& WithResponseMetadata(ResponseMetadataT&& value) {
    SetResponseMetadata(std::forward<ResponseMetadataT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_marker;

  Aws::Vector<DBCluster> m_dBClusters;

  ResponseMetadata m_responseMetadata;
  bool m_markerHasBeenSet = false;
  bool m_dBClustersHasBeenSet = false;
  bool m_responseMetadataHasBeenSet = false;
};

}  // namespace Model
}  // namespace Neptune
}  // namespace Aws
