﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/workmail/WorkMail_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace WorkMail {
namespace Model {

/**
 * <p>The representation of an organization.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/OrganizationSummary">AWS
 * API Reference</a></p>
 */
class OrganizationSummary {
 public:
  AWS_WORKMAIL_API OrganizationSummary() = default;
  AWS_WORKMAIL_API OrganizationSummary(Aws::Utils::Json::JsonView jsonValue);
  AWS_WORKMAIL_API OrganizationSummary& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_WORKMAIL_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The identifier associated with the organization.</p>
   */
  inline const Aws::String& GetOrganizationId() const { return m_organizationId; }
  inline bool OrganizationIdHasBeenSet() const { return m_organizationIdHasBeenSet; }
  template <typename OrganizationIdT = Aws::String>
  void SetOrganizationId(OrganizationIdT&& value) {
    m_organizationIdHasBeenSet = true;
    m_organizationId = std::forward<OrganizationIdT>(value);
  }
  template <typename OrganizationIdT = Aws::String>
  OrganizationSummary& WithOrganizationId(OrganizationIdT&& value) {
    SetOrganizationId(std::forward<OrganizationIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The alias associated with the organization.</p>
   */
  inline const Aws::String& GetAlias() const { return m_alias; }
  inline bool AliasHasBeenSet() const { return m_aliasHasBeenSet; }
  template <typename AliasT = Aws::String>
  void SetAlias(AliasT&& value) {
    m_aliasHasBeenSet = true;
    m_alias = std::forward<AliasT>(value);
  }
  template <typename AliasT = Aws::String>
  OrganizationSummary& WithAlias(AliasT&& value) {
    SetAlias(std::forward<AliasT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The default email domain associated with the organization.</p>
   */
  inline const Aws::String& GetDefaultMailDomain() const { return m_defaultMailDomain; }
  inline bool DefaultMailDomainHasBeenSet() const { return m_defaultMailDomainHasBeenSet; }
  template <typename DefaultMailDomainT = Aws::String>
  void SetDefaultMailDomain(DefaultMailDomainT&& value) {
    m_defaultMailDomainHasBeenSet = true;
    m_defaultMailDomain = std::forward<DefaultMailDomainT>(value);
  }
  template <typename DefaultMailDomainT = Aws::String>
  OrganizationSummary& WithDefaultMailDomain(DefaultMailDomainT&& value) {
    SetDefaultMailDomain(std::forward<DefaultMailDomainT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The error message associated with the organization. It is only present if
   * unexpected behavior has occurred with regards to the organization. It provides
   * insight or solutions regarding unexpected behavior.</p>
   */
  inline const Aws::String& GetErrorMessage() const { return m_errorMessage; }
  inline bool ErrorMessageHasBeenSet() const { return m_errorMessageHasBeenSet; }
  template <typename ErrorMessageT = Aws::String>
  void SetErrorMessage(ErrorMessageT&& value) {
    m_errorMessageHasBeenSet = true;
    m_errorMessage = std::forward<ErrorMessageT>(value);
  }
  template <typename ErrorMessageT = Aws::String>
  OrganizationSummary& WithErrorMessage(ErrorMessageT&& value) {
    SetErrorMessage(std::forward<ErrorMessageT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The state associated with the organization.</p>
   */
  inline const Aws::String& GetState() const { return m_state; }
  inline bool StateHasBeenSet() const { return m_stateHasBeenSet; }
  template <typename StateT = Aws::String>
  void SetState(StateT&& value) {
    m_stateHasBeenSet = true;
    m_state = std::forward<StateT>(value);
  }
  template <typename StateT = Aws::String>
  OrganizationSummary& WithState(StateT&& value) {
    SetState(std::forward<StateT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_organizationId;

  Aws::String m_alias;

  Aws::String m_defaultMailDomain;

  Aws::String m_errorMessage;

  Aws::String m_state;
  bool m_organizationIdHasBeenSet = false;
  bool m_aliasHasBeenSet = false;
  bool m_defaultMailDomainHasBeenSet = false;
  bool m_errorMessageHasBeenSet = false;
  bool m_stateHasBeenSet = false;
};

}  // namespace Model
}  // namespace WorkMail
}  // namespace Aws
