﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/workspaces-web/WorkSpacesWeb_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace WorkSpacesWeb {
namespace Model {
class CreateIdentityProviderResult {
 public:
  AWS_WORKSPACESWEB_API CreateIdentityProviderResult() = default;
  AWS_WORKSPACESWEB_API CreateIdentityProviderResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_WORKSPACESWEB_API CreateIdentityProviderResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The ARN of the identity provider.</p>
   */
  inline const Aws::String& GetIdentityProviderArn() const { return m_identityProviderArn; }
  template <typename IdentityProviderArnT = Aws::String>
  void SetIdentityProviderArn(IdentityProviderArnT&& value) {
    m_identityProviderArnHasBeenSet = true;
    m_identityProviderArn = std::forward<IdentityProviderArnT>(value);
  }
  template <typename IdentityProviderArnT = Aws::String>
  CreateIdentityProviderResult& WithIdentityProviderArn(IdentityProviderArnT&& value) {
    SetIdentityProviderArn(std::forward<IdentityProviderArnT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateIdentityProviderResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_identityProviderArn;

  Aws::String m_requestId;
  bool m_identityProviderArnHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace WorkSpacesWeb
}  // namespace Aws
