﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/workspaces/WorkSpaces_EXPORTS.h>
#include <aws/workspaces/model/ApplicationAssociatedResourceType.h>
#include <aws/workspaces/model/AssociationState.h>
#include <aws/workspaces/model/AssociationStateReason.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace WorkSpaces {
namespace Model {

/**
 * <p>Describes the association between an application and an application
 * resource.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ApplicationResourceAssociation">AWS
 * API Reference</a></p>
 */
class ApplicationResourceAssociation {
 public:
  AWS_WORKSPACES_API ApplicationResourceAssociation() = default;
  AWS_WORKSPACES_API ApplicationResourceAssociation(Aws::Utils::Json::JsonView jsonValue);
  AWS_WORKSPACES_API ApplicationResourceAssociation& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_WORKSPACES_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The identifier of the application.</p>
   */
  inline const Aws::String& GetApplicationId() const { return m_applicationId; }
  inline bool ApplicationIdHasBeenSet() const { return m_applicationIdHasBeenSet; }
  template <typename ApplicationIdT = Aws::String>
  void SetApplicationId(ApplicationIdT&& value) {
    m_applicationIdHasBeenSet = true;
    m_applicationId = std::forward<ApplicationIdT>(value);
  }
  template <typename ApplicationIdT = Aws::String>
  ApplicationResourceAssociation& WithApplicationId(ApplicationIdT&& value) {
    SetApplicationId(std::forward<ApplicationIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The identifier of the associated resource.</p>
   */
  inline const Aws::String& GetAssociatedResourceId() const { return m_associatedResourceId; }
  inline bool AssociatedResourceIdHasBeenSet() const { return m_associatedResourceIdHasBeenSet; }
  template <typename AssociatedResourceIdT = Aws::String>
  void SetAssociatedResourceId(AssociatedResourceIdT&& value) {
    m_associatedResourceIdHasBeenSet = true;
    m_associatedResourceId = std::forward<AssociatedResourceIdT>(value);
  }
  template <typename AssociatedResourceIdT = Aws::String>
  ApplicationResourceAssociation& WithAssociatedResourceId(AssociatedResourceIdT&& value) {
    SetAssociatedResourceId(std::forward<AssociatedResourceIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The resource type of the associated resource.</p>
   */
  inline ApplicationAssociatedResourceType GetAssociatedResourceType() const { return m_associatedResourceType; }
  inline bool AssociatedResourceTypeHasBeenSet() const { return m_associatedResourceTypeHasBeenSet; }
  inline void SetAssociatedResourceType(ApplicationAssociatedResourceType value) {
    m_associatedResourceTypeHasBeenSet = true;
    m_associatedResourceType = value;
  }
  inline ApplicationResourceAssociation& WithAssociatedResourceType(ApplicationAssociatedResourceType value) {
    SetAssociatedResourceType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The time the association was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreated() const { return m_created; }
  inline bool CreatedHasBeenSet() const { return m_createdHasBeenSet; }
  template <typename CreatedT = Aws::Utils::DateTime>
  void SetCreated(CreatedT&& value) {
    m_createdHasBeenSet = true;
    m_created = std::forward<CreatedT>(value);
  }
  template <typename CreatedT = Aws::Utils::DateTime>
  ApplicationResourceAssociation& WithCreated(CreatedT&& value) {
    SetCreated(std::forward<CreatedT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The time the association status was last updated.</p>
   */
  inline const Aws::Utils::DateTime& GetLastUpdatedTime() const { return m_lastUpdatedTime; }
  inline bool LastUpdatedTimeHasBeenSet() const { return m_lastUpdatedTimeHasBeenSet; }
  template <typename LastUpdatedTimeT = Aws::Utils::DateTime>
  void SetLastUpdatedTime(LastUpdatedTimeT&& value) {
    m_lastUpdatedTimeHasBeenSet = true;
    m_lastUpdatedTime = std::forward<LastUpdatedTimeT>(value);
  }
  template <typename LastUpdatedTimeT = Aws::Utils::DateTime>
  ApplicationResourceAssociation& WithLastUpdatedTime(LastUpdatedTimeT&& value) {
    SetLastUpdatedTime(std::forward<LastUpdatedTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status of the application resource association.</p>
   */
  inline AssociationState GetState() const { return m_state; }
  inline bool StateHasBeenSet() const { return m_stateHasBeenSet; }
  inline void SetState(AssociationState value) {
    m_stateHasBeenSet = true;
    m_state = value;
  }
  inline ApplicationResourceAssociation& WithState(AssociationState value) {
    SetState(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The reason the association deployment failed.</p>
   */
  inline const AssociationStateReason& GetStateReason() const { return m_stateReason; }
  inline bool StateReasonHasBeenSet() const { return m_stateReasonHasBeenSet; }
  template <typename StateReasonT = AssociationStateReason>
  void SetStateReason(StateReasonT&& value) {
    m_stateReasonHasBeenSet = true;
    m_stateReason = std::forward<StateReasonT>(value);
  }
  template <typename StateReasonT = AssociationStateReason>
  ApplicationResourceAssociation& WithStateReason(StateReasonT&& value) {
    SetStateReason(std::forward<StateReasonT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_applicationId;

  Aws::String m_associatedResourceId;

  ApplicationAssociatedResourceType m_associatedResourceType{ApplicationAssociatedResourceType::NOT_SET};

  Aws::Utils::DateTime m_created{};

  Aws::Utils::DateTime m_lastUpdatedTime{};

  AssociationState m_state{AssociationState::NOT_SET};

  AssociationStateReason m_stateReason;
  bool m_applicationIdHasBeenSet = false;
  bool m_associatedResourceIdHasBeenSet = false;
  bool m_associatedResourceTypeHasBeenSet = false;
  bool m_createdHasBeenSet = false;
  bool m_lastUpdatedTimeHasBeenSet = false;
  bool m_stateHasBeenSet = false;
  bool m_stateReasonHasBeenSet = false;
};

}  // namespace Model
}  // namespace WorkSpaces
}  // namespace Aws
