# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AccessRecommendationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The feature- generated recommendation shown to the reviewer."""

    APPROVE = "Approve"
    DENY = "Deny"
    NO_INFO_AVAILABLE = "NoInfoAvailable"


class AccessReviewActorIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The identity type : user/servicePrincipal."""

    USER = "user"
    SERVICE_PRINCIPAL = "servicePrincipal"


class AccessReviewApplyResult(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The outcome of applying the decision."""

    NEW = "New"
    APPLYING = "Applying"
    APPLIED_SUCCESSFULLY = "AppliedSuccessfully"
    APPLIED_WITH_UNKNOWN_FAILURE = "AppliedWithUnknownFailure"
    APPLIED_SUCCESSFULLY_BUT_OBJECT_NOT_FOUND = "AppliedSuccessfullyButObjectNotFound"
    APPLY_NOT_SUPPORTED = "ApplyNotSupported"


class AccessReviewDecisionInsightType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of insight."""

    USER_SIGN_IN_INSIGHT = "userSignInInsight"


class AccessReviewDecisionPrincipalResourceMembershipType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """AccessReviewDecisionPrincipalResourceMembershipType."""

    DIRECT = "direct"
    INDIRECT = "indirect"


class AccessReviewHistoryDefinitionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """This read-only field specifies the of the requested review history data. This is either
    requested, in-progress, done or error.
    """

    REQUESTED = "Requested"
    IN_PROGRESS = "InProgress"
    DONE = "Done"
    ERROR = "Error"


class AccessReviewInstanceReviewersType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """This field specifies the type of reviewers for a review. Usually for a review, reviewers are
    explicitly assigned. However, in some cases, the reviewers may not be assigned and instead be
    chosen dynamically. For example managers review or self review.
    """

    ASSIGNED = "Assigned"
    SELF = "Self"
    MANAGERS = "Managers"


class AccessReviewInstanceStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """This read-only field specifies the status of an access review instance."""

    NOT_STARTED = "NotStarted"
    IN_PROGRESS = "InProgress"
    COMPLETED = "Completed"
    APPLIED = "Applied"
    INITIALIZING = "Initializing"
    APPLYING = "Applying"
    COMPLETING = "Completing"
    SCHEDULED = "Scheduled"
    AUTO_REVIEWING = "AutoReviewing"
    AUTO_REVIEWED = "AutoReviewed"
    STARTING = "Starting"


class AccessReviewRecurrencePatternType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The recurrence type : weekly, monthly, etc."""

    WEEKLY = "weekly"
    ABSOLUTE_MONTHLY = "absoluteMonthly"


class AccessReviewRecurrenceRangeType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The recurrence range type. The possible values are: endDate, noEnd, numbered."""

    END_DATE = "endDate"
    NO_END = "noEnd"
    NUMBERED = "numbered"


class AccessReviewResult(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Represents a reviewer's decision for a given review."""

    APPROVE = "Approve"
    DENY = "Deny"
    NOT_REVIEWED = "NotReviewed"
    DONT_KNOW = "DontKnow"
    NOT_NOTIFIED = "NotNotified"


class AccessReviewReviewerType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The identity type : user/servicePrincipal."""

    USER = "user"
    SERVICE_PRINCIPAL = "servicePrincipal"


class AccessReviewScheduleDefinitionReviewersType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """This field specifies the type of reviewers for a review. Usually for a review, reviewers are
    explicitly assigned. However, in some cases, the reviewers may not be assigned and instead be
    chosen dynamically. For example managers review or self review.
    """

    ASSIGNED = "Assigned"
    SELF = "Self"
    MANAGERS = "Managers"


class AccessReviewScheduleDefinitionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """This read-only field specifies the status of an accessReview."""

    NOT_STARTED = "NotStarted"
    IN_PROGRESS = "InProgress"
    COMPLETED = "Completed"
    APPLIED = "Applied"
    INITIALIZING = "Initializing"
    APPLYING = "Applying"
    COMPLETING = "Completing"
    SCHEDULED = "Scheduled"
    AUTO_REVIEWING = "AutoReviewing"
    AUTO_REVIEWED = "AutoReviewed"
    STARTING = "Starting"


class AccessReviewScopeAssignmentState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The role assignment state eligible/active to review."""

    ELIGIBLE = "eligible"
    ACTIVE = "active"


class AccessReviewScopePrincipalType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The identity type user/servicePrincipal to review."""

    USER = "user"
    GUEST_USER = "guestUser"
    SERVICE_PRINCIPAL = "servicePrincipal"
    USER_GROUP = "user,group"
    REDEEMED_GUEST_USER = "redeemedGuestUser"


class ApprovalMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of rule."""

    SINGLE_STAGE = "SingleStage"
    SERIAL = "Serial"
    PARALLEL = "Parallel"
    NO_APPROVAL = "NoApproval"


class AssignmentType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Assignment type of the role assignment schedule."""

    ACTIVATED = "Activated"
    ASSIGNED = "Assigned"


class DecisionResourceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of resource."""

    AZURE_ROLE = "azureRole"


class DecisionTargetType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of decision target : User/ServicePrincipal."""

    USER = "user"
    SERVICE_PRINCIPAL = "servicePrincipal"


class DefaultDecisionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """This specifies the behavior for the autoReview feature when an access review completes."""

    APPROVE = "Approve"
    DENY = "Deny"
    RECOMMENDATION = "Recommendation"


class EnablementRules(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of enablement rule."""

    MULTI_FACTOR_AUTHENTICATION = "MultiFactorAuthentication"
    JUSTIFICATION = "Justification"
    TICKETING = "Ticketing"


class ExcludedPrincipalTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """ExcludedPrincipalTypes."""

    SERVICE_PRINCIPALS_AS_TARGET = "ServicePrincipalsAsTarget"
    SERVICE_PRINCIPALS_AS_REQUESTOR = "ServicePrincipalsAsRequestor"


class MemberType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Membership type of the role assignment schedule."""

    INHERITED = "Inherited"
    DIRECT = "Direct"
    GROUP = "Group"


class NotificationDeliveryMechanism(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of notification."""

    EMAIL = "Email"


class NotificationLevel(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The notification level."""

    NONE = "None"
    CRITICAL = "Critical"
    ALL = "All"


class PIMOnlyMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Determines whether the setting is enabled, disabled or report only."""

    DISABLED = "Disabled"
    ENABLED = "Enabled"
    REPORT_ONLY = "ReportOnly"


class PrincipalType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The principal type of the assigned principal ID."""

    USER = "User"
    GROUP = "Group"
    SERVICE_PRINCIPAL = "ServicePrincipal"
    FOREIGN_GROUP = "ForeignGroup"
    DEVICE = "Device"


class RecipientType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The recipient type."""

    REQUESTOR = "Requestor"
    APPROVER = "Approver"
    ADMIN = "Admin"


class RecordAllDecisionsResult(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The decision to make. Approvers can take action of Approve/Deny."""

    APPROVE = "Approve"
    DENY = "Deny"


class RequestType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the role assignment schedule request. Eg: SelfActivate, AdminAssign etc."""

    ADMIN_ASSIGN = "AdminAssign"
    ADMIN_REMOVE = "AdminRemove"
    ADMIN_UPDATE = "AdminUpdate"
    ADMIN_EXTEND = "AdminExtend"
    ADMIN_RENEW = "AdminRenew"
    SELF_ACTIVATE = "SelfActivate"
    SELF_DEACTIVATE = "SelfDeactivate"
    SELF_EXTEND = "SelfExtend"
    SELF_RENEW = "SelfRenew"


class RoleManagementPolicyRuleType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of rule."""

    ROLE_MANAGEMENT_POLICY_APPROVAL_RULE = "RoleManagementPolicyApprovalRule"
    ROLE_MANAGEMENT_POLICY_AUTHENTICATION_CONTEXT_RULE = "RoleManagementPolicyAuthenticationContextRule"
    ROLE_MANAGEMENT_POLICY_ENABLEMENT_RULE = "RoleManagementPolicyEnablementRule"
    ROLE_MANAGEMENT_POLICY_EXPIRATION_RULE = "RoleManagementPolicyExpirationRule"
    ROLE_MANAGEMENT_POLICY_NOTIFICATION_RULE = "RoleManagementPolicyNotificationRule"
    ROLE_MANAGEMENT_POLICY_PIM_ONLY_MODE_RULE = "RoleManagementPolicyPimOnlyModeRule"


class SeverityLevel(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Severity level of the alert."""

    LOW = "Low"
    MEDIUM = "Medium"
    HIGH = "High"


class Status(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of the role assignment schedule."""

    ACCEPTED = "Accepted"
    PENDING_EVALUATION = "PendingEvaluation"
    GRANTED = "Granted"
    DENIED = "Denied"
    PENDING_PROVISIONING = "PendingProvisioning"
    PROVISIONED = "Provisioned"
    PENDING_REVOCATION = "PendingRevocation"
    REVOKED = "Revoked"
    CANCELED = "Canceled"
    FAILED = "Failed"
    PENDING_APPROVAL_PROVISIONING = "PendingApprovalProvisioning"
    PENDING_APPROVAL = "PendingApproval"
    FAILED_AS_RESOURCE_IS_LOCKED = "FailedAsResourceIsLocked"
    PENDING_ADMIN_DECISION = "PendingAdminDecision"
    ADMIN_APPROVED = "AdminApproved"
    ADMIN_DENIED = "AdminDenied"
    TIMED_OUT = "TimedOut"
    PROVISIONING_STARTED = "ProvisioningStarted"
    INVALID = "Invalid"
    PENDING_SCHEDULE_CREATION = "PendingScheduleCreation"
    SCHEDULE_CREATED = "ScheduleCreated"
    PENDING_EXTERNAL_PROVISIONING = "PendingExternalProvisioning"


class Type(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of the role assignment schedule expiration."""

    AFTER_DURATION = "AfterDuration"
    AFTER_DATE_TIME = "AfterDateTime"
    NO_EXPIRATION = "NoExpiration"


class UserType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of user."""

    USER = "User"
    GROUP = "Group"
    SERVICE_PRINCIPAL = "ServicePrincipal"
