/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Member;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.MemberVisitor;

public class InitializerMethodFilter
implements MemberVisitor {
    private final MemberVisitor initializerMemberVisitor;
    private final MemberVisitor otherMemberVisitor;

    public InitializerMethodFilter(MemberVisitor initializerMemberVisitor) {
        this(initializerMemberVisitor, null);
    }

    public InitializerMethodFilter(MemberVisitor initializerMemberVisitor, MemberVisitor otherMemberVisitor) {
        this.initializerMemberVisitor = initializerMemberVisitor;
        this.otherMemberVisitor = otherMemberVisitor;
    }

    @Override
    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
    }

    @Override
    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        MemberVisitor memberVisitor = this.applicableMemberVisitor(programClass, programMethod);
        if (memberVisitor != null) {
            memberVisitor.visitProgramMethod(programClass, programMethod);
        }
    }

    @Override
    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        MemberVisitor memberVisitor = this.applicableMemberVisitor(libraryClass, libraryMethod);
        if (memberVisitor != null) {
            memberVisitor.visitLibraryMethod(libraryClass, libraryMethod);
        }
    }

    private MemberVisitor applicableMemberVisitor(Clazz clazz, Member method) {
        return ClassUtil.isInitializer(method.getName(clazz)) ? this.initializerMemberVisitor : this.otherMemberVisitor;
    }
}

