/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework.permissions;

import java.io.InputStream;
import java.security.PermissionCollection;
import java.security.Policy;
import java.util.Hashtable;
import java.util.Iterator;
import org.knopflerfish.framework.FrameworkContext;
import org.knopflerfish.framework.permissions.ConditionalPermissionAdminImpl;
import org.knopflerfish.framework.permissions.ConditionalPermissionInfoStorage;
import org.knopflerfish.framework.permissions.FrameworkPolicy;
import org.knopflerfish.framework.permissions.PermissionAdminImpl;
import org.knopflerfish.framework.permissions.PermissionInfoStorage;
import org.knopflerfish.framework.permissions.PermissionsWrapper;
import org.osgi.framework.Bundle;
import org.osgi.framework.hooks.weaving.WovenClass;
import org.osgi.framework.hooks.weaving.WovenClassListener;
import org.osgi.framework.wiring.BundleWiring;

public class PermissionsHandle
implements WovenClassListener {
    FrameworkContext framework;
    private final PermissionInfoStorage pinfos;
    private final ConditionalPermissionInfoStorage cpinfos;
    private final Hashtable<Long, PermissionsWrapper> pcCache = new Hashtable();
    private final PermissionAdminImpl pa;
    private final ConditionalPermissionAdminImpl cpa;

    public PermissionsHandle(FrameworkContext fw) {
        this.framework = fw;
        this.pinfos = new PermissionInfoStorage(fw);
        this.pa = new PermissionAdminImpl(this.pinfos);
        this.cpinfos = new ConditionalPermissionInfoStorage(this);
        this.cpa = new ConditionalPermissionAdminImpl(this.cpinfos, this.pinfos, fw);
        Policy.setPolicy(new FrameworkPolicy(Policy.getPolicy(), this));
    }

    public PermissionAdminImpl getPermissionAdminService() {
        return this.pa;
    }

    public ConditionalPermissionAdminImpl getConditionalPermissionAdminService() {
        return this.cpa;
    }

    public PermissionCollection getPermissionCollection(Long bid) {
        return this.pcCache.get(bid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PermissionCollection createPermissionCollection(String loc, Bundle b, InputStream localPerms) {
        PermissionsWrapper pc;
        Long bid = new Long(b.getBundleId());
        ConditionalPermissionInfoStorage conditionalPermissionInfoStorage = this.cpinfos;
        synchronized (conditionalPermissionInfoStorage) {
            pc = new PermissionsWrapper(this.framework, this.pinfos, this.cpinfos, loc, b, localPerms);
            this.pcCache.put(bid, pc);
        }
        return pc;
    }

    public boolean purgePermissionCollection(Long bid, PermissionCollection pc) {
        this.pinfos.purgeCallback(pc);
        if (this.pcCache.get(bid) == pc) {
            this.pcCache.remove(bid);
            return true;
        }
        return false;
    }

    Iterator<PermissionsWrapper> getPermissionWrappers() {
        return this.pcCache.values().iterator();
    }

    @Override
    public void modified(WovenClass wc) {
        PermissionsWrapper pw;
        BundleWiring bundleWiring;
        if ((wc.getState() & 0x14) != 0 && (bundleWiring = wc.getBundleWiring()) != null && (pw = this.pcCache.get(new Long(bundleWiring.getBundle().getBundleId()))) != null) {
            pw.addWovenDynamicImport(wc.getDynamicImports());
        }
    }
}

