/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.SelectorMatcher;
import io.sf.carte.doc.style.css.nsac.ArgumentCondition;
import io.sf.carte.doc.style.css.nsac.CombinatorCondition;
import io.sf.carte.doc.style.css.nsac.CombinatorSelector;
import io.sf.carte.doc.style.css.nsac.Condition;
import io.sf.carte.doc.style.css.nsac.ConditionalSelector;
import io.sf.carte.doc.style.css.nsac.ElementSelector;
import io.sf.carte.doc.style.css.nsac.PositionalCondition;
import io.sf.carte.doc.style.css.nsac.Selector;
import io.sf.carte.doc.style.css.nsac.SelectorList;
import io.sf.carte.doc.style.css.nsac.SimpleSelector;
import java.io.Serializable;

public class Specificity
implements Serializable {
    private static final long serialVersionUID = 2L;
    short id_count = 0;
    short attrib_classes_count = 0;
    short names_pseudoelements_count = 0;
    private final SelectorMatcher selectorMatcher;

    public Specificity(Selector selector, SelectorMatcher selectorMatcher) {
        this.selectorMatcher = selectorMatcher;
        this.specificity(selector);
    }

    private void add(Specificity specificity) {
        this.id_count = (short)(this.id_count + specificity.id_count);
        this.attrib_classes_count = (short)(this.attrib_classes_count + specificity.attrib_classes_count);
        this.names_pseudoelements_count = (short)(this.names_pseudoelements_count + specificity.names_pseudoelements_count);
    }

    private void specificity(Selector selector) {
        switch (selector.getSelectorType()) {
            case ELEMENT: {
                String string = ((ElementSelector)selector).getLocalName();
                if (string == null || string.equals("*")) break;
                this.names_pseudoelements_count = (short)(this.names_pseudoelements_count + 1);
                break;
            }
            case CONDITIONAL: {
                ConditionalSelector conditionalSelector = (ConditionalSelector)selector;
                SimpleSelector simpleSelector = conditionalSelector.getSimpleSelector();
                this.specificity(simpleSelector);
                this.conditionSpecificity(conditionalSelector.getCondition());
                break;
            }
            case DESCENDANT: 
            case CHILD: 
            case DIRECT_ADJACENT: 
            case SUBSEQUENT_SIBLING: {
                this.specificity(((CombinatorSelector)selector).getSecondSelector());
                this.specificity(((CombinatorSelector)selector).getSelector());
                break;
            }
        }
    }

    private void conditionSpecificity(Condition condition) {
        switch (condition.getConditionType()) {
            case POSITIONAL: {
                PositionalCondition positionalCondition = (PositionalCondition)condition;
                SelectorList selectorList = positionalCondition.getOfList();
                if (selectorList != null) {
                    this.mostSpecific(selectorList);
                }
            }
            case CLASS: 
            case ATTRIBUTE: 
            case ONE_OF_ATTRIBUTE: 
            case BEGIN_HYPHEN_ATTRIBUTE: 
            case BEGINS_ATTRIBUTE: 
            case ENDS_ATTRIBUTE: 
            case SUBSTRING_ATTRIBUTE: 
            case PSEUDO_CLASS: 
            case LANG: 
            case ONLY_CHILD: 
            case ONLY_TYPE: {
                this.attrib_classes_count = (short)(this.attrib_classes_count + 1);
                break;
            }
            case PSEUDO_ELEMENT: {
                this.names_pseudoelements_count = (short)(this.names_pseudoelements_count + 1);
                break;
            }
            case ID: {
                this.id_count = (short)(this.id_count + 1);
                break;
            }
            case AND: {
                CombinatorCondition combinatorCondition = (CombinatorCondition)condition;
                this.conditionSpecificity(combinatorCondition.getFirstCondition());
                this.conditionSpecificity(combinatorCondition.getSecondCondition());
                break;
            }
            case SELECTOR_ARGUMENT: {
                ArgumentCondition argumentCondition = (ArgumentCondition)condition;
                String string = argumentCondition.getName();
                if ("where".equalsIgnoreCase(string)) break;
                SelectorList selectorList = argumentCondition.getSelectors();
                this.mostSpecific(selectorList);
                break;
            }
        }
    }

    private void mostSpecific(SelectorList selectorList) {
        int n = selectorList.getLength();
        Selector selector = selectorList.item(0);
        Specificity specificity = new Specificity(selector, this.selectorMatcher);
        for (int i = 1; i < n; ++i) {
            Selector selector2 = selectorList.item(i);
            Specificity specificity2 = new Specificity(selector2, this.selectorMatcher);
            if (Specificity.selectorCompare(specificity, specificity2) >= 0) continue;
            specificity = specificity2;
        }
        this.add(specificity);
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + this.attrib_classes_count;
        n2 = 31 * n2 + this.id_count;
        n2 = 31 * n2 + this.names_pseudoelements_count;
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof Specificity)) {
            return false;
        }
        Specificity specificity = (Specificity)object;
        if (this.attrib_classes_count != specificity.attrib_classes_count) {
            return false;
        }
        if (this.id_count != specificity.id_count) {
            return false;
        }
        return this.names_pseudoelements_count == specificity.names_pseudoelements_count;
    }

    public static int selectorCompare(Specificity specificity, Specificity specificity2) {
        return (specificity.id_count - specificity2.id_count) * 16384 + (specificity.attrib_classes_count - specificity2.attrib_classes_count) * 128 + (specificity.names_pseudoelements_count - specificity2.names_pseudoelements_count);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(82);
        stringBuilder.append("id: ").append(this.id_count).append(", attributes and pseudo-classes: ").append(this.attrib_classes_count).append(", element names and pseudo-elements: ").append(this.names_pseudoelements_count);
        return stringBuilder.toString();
    }
}

