/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.xmlimpl;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.xmlimpl.Namespace;
import org.mozilla.javascript.xmlimpl.XMLLibImpl;
import org.mozilla.javascript.xmlimpl.XmlNode;

final class QName
extends IdScriptableObject {
    static final long serialVersionUID = 416745167693026750L;
    private static final Object QNAME_TAG = "QName";
    private XMLLibImpl lib;
    private QName prototype;
    private XmlNode.QName delegate;
    private static final int Id_localName = 1;
    private static final int Id_uri = 2;
    private static final int MAX_INSTANCE_ID = 2;
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_toSource = 3;
    private static final int MAX_PROTOTYPE_ID = 3;

    private QName() {
    }

    static QName create(XMLLibImpl xMLLibImpl, Scriptable scriptable, QName qName, XmlNode.QName qName2) {
        QName qName3 = new QName();
        qName3.lib = xMLLibImpl;
        qName3.setParentScope(scriptable);
        qName3.prototype = qName;
        qName3.setPrototype(qName);
        qName3.delegate = qName2;
        return qName3;
    }

    void exportAsJSClass(boolean bl) {
        this.exportAsJSClass(3, this.getParentScope(), bl);
    }

    public String toString() {
        if (this.delegate.getNamespace() == null) {
            return "*::" + this.localName();
        }
        if (this.delegate.getNamespace().isGlobal()) {
            return this.localName();
        }
        return this.uri() + "::" + this.localName();
    }

    public String localName() {
        if (this.delegate.getLocalName() == null) {
            return "*";
        }
        return this.delegate.getLocalName();
    }

    String prefix() {
        if (this.delegate.getNamespace() == null) {
            return null;
        }
        return this.delegate.getNamespace().getPrefix();
    }

    String uri() {
        if (this.delegate.getNamespace() == null) {
            return null;
        }
        return this.delegate.getNamespace().getUri();
    }

    @Deprecated
    final XmlNode.QName toNodeQname() {
        return this.delegate;
    }

    final XmlNode.QName getDelegate() {
        return this.delegate;
    }

    public boolean equals(Object object) {
        if (!(object instanceof QName)) {
            return false;
        }
        return this.equals((QName)object);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    protected Object equivalentValues(Object object) {
        if (!(object instanceof QName)) {
            return Scriptable.NOT_FOUND;
        }
        boolean bl = this.equals((QName)object);
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    private boolean equals(QName qName) {
        return this.delegate.equals(qName.delegate);
    }

    @Override
    public String getClassName() {
        return "QName";
    }

    @Override
    public Object getDefaultValue(Class<?> clazz) {
        return this.toString();
    }

    @Override
    protected int getMaxInstanceId() {
        return super.getMaxInstanceId() + 2;
    }

    @Override
    protected int findInstanceIdInfo(String string) {
        int n;
        int n2 = 0;
        String string2 = null;
        int n3 = string.length();
        if (n3 == 3) {
            string2 = "uri";
            n2 = 2;
        } else if (n3 == 9) {
            string2 = "localName";
            n2 = 1;
        }
        if (string2 != null && string2 != string && !string2.equals(string)) {
            n2 = 0;
        }
        if (n2 == 0) {
            return super.findInstanceIdInfo(string);
        }
        switch (n2) {
            case 1: 
            case 2: {
                n = 5;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return QName.instanceIdInfo(n, super.getMaxInstanceId() + n2);
    }

    @Override
    protected String getInstanceIdName(int n) {
        switch (n - super.getMaxInstanceId()) {
            case 1: {
                return "localName";
            }
            case 2: {
                return "uri";
            }
        }
        return super.getInstanceIdName(n);
    }

    @Override
    protected Object getInstanceIdValue(int n) {
        switch (n - super.getMaxInstanceId()) {
            case 1: {
                return this.localName();
            }
            case 2: {
                return this.uri();
            }
        }
        return super.getInstanceIdValue(n);
    }

    @Override
    protected int findPrototypeId(String string) {
        int n;
        block6: {
            n = 0;
            String string2 = null;
            int n2 = string.length();
            if (n2 == 8) {
                char c = string.charAt(3);
                if (c == 'o') {
                    string2 = "toSource";
                    n = 3;
                } else if (c == 't') {
                    string2 = "toString";
                    n = 2;
                }
            } else if (n2 == 11) {
                string2 = "constructor";
                n = 1;
            }
            if (string2 == null || string2 == string || string2.equals(string)) break block6;
            n = 0;
        }
        return n;
    }

    @Override
    protected void initPrototypeId(int n) {
        String string;
        int n2;
        switch (n) {
            case 1: {
                n2 = 2;
                string = "constructor";
                break;
            }
            case 2: {
                n2 = 0;
                string = "toString";
                break;
            }
            case 3: {
                n2 = 0;
                string = "toSource";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
        }
        this.initPrototypeMethod(QNAME_TAG, n, string, n2);
    }

    @Override
    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!idFunctionObject.hasTag(QNAME_TAG)) {
            return super.execIdCall(idFunctionObject, context, scriptable, scriptable2, objectArray);
        }
        int n = idFunctionObject.methodId();
        switch (n) {
            case 1: {
                return this.jsConstructor(context, scriptable2 == null, objectArray);
            }
            case 2: {
                return this.realThis(scriptable2, idFunctionObject).toString();
            }
            case 3: {
                return this.realThis(scriptable2, idFunctionObject).js_toSource();
            }
        }
        throw new IllegalArgumentException(String.valueOf(n));
    }

    private QName realThis(Scriptable scriptable, IdFunctionObject idFunctionObject) {
        return QName.ensureType(scriptable, QName.class, idFunctionObject);
    }

    QName newQName(XMLLibImpl xMLLibImpl, String string, String string2, String string3) {
        QName qName = this.prototype;
        if (qName == null) {
            qName = this;
        }
        XmlNode.Namespace namespace = null;
        if (string3 != null) {
            namespace = XmlNode.Namespace.create(string3, string);
        } else if (string != null) {
            namespace = XmlNode.Namespace.create(string);
        }
        if (string2 != null && string2.equals("*")) {
            string2 = null;
        }
        return QName.create(xMLLibImpl, this.getParentScope(), qName, XmlNode.QName.create(namespace, string2));
    }

    QName constructQName(XMLLibImpl xMLLibImpl, Context context, Object object, Object object2) {
        String string;
        String string2;
        String string3 = null;
        if (object2 instanceof QName) {
            if (object == Undefined.instance) {
                return (QName)object2;
            }
            string3 = ((QName)object2).localName();
        }
        string3 = object2 == Undefined.instance ? "" : ScriptRuntime.toString(object2);
        if (object == Undefined.instance) {
            object = "*".equals(string3) ? null : xMLLibImpl.getDefaultNamespace(context);
        }
        Namespace namespace = null;
        if (object != null) {
            namespace = object instanceof Namespace ? (Namespace)object : xMLLibImpl.newNamespace(ScriptRuntime.toString(object));
        }
        String string4 = string3;
        if (object == null) {
            string2 = null;
            string = null;
        } else {
            string2 = namespace.uri();
            string = namespace.prefix();
        }
        return this.newQName(xMLLibImpl, string2, string4, string);
    }

    QName constructQName(XMLLibImpl xMLLibImpl, Context context, Object object) {
        return this.constructQName(xMLLibImpl, context, Undefined.instance, object);
    }

    QName castToQName(XMLLibImpl xMLLibImpl, Context context, Object object) {
        if (object instanceof QName) {
            return (QName)object;
        }
        return this.constructQName(xMLLibImpl, context, object);
    }

    private Object jsConstructor(Context context, boolean bl, Object[] objectArray) {
        if (!bl && objectArray.length == 1) {
            return this.castToQName(this.lib, context, objectArray[0]);
        }
        if (objectArray.length == 0) {
            return this.constructQName(this.lib, context, Undefined.instance);
        }
        if (objectArray.length == 1) {
            return this.constructQName(this.lib, context, objectArray[0]);
        }
        return this.constructQName(this.lib, context, objectArray[0], objectArray[1]);
    }

    private String js_toSource() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        QName.toSourceImpl(this.uri(), this.localName(), this.prefix(), stringBuilder);
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    private static void toSourceImpl(String string, String string2, String string3, StringBuilder stringBuilder) {
        stringBuilder.append("new QName(");
        if (string == null && string3 == null) {
            if (!"*".equals(string2)) {
                stringBuilder.append("null, ");
            }
        } else if (string != null) {
            Namespace.toSourceImpl(string3, string, stringBuilder);
            stringBuilder.append(", ");
        }
        stringBuilder.append('\'');
        stringBuilder.append(ScriptRuntime.escapeString(string2, '\''));
        stringBuilder.append("')");
    }
}

