# frozen_string_literal: true

class IndexVulnerabilityFlagsOnProjectId < Gitlab::Database::Migration[2.2]
  milestone '17.2'
  disable_ddl_transaction!

  INDEX_NAME = 'index_vulnerability_flags_on_project_id'

  def up
    add_concurrent_index :vulnerability_flags, :project_id, name: INDEX_NAME
  end

  def down
    remove_concurrent_index_by_name :vulnerability_flags, INDEX_NAME
  end
end
