---
stage: Plan
group: Project Management
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: イシューボード
---

{{< details >}}

- プラン:Free、Premium、Ultimate
- 提供:GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< history >}}

- イシューカードにマイルストーンとイテレーションが表示される機能が GitLab 16.11 [で導入されました](https://gitlab.com/gitlab-org/gitlab/-/issues/25758)。
- グループまたはプロジェクト内の最後のボードを削除する機能が GitLab 17.6 [で導入されました](https://gitlab.com/gitlab-org/gitlab/-/issues/499579)。
- イシューボードを管理するための最小ロールが、GitLab 17.7 でレポーターからプランナーに[変更されました](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169256)。

{{< /history >}}

イシューボードは、GitLab での作業を管理および追跡するための視覚的な方法を提供します。イシューボード:

- ラベル、マイルストーン、または担当者に基づいて、カスタマイズ可能なリストでイシューをカードとして表示します。
- ワークフローのさまざまな段階を通してイシューを追跡します。
- KanbanやScrumなどのアジャイル開発手法をサポートします。
- さまざまなチームやプロジェクトのために複数のボードを編成します。
- プロセス全体のワークロードと進捗状況を視覚化します。

イシューは、割り当てられた[ラベル](labels.md)、[マイルストーン](#milestone-lists)、[イテレーション](#iteration-lists)、または[担当者](#assignee-lists)によって編成され、縦のリストにカードとして表示されます。

イシューにメタデータを追加し、既存のイシューに対応するリストを作成します。準備ができたら、イシューカードをあるリストから別のリストにドラッグできます。

イシューボードは、[Kanban](https://en.wikipedia.org/wiki/Kanban_(development))や[Scrum](https://en.wikipedia.org/wiki/Scrum_(software_development))などの一般的なフレームワークを強化できます。

チームメンバーが独自のワークフローを編成できるようにするには、[複数のイシューボード](#multiple-issue-boards)を使用します。これにより、同じプロジェクト内で複数のイシューボードを作成できます。

![GitLabイシューボード - コア](img/issue_boards_core_v17_1.png)

イシューボードのさまざまな機能は、さまざまな[GitLab プラン](https://about.gitlab.com/pricing/)で利用できます:

| プラン     | プロジェクトイシューボードの数 | [グループイシューボード](#group-issue-boards)の数 | [構成可能なイシューボード](#configurable-issue-boards) | [担当者リスト](#assignee-lists) |
| -------- | ------------------------------ | --------------------------------------------------- | ------------------------------------------------------- | --------------------------------- |
| Free     | 複数                       | 1                                                   | {{< icon name="dotted-circle" >}} いいえ                                  | {{< icon name="dotted-circle" >}} いいえ            |
| Premium  | 複数                       | 複数                                            | {{< icon name="check-circle" >}} はい                                  | {{< icon name="check-circle" >}} はい            |
| Ultimate | 複数                       | 複数                                            | {{< icon name="check-circle" >}} はい                                  | {{< icon name="check-circle" >}} はい            |

[イシューボードの GitLab Enterprise の機能](#gitlab-enterprise-features-for-issue-boards)の詳細をご覧ください。

![GitLabイシューボード - Premium](img/issue_boards_premium_v17_1.png)

<i class="fa fa-youtube-play youtube" aria-hidden="true"></i> イシューボード機能の[ビデオプレゼンテーション](https://youtu.be/vjccjHI7aGI)をご覧ください。
<!-- Video published on 2020-04-02 -->

## 複数のイシューボード

複数のイシューボードを使用すると、次の複数のイシューボードを使用できます:

- 全プランのプロジェクト
- PremiumおよびUltimateプランのグループ

複数のイシューボードは、リポジトリが複数の製品のコードをホストしている複数のチームがいる大規模なプロジェクトや、ソフトウェア開発ライフサイクル全体でさまざまなワークフローを強化するボードを作成する場合に最適です。

メニューの上部にある検索ボックスを使用して、リストされたボードをフィルタリングできます。

10個以上のボードが利用可能な場合、メニューには**最近使ったもの**セクションも表示され、最後にアクセスした4つのボードへのショートカットが表示されます。

![複数のイシューボード](img/issue_boards_multiple_v17_1.png)

複数のボードがあるプロジェクトまたはグループでイシューボードに再度アクセスすると、GitLab は最後にアクセスしたボードを自動的に読み込みます。

### イシューボードを作成する

前提要件:

- プロジェクトのプランナーロール以上が必要です。

新しいイシューボードを作成するには:

1. イシューボードページの上部左隅にあるドロップダウンリストで、現在のボード名を選択します。
1. **新しいボードを作成**を選択します。
1. 新しいボードの名前を入力し、そのスコープ（マイルストーン、イテレーション、ラベル、担当者、またはウェイト）を選択します。
1. **ボードを作成**を選択します

### イシューボードを削除する

前提要件:

- ボードが保存されているプロジェクトまたはグループのプランナーロール以上が必要です。

開いているイシューボードを削除するには:

1. イシューボードページの右上隅で、**ボードをConfigure**（{{< icon name="settings" >}}）を選択します。
1. **ボードを削除**を選択します。
1. **削除**を選択して確定します。

削除したボードが最後のボードだった場合は、新しい`Development`ボードが作成されます。

## イシューボードのユースケース

GitLabイシューボードを、独自の推奨ワークフローに合わせて調整できます。ワークフローベースのドキュメントについては、[チュートリアルを参照してください:作業を計画して追跡](../../tutorials/plan_and_track.md)。

### 単一のイシューボードのユースケース

[GitLab Flow](https://about.gitlab.com/topics/version-control/what-is-gitlab-flow/)を使用すると、イシューで提案について話し合い、ラベル付けし、イシューボードで整理および優先順位を付けることができます。

たとえば、次の簡略化された開発ワークフローについて考えてみましょう:

1. アプリケーションのコードベースをホストするリポジトリがあり、チームは積極的にコードをコントリビュートしています。
1. **バックエンド**チームが新しい実装に取り組み、フィードバックと承認を収集して、**フロントエンド**チームに渡します。
1. フロントエンドが完了すると、新しい機能の**ステージ**環境にデプロイされてTestされます。
1. 成功すると、**本番環境**にデプロイされます。

**バックエンド**、**フロントエンド**、**ステージ**、および**本番環境**のラベルがあり、それぞれにリストを含むイシューボードがある場合は、次のことができます:

- 開発ライフサイクルの最初から本番環境へのデプロイまで、実装全体のフローを視覚化します。
- イシューを縦に移動して、リスト内のイシューの優先順位を付けます。
- リスト間でイシューを移動して、設定したラベルに従って整理します。
- 既存のイシューを1つ以上選択して、ボード内のリストに複数のイシューを追加します。

![イシューカードの移動](img/issue_board_move_issue_card_list_v17_1.png)

### Scrumチーム

Scrumチームでは、各Scrumチームが独自のボードを持つように、[複数のイシューボード](#multiple-issue-boards)を使用します。Scrumボードでは、プロセスの各部分を通してイシューを簡単に移動できます。例:**To Do**、**Doing**、および**Done**。

### クイックアサイン

チームメンバーにイシューをすばやく割り当てるには:

1. チームメンバーごとに[担当者リスト](#assignee-lists)を作成します。
1. チームメンバーのリストにイシューをドラッグします。

## イシューボードの用語

**イシューボード**は、イシューの一意のビューを表します。複数のリストを持つことができ、各リストはカードで表されるイシューで構成されています。

**リスト**は、特定の属性に一致するイシューを表示するイシューボードの列です。デフォルトの「開く」リストと「閉じる」リストに加えて、追加の各リストには、選択したラベル、担当者、またはマイルストーンに一致するイシューが表示されます。各リストの上部には、それに属するイシューの数が表示されます。リストのタイプには次のものがあります:

- **開く**（デフォルト）：他のリストのいずれにも属していない、開いているすべてのイシュー。常に左端のリストとして表示されます。
- **閉じる**（デフォルト）：閉じられたすべてのイシュー。常に右端のリストとして表示されます。
- **ラベルリスト**：ラベルのすべてのオープンイシュー。
- [**担当者リスト**](#assignee-lists)：ユーザーに割り当てられたすべてのオープンイシュー。
- [**マイルストーンリスト**](#milestone-lists)：マイルストーンのすべてのオープンイシュー。
- [**イテレーションリスト**](#iteration-lists)：イテレーションのすべてのオープンイシュー。

**カード**はリスト上のボックスであり、イシューを表します。カードをあるリストから別のリストにドラッグして、ラベル、担当者、またはマイルストーンを変更できます。カードに表示できる情報には、以下が含まれます。

- イシューのタイトル
- 関連付けられたラベル
- イシュー番号
- 担当者
- ウェイト
- マイルストーン
- イテレーション（PremiumおよびUltimateプラン）
- 期限
- タイムトラッキングの見積もり
- ヘルスステータス

**スイムレーン**は、たとえば親エピックごとなど、イシューボード上のイシューの水平方向のグループ化です。

## リストのイシューをオーダー

前提要件:

- プロジェクトのプランナーロール以上が必要です。

イシューが作成されると、システムは、そのイシューのプロジェクトまたはトップレベルグループの最大値よりも大きい相対的な順序の値を割り当てます。これは、イシューが表示されるイシューリストの一番下にイシューがあることを意味します。

ボードにアクセスすると、イシューはリストに順序付けられて表示されます。イシューをドラッグしてその順序を変更できます。変更された順序は保存されるため、後で同じボードにアクセスするすべての人が、いくつかの例外を除いて、並べ替えられた順序を確認できます。

イシューをドラッグして順序を変更するたびに、それに応じて相対的な順序の値が変更されます。次に、そのイシューがボードに表示されるたびに、更新された相対的な順序の値に従って順序付けが行われます。GitLabインスタンス内のユーザーがイシュー`A`をイシュー`B`の上にドラッグすると、これら2つのイシューが同じインスタンス内のボードに後で読み込まれる場合、順序が維持されます。たとえば、これは別のプロジェクトボードまたは別のグループボードである可能性があります。

この順序は[イシューリスト](issues/sorting_issue_lists.md)にも影響します。イシューボードの順序を変更すると、イシューリストの順序が変更され、その逆も同様です。

## フォーカスモード

フォーカスモードでは、ナビゲーションUIが非表示になり、ボード内のイシューに集中できます。フォーカスモードを有効または無効にするには、右上隅にある**フォーカスモードの切替**（{{< icon name="maximize" >}}）を選択します。

## グループイシューボード

グループナビゲーションレベルでアクセスできるグループイシューボードは、プロジェクトレベルのボードと同じ機能を提供します。グループとその子孫サブグループに属するすべてのプロジェクトからのイシューを表示できます。

GitLab Freeのユーザーは、単一のグループイシューボードを使用できます。

## イシューボードのGitLab Enterpriseの機能

GitLabイシューボードはGitLab Freeプランで利用できますが、高度な機能の一部は[より上位のプランのみ](https://about.gitlab.com/pricing/)に存在します。

### 構成可能なイシューボード

{{< details >}}

- プラン:Premium、Ultimate
- 提供:GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

イシューボードは、[マイルストーン](milestones/_index.md)、[ラベル](labels.md)、担当者、ウェイト、および現在の[イテレーション](../group/iterations/_index.md)に関連付けることができ、ボードのイシューを自動的にフィルタリングします。これにより、チームのニーズに応じて独自のボードを作成できます。

![スコープ付きボードを作成](img/issue_board_creation_v17_1.png)

ボードのスコープは、作成時または**ボードをConfigure**（{{< icon name="settings" >}}）ボタンを選択して定義できます。マイルストーン、イテレーション、担当者、またはウェイトがイシューボードに割り当てられた後、検索バーでこれらを通してフィルタリングすることはできなくなります。それを行うには、イシューボードから目的のスコープ（たとえば、マイルストーン、担当者、またはウェイト）を削除する必要があります。

ボードの編集権限がない場合でも、**ボードの設定**（{{< icon name="settings" >}}）を選択して設定を確認できます。

### 担当者リスト

{{< details >}}

- プラン:Premium、Ultimate
- 提供:GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

選択したラベルのすべてのイシューを表示する通常のリストと同様に、ユーザーに割り当てられたすべてのイシューを表示する担当者リストを追加できます。ラベルリストと担当者リストの両方を持つボードを持つことができます。

前提要件:

- プロジェクトのプランナーロール以上が必要です。

担当者リストを追加するには:

1. **新しいリスト**を選択します。
1. **担当者**を選択します。
1. ドロップダウンリストで、ユーザーを選択します。
1. **ボードに追加**を選択します。

担当者リストが追加されたので、担当者リストとの間で[イシューを移動](#move-issues-and-lists)して、そのユーザーにイシューを割り当てるか、割り当てを解除できます。担当者リストを削除するには、ラベルリストと同様に、ゴミ箱アイコンを選択します。

![担当者リスト](img/issue_board_assignee_lists_v17_1.png)

### マイルストーンリスト

{{< details >}}

- プラン:Premium、Ultimate
- 提供:GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

割り当てられたマイルストーンでイシューをフィルタリングするマイルストーンリストを作成して、イシューボードでより自由度を高め、可視性を高めることができます。

前提要件:

- プロジェクトのプランナーロール以上が必要です。

マイルストーンリストを追加するには:

1. **新しいリスト**を選択します。
1. **マイルストーン**を選択します。
1. ドロップダウンリストで、マイルストーンを選択します。
1. **ボードに追加**を選択します。

担当者リストと同様に、マイルストーンリストとの間で[イシューをドラッグ](#move-issues-and-lists)して、ドラッグされたイシューのマイルストーンを操作できます。他のリストタイプと同様に、ゴミ箱アイコンを選択してリストを削除します。

![マイルストーンリスト](img/issue_board_milestone_lists_v17_1.png)

### イテレーションリスト

{{< details >}}

- プラン:Premium、Ultimate
- 提供:GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

イテレーションでイシューのリストを作成できます。

前提要件:

- プロジェクトのプランナーロール以上が必要です。

イテレーションリストを追加するには:

1. **新しいリスト**を選択します。
1. **イテレーション**を選択します。
1. ドロップダウンリストで、イテレーションを選択します。
1. **ボードに追加**を選択します。

マイルストーンリストと同様に、イテレーションリストとの間で[イシューをドラッグ](#move-issues-and-lists)して、ドラッグされたイシューのイテレーションを操作できます。

![イテレーションリスト](img/issue_board_iteration_lists_v17_1.png)

### スイムレーンでイシューをグループ化する

{{< details >}}

- プラン:Premium、Ultimate
- 提供:GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

スイムレーンを使用すると、エピックでグループ化されたイシューを視覚化できます。イシューボードは他のすべての機能を保持しますが、イシューの視覚的な組織が異なります。この機能は、プロジェクトレベルとグループレベルの両方で使用できます。

前提要件:

- プロジェクトのプランナーロール以上が必要です。

イシューボードでイシューをエピック別にグループ化するには:

1. **表示オプション** ({{< icon name="preferences" >}}) を選択します。
1. **エピックスイムレーン**を選択します。

![エピックスイムレーン](img/epics_swimlanes_v17_1.png)

この表示のままイシューを[編集](#edit-an-issue)したり、[ドラッグ](#move-issues-and-lists)して位置やエピックの割り当てを変更したりできます:

- イシューを並べ替えるには、リスト内の新しい位置までドラッグします。
- イシューを別のエピックに割り当てるには、そのエピックの水平レーンにドラッグします。
- エピックからイシューを削除するには、**エピックが割り当てられていないイシュー**レーンにドラッグします。
- イシューを別のエピック_と_別のリストに同時に移動するには、イシューを斜めにドラッグします。

![スイムレーン間でイシューをドラッグする](img/epics_swimlanes_drag_and_drop_v13_6.png)

### イシューのウェイトの合計

{{< details >}}

- プラン:Premium、Ultimate
- 提供:GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

各リストの上部には、そのリストに属するイシューのイシューのウェイトの合計が表示されます。これは、特に[担当者リスト](#assignee-lists)と組み合わせて、キャパシティの割り当てにボードを使用する場合に便利です。

![イシューボードの合計ウェイト](img/issue_board_summed_weights_v17_1.png)

### 実行の制限

{{< details >}}

- プラン:Premium、Ultimate
- 提供:GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

イシューボードの各イシューリストに、実行の制限（WIP）を設定できます。制限が設定されている場合、リストのヘッダーには、リスト内のイシューの数とイシューのソフトな制限が表示されます。リスト内の線は、制限内の項目と制限を超える項目を区切ります。デフォルトのリスト（**開始**および**完了**）には、WIP制限を設定できません。

例:

- 4つのイシューがあるリストで、制限が5の場合、ヘッダーには**4/5**と表示されます。制限を超えると、現在のイシュー数が赤で表示されます。
- 制限が5つのイシューが5つあるリストがあります。別のイシューをそのリストに移動すると、リストのヘッダーには**6/5**と表示され、6は赤で表示されます。実行中の制限の線は、6番目のイシューの前に表示されます。

![イシューボードの進行中作業制限](img/issue_board_wip_limit_v17_9.png)

前提要件:

- プロジェクトのプランナーロール以上が必要です。

リストのWIP制限を設定するには、イシューボードで次の手順を実行します:

1. 編集するリストの上部にある**リスト設定の編集**({{< icon name="settings" >}})を選択します。リスト設定サイドバーが右側に開きます。
1. **実行中の制限**の横にある**編集**を選択します。
1. イシューの最大数を入力します。
1. <kbd>Enter</kbd>を押して保存します。

### ブロックされたイシュー

{{< details >}}

- プラン:Premium、Ultimate
- 提供:GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

イシューが[別のイシューによってブロックされている](issues/related_issues.md#blocking-issues)場合、ブロックされている状態を示すアイコンがタイトルの横に表示されます。

ブロックされたアイコン({{< icon name="entity-blocked" >}})の上にカーソルを置くと、詳細な情報のポップオーバーが表示されます。

![ブロックされたイシュー](img/issue_boards_blocked_icon_v17_9.png)

## イシューボードで実行できるアクション

- [イシューを編集](#edit-an-issue)。
- [新しいリストを作成](#create-a-new-list)。
- [既存のリストを削除](#remove-a-list)。
- [リストからイシューを削除](#remove-an-issue-from-a-list)。
- イシューボード全体に表示されるイシューを[フィルタリング](#filter-issues)します。
- [イシューとリストを移動](#move-issues-and-lists)。
- リストをドラッグして並べ替えます。
- （リスト間でイシューをドラッグして）イシューラベルを変更します。
- （イシューを**完了**リストにドラッグして）イシューを完了します。

### イシューを編集

ボード表示のままイシューを編集できます。右側のサイドバーを開くには、イシューカード（タイトルではなく）を選択します。

前提要件:

- プロジェクトのプランナーロール以上が必要です。

右側のサイドバーで、次のイシュー属性を編集できます:

- 担当者
- 機密性
- 期限
- [エピック](../group/epics/_index.md)
- [ヘルスステータス](issues/managing_issues.md#health-status)
- [イテレーション](../group/iterations/_index.md)
- ラベル
- マイルストーン
- 通知の設定
- タイトル
- [ウェイト](issues/issue_weight.md)
- タイムトラッキング

<!-- When issues_list_drawer feature flag is removed, use the info below
and in issues/managing_issues.md#open-issues-in-a-drawer to update the main topic above -->

管理者が[イシューdrawer](issues/managing_issues.md#open-issues-in-a-drawer)を有効にしている場合、イシューボードからイシューカードを選択すると、drawerにイシューが開きます。そこでは、説明、コメント、関連アイテムなど、すべてのフィールドを編集できます。

### 新しいリストを作成

{{< history >}}

- 既存のリスト間にリストを作成することは、GitLab 17.5[で導入されました](https://gitlab.com/gitlab-org/gitlab/-/issues/462515)。

{{< /history >}}

2つの既存のリストの間、またはイシューボードの右側に新しいリストを作成できます。

2つのリストの間に新しいリストを作成するには:

1. 左側のサイドバーで、**検索または移動**を選択して、プロジェクトを見つけます。
1. **Plan > イシューボード**を選択します。
1. 2つのリストの間で、カーソルを置くか、キーボードのフォーカスを移動します。
1. **新しいリスト**を選択します。新しいリストパネルが開きます。

   ![イシューボードの2つのリスト間に新しいリストを作成する](img/issue_board_add_list_between_lists_v17_6.png)

1. 新しいリストのベースにするラベル、ユーザー、マイルストーン、またはイテレーションを選択します。
1. **ボードに追加**を選択します。

新しいリストは、新しいリストパネルと同じ位置にボードに挿入されます。

リストを移動して並べ替えるには、それらをドラッグして移動します。

または、ボードの右端にある**新しいリスト**を選択することもできます。新しいリストは、リストの右端の**完了**の前に挿入されます。

### リストを削除

リストの削除は、削除されるのはリストビューだけなので、イシューやラベルには影響しません。必要に応じて、いつでも後で再作成できます。

前提要件:

- プロジェクトのプランナーロール以上が必要です。

イシューボードからリストを削除するには:

1. 削除するリストの上部にある**リスト設定の編集**({{< icon name="settings" >}})を選択します。リスト設定サイドバーが右側に開きます。
1. **リストを削除**を選択します。
1. 確認ダイアログで、もう一度**リストを削除**を選択します。

### リストにイシューを追加

前提要件:

- プロジェクトのプランナーロール以上が必要です。

ボードが1つまたは複数の属性にスコープされている場合は、追加するイシューに移動し、ボードのスコープと同じ属性を適用します。

たとえば、グループイシューボードで、`Doing`ラベルにスコープされたリストにイシューを追加するには:

1. グループまたはいずれかのサブグループまたはプロジェクトのイシューに移動します。
1. `Doing`ラベルを追加します。

これで、イシューがイシューボードの`Doing`リストに表示されるはずです。

### リストからイシューを削除

イシューがリストに属さなくなった場合は、削除できます。

前提要件:

- プロジェクトのプランナーロール以上が必要です。

手順は、リストのスコープによって異なります:

1. 右側のサイドバーを開くには、イシューカードを選択します。
1. イシューをリストに保持しているものを削除します。ラベルリストの場合は、ラベルを削除します。[担当者リスト](#assignee-lists)の場合は、ユーザーの割り当てを解除します。

### イシューをフィルタリング

イシューボードの上部にあるフィルターを使用して、必要な結果のみを表示できます。これは、[イシュートラッカー](issues/_index.md)で使用されているフィルタリングに似ています。

前提要件:

- プロジェクトのプランナーロール以上が必要です。

以下でフィルタリングできます:

- 担当者
- 作成者
- [エピック](../group/epics/_index.md)
- [イテレーション](../group/iterations/_index.md)
- ラベル
- マイルストーン
- 自分のリアクション
- リリース
- タイプ（イシュー/インシデント）
- [ウェイト](issues/issue_weight.md)

#### グループボードでイシューをフィルタリング

**グループ**ボードで[イシューをフィルタリング](#filter-issues)する場合は、次の動作に注意してください:

- マイルストーン：グループとその子孫グループに属するマイルストーンでフィルタリングできます。
- ラベル：グループに属するラベルでのみフィルタリングできますが、その子孫グループはフィルタリングできません。

右側のサイドバーを使用してイシューを個別に編集する場合は、イシューの**プロジェクト**からマイルストーンとラベルをさらに選択できます。

### イシューとリストを移動

イシューとリストは、ドラッグして移動できます。

前提要件:

- GitLabのプロジェクトのプランナーロール以上を持っている必要があります。

イシューを移動するには、イシューカードを選択し、現在のリスト内の別の位置、または別のリストにドラッグします。[リスト間でイシューをドラッグ](#dragging-issues-between-lists)した場合に起こりうる影響について説明します。

リストを移動するには、上部のバーを選択し、水平方向にドラッグします。**開始**リストと**完了**リストは移動できませんが、イシューボードの編集中に非表示にすることはできます。

#### イシューをリストの先頭に移動

{{< history >}}

- GitLab 15.4[で導入されました](https://gitlab.com/gitlab-org/gitlab/-/issues/367473)。

{{< /history >}}

メニューショートカットを使用して、イシューをリストの一番上に移動できます。

別のイシューがフィルターで非表示になっている場合でも、イシューはリストの一番上に移動されます。

前提要件:

- プロジェクトのプランナーロール以上を持っている必要があります。

イシューをリストの先頭に移動するには:

1. イシューボードで、移動するイシューのカードの上にカーソルを置きます。
1. **カードオプション** ({{< icon name="ellipsis_v" >}}) を選択し、次に**リストの先頭に移動**を選択します。

#### イシューをリストの最後に移動

{{< history >}}

- GitLab 15.4[で導入されました](https://gitlab.com/gitlab-org/gitlab/-/issues/367473)。

{{< /history >}}

メニューショートカットを使用して、イシューをリストの一番下に移動できます。

別のイシューがフィルターで非表示になっている場合でも、イシューはリストの一番下に移動されます。

前提要件:

- プロジェクトのプランナーロール以上を持っている必要があります。

イシューをリストの最後に移動するには:

1. イシューボードで、移動するイシューのカードの上にカーソルを置きます。
1. **カードオプション** ({{< icon name="ellipsis_v" >}}) を選択し、次に**リストの最後に移動**を選択します。

#### リスト間でイシューをドラッグ

イシューを別のリストに移動するには、イシューカードを選択してそのリストにドラッグします。

リスト間でイシューをドラッグすると、その結果はソースリストとターゲットリストによって異なります。

|                              | 開始へ        | 完了へ   | ラベルBリストへ                | 担当者Bobのリストへ          |
| ---------------------------- | -------------- | ----------- | ------------------------------ | ----------------------------- |
| **開始から**                | —              | イシューを完了 | ラベルBを追加                    | Bobを割り当て                    |
| **完了から**              | イシューを再開   | —           | イシューを再開してラベルBを追加   | イシューを再開してBobを割り当て   |
| **ラベルAリストから**        | ラベルAを削除 | イシューを完了 | ラベルAを削除してラベルBを追加 | Bobを割り当て                    |
| **担当者Aliceのリストから** | Aliceの割り当てを解除 | イシューを完了 | ラベルBを追加                    | Aliceの割り当てを解除してBobを割り当て |

## ヒント

覚えておくべきことがいくつかあります:

- リスト間でイシューを移動すると、移動元のリストからラベルが削除され、移動先のリストからラベルが追加されます。
- イシューに複数のラベルがある場合、複数のリストに存在できます。
- イシューにラベルが付けられている場合、リストにはイシューが自動的に入力されます。
- カード内のイシュータイトルを選択すると、そのイシューに移動します。
- カード内のラベルを選択すると、イシューボード全体がすばやくフィルタリングされ、そのラベルを持つすべてのリストからのイシューのみが表示されます。
- パフォーマンスと可視性の理由から、各リストにはデフォルトで最初の20件のイシューが表示されます。20件を超えるイシューがある場合は、下にスクロールを開始すると、次の20件が表示されます。

## イシューボードのトラブルシューティング

### 作成者または担当者でフィルタリングするときのグループイシューボードの`There was a problem fetching users`

グループイシューボードで作成者または担当者でフィルタリングするときに、`There was a problem fetching users`エラーのバナーが表示される場合は、現在のグループのメンバーとして追加されていることを確認してください。メンバー以外のユーザーには、イシューボードで作成者または担当者でフィルタリングするときにグループメンバーを一覧表示する権限がありません。

このエラーを修正するには、少なくともゲストロールで、すべてのユーザーをトップレベルグループに追加する必要があります。

### Railsコンソールを使用して、読み込みに失敗してタイムアウトになるイシューボードを修正する

UIでイシューボードが読み込まれず、タイムアウトする場合は、Railsコンソールを使用してイシュー再分散サービスを呼び出して修正します:

1. [Railsコンソールセッションを開始します](../../administration/operations/rails_console.md#starting-a-rails-console-session)。
1. 次のコマンドを実行します:

   ```ruby
   p = Project.find_by_full_path('<username-or-group>/<project-name>')

   Issues::RelativePositionRebalancingService.new(p.root_namespace.all_projects).execute
   ```

1. Railsコンソールを終了するには、`quit`と入力します。
