---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token AWS access token'
---

## Description

The response body contains content that matches the pattern of an AWS Access Token was detected. AWS Access Tokens are usually paired along with their secret key values. A malicious actor with access to this token can access AWS services with the same permissions as the user which generated the key, provided they have access to both values.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet). To delete an access key: - In the "Access keys" section, find the key that was identified - Select "Actions" - Select "Delete" - Follow the instructions in the dialog to first deactivate and then confirm the deletion For information on how to manage and revoke access keys for AWS please see their [documentation](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_access-keys.html#Using_CreateAccessKey).

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 798.12 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
