---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token Doppler API token'
---

## Description

The response body contains content that matches the pattern of a Doppler personal access token was detected.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet).

To revoke the Doppler personal access token:

- Open and sign in to <https://dashboard.doppler.com/>
- Select "Tokens" on the right-hand side menu
- Select the "Personal" tab
- Find the personal token and select "Roll" in the Action column
- After the "Roll Personal Token" dialog is displayed select "Roll"
- Copy the new token's value

For more information please see their documentation: <https://docs.doppler.com/docs/start>

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 798.29 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
