---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token Duffel API token'
---

## Description

The response body contains content that matches the pattern of a Duffel API token was detected. Duffel API Tokens can be either read-write or read-only depending on how they were created. A malicious actor with access to a read-write token can execute orders, book flights or hotels, or view or modify customer lists. A read-only token can view customer lists, list bookings and flight information.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet).

To regenerate a token:

- Open and sign in to <https://app.duffel.com/>
- On the top of the page select the Developers dropdown list and then select "Developers"
- On the left-hand menu select "Access tokens"
- Select the access token that was detected
- Note the type of token ("Read and Write" or "Read Only")
- In the "Danger Zone" select "Delete token"
- Recreate a new token with the same settings as the detected token

For more information see their documentation: <https://duffel.com/docs/guides/getting-started-with-the-dashboard#access-tokens>

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 798.34 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
