/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.configuration.inputs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ForwardingMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import org.gradle.internal.configuration.inputs.AccessTrackingSet;
import org.gradle.internal.configuration.inputs.AccessTrackingUtils;
import org.jspecify.annotations.Nullable;

public class AccessTrackingEnvMap
extends ForwardingMap<String, String>
implements Serializable {
    private final Map<String, String> delegate;
    private final BiConsumer<? super String, ? super String> onAccess;

    public AccessTrackingEnvMap(BiConsumer<String, String> onAccess) {
        this(System.getenv(), onAccess);
    }

    @VisibleForTesting
    public AccessTrackingEnvMap(Map<String, String> delegate, BiConsumer<? super String, ? super String> onAccess) {
        this.delegate = delegate;
        this.onAccess = onAccess;
    }

    public @Nullable String get(@Nullable Object key) {
        return this.getAndReport(key);
    }

    public @Nullable String getOrDefault(@Nullable Object key, @Nullable String defaultValue) {
        String value = this.getAndReport(key);
        if (value == null && !this.delegate.containsKey(key)) {
            return defaultValue;
        }
        return value;
    }

    public boolean containsKey(@Nullable Object key) {
        return this.getAndReport(key) != null;
    }

    public Set<String> keySet() {
        return new AccessTrackingSet(super.keySet(), this.keyTrackingListener());
    }

    private @Nullable String getAndReport(@Nullable Object key) {
        String result = this.delegate.get(key);
        this.onAccess.accept((String)key, result);
        return result;
    }

    public Set<Map.Entry<String, String>> entrySet() {
        return new AccessTrackingSet<Map.Entry<String, String>>(this.delegate.entrySet(), this.entrySetTrackingListener());
    }

    private void onAccessEntrySetElement(@Nullable Object potentialEntry) {
        Map.Entry<String, String> entry = AccessTrackingUtils.tryConvertingToTrackableEntry(potentialEntry);
        if (entry != null) {
            this.getAndReport(entry.getKey());
        }
    }

    public void forEach(BiConsumer<? super String, ? super String> action) {
        this.reportAggregatingAccess();
        this.delegate.forEach(action);
    }

    public int size() {
        this.reportAggregatingAccess();
        return this.delegate.size();
    }

    public boolean isEmpty() {
        this.reportAggregatingAccess();
        return this.delegate.isEmpty();
    }

    public boolean equals(@Nullable Object object) {
        this.reportAggregatingAccess();
        return this.delegate.equals(object);
    }

    public int hashCode() {
        this.reportAggregatingAccess();
        return this.delegate.hashCode();
    }

    protected Map<String, String> delegate() {
        return this.delegate;
    }

    private void reportAggregatingAccess() {
        this.delegate.forEach(this.onAccess);
    }

    private AccessTrackingSet.Listener keyTrackingListener() {
        return new AccessTrackingSet.Listener(){

            @Override
            public void onAccess(@Nullable Object o) {
                AccessTrackingEnvMap.this.getAndReport(Objects.requireNonNull(o));
            }

            @Override
            public void onAggregatingAccess() {
                AccessTrackingEnvMap.this.reportAggregatingAccess();
            }

            @Override
            public void onRemove(@Nullable Object object) {
            }

            @Override
            public void onClear() {
            }
        };
    }

    private AccessTrackingSet.Listener entrySetTrackingListener() {
        return new AccessTrackingSet.Listener(){

            @Override
            public void onAccess(@Nullable Object o) {
                AccessTrackingEnvMap.this.onAccessEntrySetElement(o);
            }

            @Override
            public void onAggregatingAccess() {
                AccessTrackingEnvMap.this.reportAggregatingAccess();
            }

            @Override
            public void onRemove(@Nullable Object object) {
            }

            @Override
            public void onClear() {
            }
        };
    }

    private Object writeReplace() {
        this.reportAggregatingAccess();
        return this.delegate;
    }
}

