/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal.model;

import com.jediterm.terminal.StyledTextConsumer;
import com.jediterm.terminal.model.LinesStorage;
import com.jediterm.terminal.model.TerminalLine;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u001a\u0018\u0010\u0006\u001a\u00020\u0001*\u00020\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u001a\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004*\u00020\u00022\u0006\u0010\b\u001a\u00020\t\u001a\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004*\u00020\u00022\u0006\u0010\b\u001a\u00020\t\u001a1\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004*\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fH\u0082\b\u001a\u0012\u0010\u0010\u001a\u00020\t*\u00020\u00022\u0006\u0010\u0011\u001a\u00020\t\u001a,\u0010\u0012\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\t\u001a*\u0010\u0017\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001b\u001a0\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004*\u00020\u00022\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001b\u001a\n\u0010\u001d\u001a\u00020\u001e*\u00020\u0002\u00a8\u0006\u001f"}, d2={"addAllToTop", "", "Lcom/jediterm/terminal/model/LinesStorage;", "lines", "", "Lcom/jediterm/terminal/model/TerminalLine;", "addAllToBottom", "removeFromTop", "count", "", "removeFromBottom", "perform", "reverse", "", "operation", "Lkotlin/Function0;", "removeBottomEmptyLines", "maxCount", "processLines", "yStart", "consumer", "Lcom/jediterm/terminal/StyledTextConsumer;", "startRow", "insertLines", "y", "lastLine", "filler", "Lcom/jediterm/terminal/model/TerminalLine$TextEntry;", "deleteLines", "getLinesAsString", "", "core"})
@SourceDebugExtension(value={"SMAP\nLinesStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LinesStorage.kt\ncom/jediterm/terminal/model/LinesStorageKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,187:1\n83#1,18:188\n83#1,18:206\n1#2:224\n*S KotlinDebug\n*F\n+ 1 LinesStorage.kt\ncom/jediterm/terminal/model/LinesStorageKt\n*L\n71#1:188,18\n77#1:206,18\n*E\n"})
public final class LinesStorageKt {
    public static final void addAllToTop(@NotNull LinesStorage $this$addAllToTop, @NotNull List<TerminalLine> lines) {
        Intrinsics.checkNotNullParameter((Object)$this$addAllToTop, (String)"<this>");
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        for (int ind = CollectionsKt.getLastIndex(lines); -1 < ind; --ind) {
            $this$addAllToTop.addToTop(lines.get(ind));
        }
    }

    public static final void addAllToBottom(@NotNull LinesStorage $this$addAllToBottom, @NotNull List<TerminalLine> lines) {
        Intrinsics.checkNotNullParameter((Object)$this$addAllToBottom, (String)"<this>");
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        for (TerminalLine line : lines) {
            $this$addAllToBottom.addToBottom(line);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<TerminalLine> removeFromTop(@NotNull LinesStorage $this$removeFromTop, int count) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$removeFromTop, (String)"<this>");
        LinesStorage linesStorage = $this$removeFromTop;
        boolean reverse$iv = false;
        boolean $i$f$perform = false;
        if (count < 0) {
            throw new IllegalArgumentException("Count must be >= 0");
        }
        if (count == 0) {
            list = CollectionsKt.emptyList();
        } else {
            void $this$perform$iv;
            int actualCount$iv = Math.min(count, $this$perform$iv.getSize());
            switch (actualCount$iv) {
                case 0: {
                    list = CollectionsKt.emptyList();
                    break;
                }
                case 1: {
                    boolean bl = false;
                    list = CollectionsKt.listOf((Object)$this$removeFromTop.removeFromTop());
                    break;
                }
                default: {
                    ArrayList<TerminalLine> result$iv = new ArrayList<TerminalLine>(actualCount$iv);
                    int n = 0;
                    while (n < actualCount$iv) {
                        int it$iv = n++;
                        boolean bl = false;
                        ArrayList<TerminalLine> arrayList = result$iv;
                        boolean bl2 = false;
                        arrayList.add($this$removeFromTop.removeFromTop());
                    }
                    list = result$iv;
                }
            }
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<TerminalLine> removeFromBottom(@NotNull LinesStorage $this$removeFromBottom, int count) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$removeFromBottom, (String)"<this>");
        LinesStorage linesStorage = $this$removeFromBottom;
        boolean reverse$iv = true;
        boolean $i$f$perform = false;
        if (count < 0) {
            throw new IllegalArgumentException("Count must be >= 0");
        }
        if (count == 0) {
            list = CollectionsKt.emptyList();
        } else {
            void $this$perform$iv;
            int actualCount$iv = Math.min(count, $this$perform$iv.getSize());
            switch (actualCount$iv) {
                case 0: {
                    list = CollectionsKt.emptyList();
                    break;
                }
                case 1: {
                    boolean bl = false;
                    list = CollectionsKt.listOf((Object)$this$removeFromBottom.removeFromBottom());
                    break;
                }
                default: {
                    ArrayList<TerminalLine> result$iv = new ArrayList<TerminalLine>(actualCount$iv);
                    int n = 0;
                    while (n < actualCount$iv) {
                        int it$iv = n++;
                        boolean bl = false;
                        ArrayList<TerminalLine> arrayList = result$iv;
                        boolean bl2 = false;
                        arrayList.add($this$removeFromBottom.removeFromBottom());
                    }
                    CollectionsKt.reverse((List)result$iv);
                    list = result$iv;
                }
            }
        }
        return list;
    }

    private static final List<TerminalLine> perform(LinesStorage $this$perform, int count, boolean reverse, Function0<TerminalLine> operation) {
        List list;
        boolean $i$f$perform = false;
        if (count < 0) {
            throw new IllegalArgumentException("Count must be >= 0");
        }
        if (count == 0) {
            return CollectionsKt.emptyList();
        }
        int actualCount = Math.min(count, $this$perform.getSize());
        switch (actualCount) {
            case 0: {
                list = CollectionsKt.emptyList();
                break;
            }
            case 1: {
                list = CollectionsKt.listOf((Object)operation.invoke());
                break;
            }
            default: {
                ArrayList<Object> result = new ArrayList<Object>(actualCount);
                int n = 0;
                while (n < actualCount) {
                    int it = n++;
                    boolean bl = false;
                    result.add(operation.invoke());
                }
                if (reverse) {
                    CollectionsKt.reverse((List)result);
                }
                list = result;
            }
        }
        return list;
    }

    public static final int removeBottomEmptyLines(@NotNull LinesStorage $this$removeBottomEmptyLines, int maxCount) {
        Intrinsics.checkNotNullParameter((Object)$this$removeBottomEmptyLines, (String)"<this>");
        int removedCount = 0;
        for (int ind = $this$removeBottomEmptyLines.getSize() - 1; removedCount < maxCount && ind >= 0 && $this$removeBottomEmptyLines.get(ind).isNulOrEmpty(); --ind, ++removedCount) {
        }
        LinesStorageKt.removeFromBottom($this$removeBottomEmptyLines, removedCount);
        return removedCount;
    }

    public static final void processLines(@NotNull LinesStorage $this$processLines, int yStart, int count, @NotNull StyledTextConsumer consumer, int startRow) {
        Intrinsics.checkNotNullParameter((Object)$this$processLines, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        if (!(yStart >= 0)) {
            boolean $i$a$-require-LinesStorageKt$processLines$22 = false;
            String $i$a$-require-LinesStorageKt$processLines$22 = "yStart is " + yStart + ", should be >0";
            throw new IllegalArgumentException($i$a$-require-LinesStorageKt$processLines$22.toString());
        }
        int maxY = Math.min(yStart + count, $this$processLines.getSize());
        for (int y = yStart; y < maxY; ++y) {
            $this$processLines.get(y).process(y, consumer, startRow);
        }
    }

    public static /* synthetic */ void processLines$default(LinesStorage linesStorage, int n, int n2, StyledTextConsumer styledTextConsumer, int n3, int n4, Object object) {
        if ((n4 & 8) != 0) {
            n3 = -linesStorage.getSize();
        }
        LinesStorageKt.processLines(linesStorage, n, n2, styledTextConsumer, n3);
    }

    public static final void insertLines(@NotNull LinesStorage $this$insertLines, int y, int count, int lastLine, @NotNull TerminalLine.TextEntry filler) {
        Intrinsics.checkNotNullParameter((Object)$this$insertLines, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)filler, (String)"filler");
        int tailLinesCount = $this$insertLines.getSize() - lastLine - 1;
        List<TerminalLine> tail = tailLinesCount > 0 ? LinesStorageKt.removeFromBottom($this$insertLines, tailLinesCount) : CollectionsKt.emptyList();
        List<TerminalLine> head = y > 0 ? LinesStorageKt.removeFromTop($this$insertLines, y) : CollectionsKt.emptyList();
        for (int i = 0; i < count; ++i) {
            $this$insertLines.addToTop(new TerminalLine(filler));
        }
        LinesStorageKt.addAllToTop($this$insertLines, head);
        LinesStorageKt.removeFromBottom($this$insertLines, count);
        LinesStorageKt.addAllToBottom($this$insertLines, tail);
    }

    @NotNull
    public static final List<TerminalLine> deleteLines(@NotNull LinesStorage $this$deleteLines, int y, int count, int lastLine, @NotNull TerminalLine.TextEntry filler) {
        Intrinsics.checkNotNullParameter((Object)$this$deleteLines, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)filler, (String)"filler");
        int tailLinesCount = $this$deleteLines.getSize() - lastLine - 1;
        List<TerminalLine> tail = tailLinesCount > 0 ? LinesStorageKt.removeFromBottom($this$deleteLines, tailLinesCount) : CollectionsKt.emptyList();
        List<TerminalLine> head = y > 0 ? LinesStorageKt.removeFromTop($this$deleteLines, y) : CollectionsKt.emptyList();
        List<TerminalLine> removed = LinesStorageKt.removeFromTop($this$deleteLines, count);
        LinesStorageKt.addAllToTop($this$deleteLines, head);
        int n = removed.size();
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            $this$deleteLines.addToBottom(new TerminalLine(filler));
        }
        LinesStorageKt.addAllToBottom($this$deleteLines, tail);
        return removed;
    }

    @NotNull
    public static final String getLinesAsString(@NotNull LinesStorage $this$getLinesAsString) {
        Intrinsics.checkNotNullParameter((Object)$this$getLinesAsString, (String)"<this>");
        StringBuilder sb = new StringBuilder();
        int n = $this$getLinesAsString.getSize();
        for (int index = 0; index < n; ++index) {
            sb.append($this$getLinesAsString.get(index).getText());
            if (index == $this$getLinesAsString.getSize() - 1) continue;
            sb.append("\n");
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

