/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.localVcs.UpToDateLineNumberProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vcs.annotate.AnnotationWarning;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/openapi/vcs/actions/AnnotateWarningsService;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getWarning", "Lcom/intellij/openapi/vcs/annotate/AnnotationWarning;", "fileAnnotation", "Lcom/intellij/openapi/vcs/annotate/FileAnnotation;", "upToDateLineNumbers", "Lcom/intellij/openapi/localVcs/UpToDateLineNumberProvider;", "Companion", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nAnnotateWarningsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotateWarningsProvider.kt\ncom/intellij/openapi/vcs/actions/AnnotateWarningsService\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,82:1\n23#2:83\n*S KotlinDebug\n*F\n+ 1 AnnotateWarningsProvider.kt\ncom/intellij/openapi/vcs/actions/AnnotateWarningsService\n*L\n80#1:83\n*E\n"})
public final class AnnotateWarningsService {
    @NotNull
    private static final Companion Companion;
    @NotNull
    private final Project project;
    @NotNull
    private static final Logger LOG;

    public AnnotateWarningsService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @Nullable
    public final AnnotationWarning getWarning(@NotNull FileAnnotation fileAnnotation, @NotNull UpToDateLineNumberProvider upToDateLineNumbers) {
        int actualLines;
        Intrinsics.checkNotNullParameter((Object)fileAnnotation, (String)"fileAnnotation");
        Intrinsics.checkNotNullParameter((Object)upToDateLineNumbers, (String)"upToDateLineNumbers");
        VcsKey vcsKey = fileAnnotation.getVcsKey();
        if (vcsKey == null) {
            return null;
        }
        VcsKey vcsKey2 = vcsKey;
        AbstractVcs abstractVcs = ProjectLevelVcsManager.Companion.getInstance(this.project).findVcsByName(vcsKey2.getName());
        if (abstractVcs == null) {
            return null;
        }
        AbstractVcs vcs = abstractVcs;
        int expectedLines = RangesKt.coerceAtLeast((int)upToDateLineNumbers.getLineCount(), (int)1);
        if (Math.abs(expectedLines - (actualLines = RangesKt.coerceAtLeast((int)fileAnnotation.getLineCount(), (int)1))) > 1) {
            LOG.warn("Unexpected annotation lines number. Expected: " + expectedLines + ", actual: " + actualLines);
            Object[] objectArray = new Object[]{vcs.getDisplayName()};
            String string = VcsBundle.message((String)"annotation.wrong.line.number.notification.text", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return AnnotationWarning.Companion.error$default((AnnotationWarning.Companion)AnnotationWarning.Companion, (String)string, null, (int)2, null);
        }
        AnnotationProvider annotationProvider = vcs.getAnnotationProvider();
        return annotationProvider != null ? annotationProvider.getAnnotationWarnings(fileAnnotation) : null;
    }

    static {
        Companion $this$thisLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/vcs/actions/AnnotateWarningsService$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.vcs.impl"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

