/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.impl.api;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dataframe.DataRow;
import org.jetbrains.kotlinx.dataframe.api.CastKt;
import org.jetbrains.kotlinx.dataframe.api.CellAttributes;
import org.jetbrains.kotlinx.dataframe.api.FormatClause;
import org.jetbrains.kotlinx.dataframe.api.FormattedFrame;
import org.jetbrains.kotlinx.dataframe.api.FormattingDsl;
import org.jetbrains.kotlinx.dataframe.api.RgbColor;
import org.jetbrains.kotlinx.dataframe.columns.ColumnPath;
import org.jetbrains.kotlinx.dataframe.columns.ColumnWithPath;
import org.jetbrains.kotlinx.dataframe.columns.UnresolvedColumnsPolicy;
import org.jetbrains.kotlinx.dataframe.impl.UtilsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000^\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\n\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0003H\u0000\u001a\f\u0010\b\u001a\u00020\u0001*\u00020\tH\u0000\u001a2\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000eH\u0000\u001a0\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\tH\u0000\u001a\u0091\u0001\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00180\u0017\"\u0004\b\u0000\u0010\u0018\"\u0004\b\u0001\u0010\u0019*\u000e\u0012\u0004\u0012\u0002H\u0018\u0012\u0004\u0012\u0002H\u00190\u001a2a\b\u0004\u0010\u001b\u001a[\u0012\u0004\u0012\u00020\u001d\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u0002H\u00180\u001e\u00a2\u0006\f\b\u001f\u0012\b\b \u0012\u0004\b\b(!\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u0002H\u00190\"\u00a2\u0006\f\b\u001f\u0012\b\b \u0012\u0004\b\b(#\u0012\u0006\u0012\u0004\u0018\u00010$0\u001cj\u000e\u0012\u0004\u0012\u0002H\u0018\u0012\u0004\u0012\u0002H\u0019`&\u00a2\u0006\u0002\b%H\u0080\b\u00f8\u0001\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006'"}, d2={"encRgb", "", "r", "", "g", "b", "encHex", "v", "encode", "Lorg/jetbrains/kotlinx/dataframe/api/RgbColor;", "componentWise", "color1", "color2", "f", "Lkotlin/Function2;", "linearGradient", "x", "", "minValue", "minColor", "maxValue", "maxColor", "formatImpl", "Lorg/jetbrains/kotlinx/dataframe/api/FormattedFrame;", "T", "C", "Lorg/jetbrains/kotlinx/dataframe/api/FormatClause;", "formatter", "Lkotlin/Function3;", "Lorg/jetbrains/kotlinx/dataframe/api/FormattingDsl;", "Lorg/jetbrains/kotlinx/dataframe/DataRow;", "Lkotlin/ParameterName;", "name", "row", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnWithPath;", "col", "Lorg/jetbrains/kotlinx/dataframe/api/CellAttributes;", "Lkotlin/ExtensionFunctionType;", "Lorg/jetbrains/kotlinx/dataframe/api/RowColFormatter;", "core"})
public final class FormatKt {
    @NotNull
    public static final String encRgb(short r, short g, short b) {
        return '#' + FormatKt.encHex(r) + FormatKt.encHex(g) + FormatKt.encHex(b);
    }

    @NotNull
    public static final String encHex(short v) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = Integer.toString(v / 16, CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        StringBuilder stringBuilder2 = stringBuilder.append(string);
        String string2 = Integer.toString(v % 16, CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return stringBuilder2.append(string2).toString();
    }

    @NotNull
    public static final String encode(@NotNull RgbColor $this$encode) {
        Intrinsics.checkNotNullParameter((Object)$this$encode, (String)"<this>");
        return FormatKt.encRgb($this$encode.getR(), $this$encode.getG(), $this$encode.getB());
    }

    @NotNull
    public static final RgbColor componentWise(@NotNull RgbColor color1, @NotNull RgbColor color2, @NotNull Function2<? super Short, ? super Short, Short> f) {
        Intrinsics.checkNotNullParameter((Object)color1, (String)"color1");
        Intrinsics.checkNotNullParameter((Object)color2, (String)"color2");
        Intrinsics.checkNotNullParameter(f, (String)"f");
        return new RgbColor(((Number)f.invoke((Object)color1.getR(), (Object)color2.getR())).shortValue(), ((Number)f.invoke((Object)color1.getG(), (Object)color2.getG())).shortValue(), ((Number)f.invoke((Object)color1.getB(), (Object)color2.getB())).shortValue());
    }

    @NotNull
    public static final RgbColor linearGradient(double x, double minValue, @NotNull RgbColor minColor, double maxValue, @NotNull RgbColor maxColor) {
        Intrinsics.checkNotNullParameter((Object)minColor, (String)"minColor");
        Intrinsics.checkNotNullParameter((Object)maxColor, (String)"maxColor");
        if (x < minValue) {
            return minColor;
        }
        if (x > maxValue) {
            return maxColor;
        }
        double t = (x - minValue) / (maxValue - minValue);
        return FormatKt.componentWise(minColor, maxColor, (Function2<? super Short, ? super Short, Short>)((Function2)(arg_0, arg_1) -> FormatKt.linearGradient$lambda$0(t, arg_0, arg_1)));
    }

    @NotNull
    public static final <T, C> FormattedFrame<T> formatImpl(@NotNull FormatClause<T, C> $this$formatImpl, @NotNull Function3<? super FormattingDsl, ? super DataRow<? extends T>, ? super ColumnWithPath<? extends C>, ? extends CellAttributes> formatter) {
        Intrinsics.checkNotNullParameter($this$formatImpl, (String)"<this>");
        Intrinsics.checkNotNullParameter(formatter, (String)"formatter");
        boolean $i$f$formatImpl = false;
        FormatClause<T, C> clause = $this$formatImpl;
        Set columns2 = CollectionsKt.toSet((Iterable)UtilsKt.getColumnPaths(clause.getDf$core(), UnresolvedColumnsPolicy.Skip, clause.getColumns$core()));
        return new FormattedFrame<T>(clause.getDf$core(), (Function3)new Function3<FormattingDsl, DataRow<? extends T>, ColumnWithPath<?>, CellAttributes>(clause, columns2, formatter){
            final /* synthetic */ FormatClause<T, C> $clause;
            final /* synthetic */ Set<ColumnPath> $columns;
            final /* synthetic */ Function3<FormattingDsl, DataRow<? extends T>, ColumnWithPath<? extends C>, CellAttributes> $formatter;
            {
                this.$clause = $clause;
                this.$columns = $columns;
                this.$formatter = $formatter;
            }

            public final CellAttributes invoke(FormattingDsl $this$FormattedFrame, DataRow<? extends T> row, ColumnWithPath<?> col) {
                CellAttributes oldAttributes;
                Intrinsics.checkNotNullParameter((Object)$this$FormattedFrame, (String)"$this$FormattedFrame");
                Intrinsics.checkNotNullParameter(row, (String)"row");
                Intrinsics.checkNotNullParameter(col, (String)"col");
                Function3<FormattingDsl, DataRow<T>, ColumnWithPath<C>, CellAttributes> function3 = this.$clause.getOldFormatter$core();
                CellAttributes cellAttributes = oldAttributes = function3 != null ? (CellAttributes)function3.invoke((Object)FormattingDsl.INSTANCE, row, CastKt.cast(col)) : null;
                if (this.$columns.contains(col.getPath())) {
                    T value = col.get(row);
                    if (((Boolean)this.$clause.getFilter$core().invoke(row, value)).booleanValue()) {
                        return org.jetbrains.kotlinx.dataframe.api.FormatKt.and(oldAttributes, (CellAttributes)this.$formatter.invoke((Object)FormattingDsl.INSTANCE, CastKt.cast(row), CastKt.cast(col)));
                    }
                }
                return oldAttributes;
            }
        });
    }

    private static final short linearGradient$lambda$0(double $t, short cMin, short cMax) {
        return (short)((double)cMin + $t * (double)(cMax - cMin));
    }
}

