/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.math;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00000\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\r\u001a\u00020\u00042\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0096\u0002J\t\u0010\u000f\u001a\u00020\u0004H\u00c6\u0003J\u000e\u0010\u0010\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000bJ(\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00028\u0000H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0012J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u000e\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0004H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlinx/dataframe/math/IndexedComparable;", "T", "", "index", "", "value", "<init>", "(ILjava/lang/Comparable;)V", "getIndex", "()I", "getValue", "()Ljava/lang/Comparable;", "Ljava/lang/Comparable;", "compareTo", "other", "component1", "component2", "copy", "(ILjava/lang/Comparable;)Lorg/jetbrains/kotlinx/dataframe/math/IndexedComparable;", "equals", "", "", "hashCode", "toString", "", "core"})
public final class IndexedComparable<T extends Comparable<? super T>>
implements Comparable<IndexedComparable<T>> {
    private final int index;
    @NotNull
    private final T value;

    public IndexedComparable(int index, @NotNull T value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.index = index;
        this.value = value;
    }

    public final int getIndex() {
        return this.index;
    }

    @NotNull
    public final T getValue() {
        return this.value;
    }

    @Override
    public int compareTo(@NotNull IndexedComparable<T> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return this.value.compareTo(other.value);
    }

    public final int component1() {
        return this.index;
    }

    @NotNull
    public final T component2() {
        return this.value;
    }

    @NotNull
    public final IndexedComparable<T> copy(int index, @NotNull T value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return new IndexedComparable<T>(index, value);
    }

    public static /* synthetic */ IndexedComparable copy$default(IndexedComparable indexedComparable, int n, Comparable comparable, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = indexedComparable.index;
        }
        if ((n2 & 2) != 0) {
            comparable = indexedComparable.value;
        }
        return indexedComparable.copy(n, comparable);
    }

    @NotNull
    public String toString() {
        return "IndexedComparable(index=" + this.index + ", value=" + this.value + ')';
    }

    public int hashCode() {
        int result = Integer.hashCode(this.index);
        result = result * 31 + this.value.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IndexedComparable)) {
            return false;
        }
        IndexedComparable indexedComparable = (IndexedComparable)other;
        if (this.index != indexedComparable.index) {
            return false;
        }
        return Intrinsics.areEqual(this.value, indexedComparable.value);
    }
}

