/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.backend;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.terminal.backend.TtyConnectorListener;
import com.jediterm.core.util.TermSize;
import com.jediterm.terminal.TtyConnector;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.ProxyTtyConnector;
import org.jetbrains.plugins.terminal.TerminalUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bJ \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0012H\u0016J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u001d\u0010\u001a\u001a\u00020\r2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\r0\u001cH\u0082\bJ\u0012\u0010\u0017\u001a\u00020\r2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020 H\u0016J\n\u0010&\u001a\u0004\u0018\u00010\u001eH\u0016J\b\u0010'\u001a\u00020\rH\u0016R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/terminal/backend/ObservableTtyConnector;", "Lorg/jetbrains/plugins/terminal/ProxyTtyConnector;", "delegate", "Lcom/jediterm/terminal/TtyConnector;", "<init>", "(Lcom/jediterm/terminal/TtyConnector;)V", "connector", "getConnector", "()Lcom/jediterm/terminal/TtyConnector;", "listeners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/intellij/terminal/backend/TtyConnectorListener;", "addListener", "", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "listener", "read", "", "buf", "", "offset", "length", "write", "bytes", "", "fireListeners", "action", "Lkotlin/Function1;", "string", "", "isConnected", "", "resize", "termSize", "Lcom/jediterm/core/util/TermSize;", "waitFor", "ready", "getName", "close", "intellij.terminal.backend"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nObservableTtyConnector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ObservableTtyConnector.kt\ncom/intellij/terminal/backend/ObservableTtyConnector\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,77:1\n39#1,6:78\n47#1:85\n39#1,6:86\n47#1:93\n23#2:84\n23#2:92\n23#2:94\n*S KotlinDebug\n*F\n+ 1 ObservableTtyConnector.kt\ncom/intellij/terminal/backend/ObservableTtyConnector\n*L\n28#1:78,6\n28#1:85\n35#1:86,6\n35#1:93\n28#1:84\n35#1:92\n44#1:94\n*E\n"})
public final class ObservableTtyConnector
implements ProxyTtyConnector {
    @NotNull
    private final TtyConnector connector;
    @NotNull
    private final CopyOnWriteArrayList<TtyConnectorListener> listeners;

    public ObservableTtyConnector(@NotNull TtyConnector delegate) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        this.connector = delegate;
        this.listeners = new CopyOnWriteArrayList();
    }

    @Override
    @NotNull
    public TtyConnector getConnector() {
        return this.connector;
    }

    public final void addListener(@NotNull Disposable parentDisposable, @NotNull TtyConnectorListener listener2) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        TerminalUtil.addItem((List)this.listeners, listener2, parentDisposable);
    }

    public int read(@NotNull char[] buf, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        int charsReadCount = this.getConnector().read(buf, offset, length);
        if (charsReadCount > 0) {
            ObservableTtyConnector this_$iv = this;
            boolean $i$f$fireListeners = false;
            Iterator<TtyConnectorListener> iterator = this_$iv.listeners.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator<TtyConnectorListener> iterator2 = iterator;
            while (iterator2.hasNext()) {
                TtyConnectorListener listener$iv = iterator2.next();
                try {
                    Intrinsics.checkNotNull((Object)listener$iv);
                    TtyConnectorListener it = listener$iv;
                    boolean bl = false;
                    it.charsRead(buf, offset, charsReadCount);
                }
                catch (Throwable t$iv) {
                    ObservableTtyConnector $this$thisLogger$iv$iv = this_$iv;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(ObservableTtyConnector.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.error(t$iv);
                }
            }
        }
        return charsReadCount;
    }

    public void write(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.getConnector().write(bytes);
        ObservableTtyConnector this_$iv = this;
        boolean $i$f$fireListeners = false;
        Iterator<TtyConnectorListener> iterator = this_$iv.listeners.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<TtyConnectorListener> iterator2 = iterator;
        while (iterator2.hasNext()) {
            TtyConnectorListener listener$iv = iterator2.next();
            try {
                Intrinsics.checkNotNull((Object)listener$iv);
                TtyConnectorListener it = listener$iv;
                boolean bl = false;
                it.bytesWritten(bytes);
            }
            catch (Throwable t$iv) {
                ObservableTtyConnector $this$thisLogger$iv$iv = this_$iv;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(ObservableTtyConnector.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error(t$iv);
            }
        }
    }

    private final void fireListeners(Function1<? super TtyConnectorListener, Unit> action) {
        boolean $i$f$fireListeners = false;
        Iterator<TtyConnectorListener> iterator = this.listeners.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<TtyConnectorListener> iterator2 = iterator;
        while (iterator2.hasNext()) {
            TtyConnectorListener listener2 = iterator2.next();
            try {
                Intrinsics.checkNotNull((Object)listener2);
                action.invoke((Object)listener2);
            }
            catch (Throwable t) {
                ObservableTtyConnector $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(ObservableTtyConnector.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error(t);
            }
        }
    }

    public void write(@Nullable String string) {
        this.getConnector().write(string);
    }

    public boolean isConnected() {
        return this.getConnector().isConnected();
    }

    public void resize(@NotNull TermSize termSize) {
        Intrinsics.checkNotNullParameter((Object)termSize, (String)"termSize");
        this.getConnector().resize(termSize);
    }

    public int waitFor() {
        return this.getConnector().waitFor();
    }

    public boolean ready() {
        return this.getConnector().ready();
    }

    @Nullable
    public String getName() {
        return this.getConnector().getName();
    }

    public void close() {
        this.getConnector().close();
    }
}

