/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.groovy;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.compiler.PatternClassBean;
import com.intellij.patterns.compiler.PatternCompilerFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.impl.search.LowLevelSearchUtil;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SoftFactoryMap;
import com.intellij.util.text.StringSearcher;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.lang.resolve.NonCodeMembersContributor;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtilKt;

public final class PatternEditorContextMembersProvider
extends NonCodeMembersContributor {
    private static final Key<SoftFactoryMap<Class[], PsiFile>> PATTERN_INJECTION_CONTEXT = Key.create((String)"PATTERN_INJECTION_CONTEXT");
    private static final Key<CachedValue<Set<String>>> PATTERN_CLASSES = Key.create((String)"PATTERN_CLASSES");

    @Override
    public void processDynamicElements(@NotNull PsiType qualifierType, @NotNull PsiScopeProcessor scopeProcessor, @NotNull PsiElement place, @NotNull ResolveState state) {
        PsiFile containingFile;
        if (qualifierType == null) {
            PatternEditorContextMembersProvider.$$$reportNull$$$0(0);
        }
        if (scopeProcessor == null) {
            PatternEditorContextMembersProvider.$$$reportNull$$$0(1);
        }
        if (place == null) {
            PatternEditorContextMembersProvider.$$$reportNull$$$0(2);
        }
        if (state == null) {
            PatternEditorContextMembersProvider.$$$reportNull$$$0(3);
        }
        if ((containingFile = place.getContainingFile()) == null) {
            PsiUtilCore.ensureValid((PsiElement)place);
            ResolveUtilKt.getLog().error("Containing file is null for " + String.valueOf(place.getClass()));
            return;
        }
        PsiFile file = containingFile.getOriginalFile();
        BaseInjection injection = (BaseInjection)file.getUserData(BaseInjection.INJECTION_KEY);
        Processor processor = element -> element.processDeclarations(scopeProcessor, state, null, place);
        if (injection == null) {
            PatternEditorContextMembersProvider.processDevContext(file, (Processor<? super PsiElement>)processor);
        } else {
            PatternEditorContextMembersProvider.processPatternContext(injection, file, (Processor<? super PsiElement>)processor);
        }
    }

    private static boolean processPatternContext(@NotNull BaseInjection injection, @NotNull PsiFile file, @NotNull Processor<? super PsiElement> processor) {
        if (injection == null) {
            PatternEditorContextMembersProvider.$$$reportNull$$$0(4);
        }
        if (file == null) {
            PatternEditorContextMembersProvider.$$$reportNull$$$0(5);
        }
        if (processor == null) {
            PatternEditorContextMembersProvider.$$$reportNull$$$0(6);
        }
        return processor.process((Object)PatternEditorContextMembersProvider.getRootByClasses(file, InjectorUtils.getPatternClasses((String)injection.getSupportId())));
    }

    @NotNull
    private static PsiFile getRootByClasses(@NotNull PsiFile file, Class @NotNull [] classes) {
        Project project;
        SoftFactoryMap map2;
        if (file == null) {
            PatternEditorContextMembersProvider.$$$reportNull$$$0(7);
        }
        if (classes == null) {
            PatternEditorContextMembersProvider.$$$reportNull$$$0(8);
        }
        if ((map2 = (SoftFactoryMap)(project = file.getProject()).getUserData(PATTERN_INJECTION_CONTEXT)) == null) {
            map2 = new SoftFactoryMap<Class[], PsiFile>(){

                protected PsiFile create(Class @NotNull [] key) {
                    if (key == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    String text = PatternCompilerFactory.getFactory().getPatternCompiler(key).dumpContextDeclarations();
                    return PsiFileFactory.getInstance((Project)project).createFileFromText("context.groovy", (FileType)GroovyFileType.GROOVY_FILE_TYPE, (CharSequence)text);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/intellij/plugins/intelliLang/inject/groovy/PatternEditorContextMembersProvider$1", "create"));
                }
            };
            project.putUserData(PATTERN_INJECTION_CONTEXT, (Object)map2);
        }
        PsiFile psiFile = (PsiFile)map2.get((Object)classes);
        if (psiFile == null) {
            PatternEditorContextMembersProvider.$$$reportNull$$$0(9);
        }
        return psiFile;
    }

    private static boolean processDevContext(PsiFile file, Processor<? super PsiElement> processor) {
        String name;
        XmlTag tag = PatternEditorContextMembersProvider.getTagByInjectedFile(file);
        XmlTag parentTag = tag == null ? null : tag.getParentTag();
        String parentTagName = parentTag == null ? null : parentTag.getName();
        String string = name = tag == null ? null : tag.getName();
        if ("place".equals(name) && "injection".equals(parentTagName)) {
            return PatternEditorContextMembersProvider.processRootsByClassNames(file, parentTag.getAttributeValue("injector-id"), processor);
        }
        if ("pattern".equals(name) && parentTag != null) {
            return PatternEditorContextMembersProvider.processRootsByClassNames(file, tag.getAttributeValue("type"), processor);
        }
        return true;
    }

    @Nullable
    private static XmlTag getTagByInjectedFile(PsiFile file) {
        SmartPsiElementPointer pointer = (SmartPsiElementPointer)file.getUserData(FileContextUtil.INJECTED_IN_ELEMENT);
        PsiElement element = pointer == null ? null : pointer.getElement();
        return element instanceof XmlText ? ((XmlText)element).getParentTag() : null;
    }

    private static boolean processRootsByClassNames(@NotNull PsiFile file, @Nullable String type, @NotNull Processor<? super PsiElement> processor) {
        Project project;
        Set<String> classNames;
        if (file == null) {
            PatternEditorContextMembersProvider.$$$reportNull$$$0(10);
        }
        if (processor == null) {
            PatternEditorContextMembersProvider.$$$reportNull$$$0(11);
        }
        if (!(classNames = PatternEditorContextMembersProvider.collectDevPatternClassNames(project = file.getProject())).isEmpty()) {
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
            for (String className : classNames) {
                PsiClass patternClass = psiFacade.findClass(className, GlobalSearchScope.allScope((Project)project));
                if (patternClass == null || processor.process((Object)patternClass)) continue;
                return false;
            }
        }
        Class[] classes = StringUtil.isEmpty((String)type) ? ArrayUtil.EMPTY_CLASS_ARRAY : PatternCompilerFactory.getFactory().getPatternClasses(type);
        return classes.length == 0 || processor.process((Object)PatternEditorContextMembersProvider.getRootByClasses(file, classes));
    }

    private static Set<String> collectDevPatternClassNames(@NotNull Project project) {
        CachedValue cachedValue;
        if (project == null) {
            PatternEditorContextMembersProvider.$$$reportNull$$$0(12);
        }
        if ((cachedValue = (CachedValue)project.getUserData(PATTERN_CLASSES)) == null) {
            cachedValue = CachedValuesManager.getManager((Project)project).createCachedValue(() -> CachedValueProvider.Result.create(PatternEditorContextMembersProvider.calcDevPatternClassNames(project), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}), false);
            project.putUserData(PATTERN_CLASSES, (Object)cachedValue);
        }
        return (Set)cachedValue.getValue();
    }

    private static Set<String> calcDevPatternClassNames(@NotNull Project project) {
        if (project == null) {
            PatternEditorContextMembersProvider.$$$reportNull$$$0(13);
        }
        List roots = ContainerUtil.createLockFreeCopyOnWriteList();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiClass beanClass = psiFacade.findClass(PatternClassBean.class.getName(), GlobalSearchScope.allScope((Project)project));
        if (beanClass != null) {
            GlobalSearchScope scope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)GlobalSearchScope.allScope((Project)project), (FileType[])new FileType[]{StdFileTypes.XML});
            TextOccurenceProcessor occurenceProcessor = (element, offsetInElement) -> {
                String className;
                XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
                String string = className = tag == null ? null : tag.getAttributeValue("className");
                if (StringUtil.isNotEmpty((String)className) && tag.getLocalName().endsWith("patternClass")) {
                    roots.add(className);
                }
                return true;
            };
            StringSearcher searcher = new StringSearcher("patternClass", true, true);
            CacheManager.getInstance((Project)beanClass.getProject()).processFilesWithWord(psiFile -> {
                LowLevelSearchUtil.processElementsContainingWordInElement((TextOccurenceProcessor)occurenceProcessor, (PsiElement)psiFile, (StringSearcher)searcher, (boolean)true, (ProgressIndicator)new EmptyProgressIndicator());
                return true;
            }, searcher.getPattern(), (short)8, scope, searcher.isCaseSensitive());
        }
        return new HashSet<String>(roots);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeProcessor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injection";
                break;
            }
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/intelliLang/inject/groovy/PatternEditorContextMembersProvider";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/intelliLang/inject/groovy/PatternEditorContextMembersProvider";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootByClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processDynamicElements";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processPatternContext";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getRootByClasses";
                break;
            }
            case 9: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processRootsByClassNames";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "collectDevPatternClassNames";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "calcDevPatternClassNames";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9 -> new IllegalStateException(string);
        };
    }
}

