/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.common;

import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodeMatch;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.util.CharUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class Quotes {
    public static final Set<String> SYMMETRICAL = Collections.unmodifiableSet(new LinkedHashSet<String>(List.of("\"", "'", "`")));
    public static final String ALL = "'\"\u201c\u201d\u201e\u00ab\u00bb`\u2018\u2019";
    public static final NodePattern ANY = NodePattern.N.form("['\"\u201c\u201d\u201e\u00ab\u00bb`\u2018\u2019]");
    private final Map<String, String> opening2Closing = new HashMap<String, String>();
    private final Map<String, String> closing2Opening = new HashMap<String, String>();
    public static final NodePattern punctAllowedBeforeClosingQuote = NodePattern.N.form("[,;:.!?]");
    public static final NodePattern openingPosition = NodePattern.N.noSpaceAfter().andNot(NodePattern.N.form("'").directlyBefore(NodePattern.N.form("\\d\\d"))).andOr(CommonPatterns.firstToken, NodePattern.N.spaceBefore(), NodePattern.N.directlyAfter(NodePattern.PUNCT.andOr(CommonPatterns.firstToken, NodePattern.N.spaceBefore())));
    public static final NodePattern closingPosition = NodePattern.N.noSpaceBefore().andOr(CommonPatterns.lastToken, NodePattern.N.spaceAfter(), NodePattern.N.directlyBefore(NodePattern.PUNCT.andOr(CommonPatterns.lastToken, NodePattern.N.spaceAfter())));

    public Quotes(String quotePairs) {
        String[] pairs;
        for (String pair : pairs = quotePairs.split(" ")) {
            String opening = String.valueOf(pair.charAt(0));
            String closing = String.valueOf(pair.charAt(1));
            this.opening2Closing.put(opening, closing);
            this.closing2Opening.put(closing, opening);
        }
    }

    public NodePattern any() {
        return NodePattern.N.form("[" + ((StreamEx)StreamEx.of(this.opening2Closing.keySet()).append(this.closing2Opening.keySet()).append(SYMMETRICAL).distinct()).joining() + "]");
    }

    public NodePattern opening() {
        return NodePattern.N.form("[" + StreamEx.of(this.opening2Closing.keySet()).append(SYMMETRICAL).joining() + "]");
    }

    public NodePattern closing() {
        return NodePattern.N.form("[" + StreamEx.of(this.closing2Opening.keySet()).append(SYMMETRICAL).joining() + "]");
    }

    public NodePattern definitelyOpening() {
        return NodePattern.N.form("[" + ((StreamEx)StreamEx.of(this.opening2Closing.keySet()).filter(q -> !this.closing2Opening.containsKey(q))).joining() + "]");
    }

    public NodePattern definitelyClosing() {
        return NodePattern.N.form("[" + ((StreamEx)StreamEx.of(this.closing2Opening.keySet()).filter(q -> !this.opening2Closing.containsKey(q))).joining() + "]");
    }

    public NodePattern ambiguous() {
        return NodePattern.N.form("[" + ((StreamEx)StreamEx.of(this.opening2Closing.keySet()).filter(q -> this.closing2Opening.containsKey(q))).append(SYMMETRICAL).joining() + "]");
    }

    public NodePattern asymmetricalRule(Set<String> additionalClosingQuotes) {
        CharSequence[] allQuotes = (String[])((StreamEx)StreamEx.of(this.opening2Closing.keySet()).append(this.closing2Opening.keySet()).distinct()).toArray(String.class);
        return NodePattern.or(NodePattern.N.form("[" + String.join((CharSequence)"", allQuotes) + "]").noSpaceAfter().andOr(NodePattern.N.spaceBefore(), NodePattern.N.directlyAfter(CommonPatterns.openingParen), CommonPatterns.firstWord).and((arg_0, arg_1) -> this.lambda$asymmetricalRule$3((String[])allQuotes, additionalClosingQuotes, arg_0, arg_1)), this.definitelyClosing().noSpaceAfter().directlyAfter(CommonPatterns.colon.spaceAfter()).and((node, match) -> match.withCorrector(NodeCorrector.replace(node, this.closing2Opening.get(node.form())))));
    }

    @Nullable
    public String closingToOpening(String closing) {
        return SYMMETRICAL.contains(closing) ? closing : this.closing2Opening.get(closing);
    }

    @Nullable
    public String openingToClosing(String opening) {
        return SYMMETRICAL.contains(opening) ? opening : this.opening2Closing.get(opening);
    }

    public boolean canBeOpeningQuote(String form) {
        return SYMMETRICAL.contains(form) || this.opening2Closing.containsKey(form);
    }

    public boolean canBeClosingQuote(String form) {
        return SYMMETRICAL.contains(form) || this.closing2Opening.containsKey(form);
    }

    public boolean canBeAnyQuote(String form) {
        return SYMMETRICAL.contains(form) || this.closing2Opening.containsKey(form) || this.opening2Closing.containsKey(form);
    }

    private /* synthetic */ NodeMatch lambda$asymmetricalRule$3(String[] allQuotes, Set additionalClosingQuotes, Node node, NodeMatch match) {
        char pairQuote;
        String sentence;
        int searchStart = node.startOffset() + 1;
        int pairPos = searchStart + StringUtils.indexOfAny((CharSequence)(sentence = node.tree().text()).substring(searchStart), (CharSequence[])((CharSequence[])StreamEx.of((Object[])allQuotes).append((Collection)additionalClosingQuotes).toArray(String.class)));
        if (pairPos < searchStart || CharUtil.isAnySpace(sentence.charAt(pairPos - 1)) || pairPos + 1 < sentence.length() && Character.isLetterOrDigit(sentence.charAt(pairPos + 1))) {
            return null;
        }
        String clToOp1 = this.closing2Opening.get(node.form());
        String clToOp2 = this.closing2Opening.get(String.valueOf(sentence.charAt(pairPos)));
        String opToCl1 = this.opening2Closing.get(node.form());
        String opToCl2 = this.opening2Closing.get(String.valueOf(sentence.charAt(pairPos)));
        if (opToCl1 != null && ((pairQuote = opToCl1.charAt(0)) == sentence.charAt(pairPos) || StringUtils.indexOfAny((CharSequence)sentence.substring(pairPos), (char[])new char[]{pairQuote}) > 0)) {
            return null;
        }
        String pair2OpToCl = this.opening2Closing.get(clToOp1);
        String pair1ClToOp = this.closing2Opening.get(opToCl2);
        if (opToCl1 != null || clToOp2 != null) {
            if (opToCl1 != null) {
                match = match.withCorrector(NodeCorrector.rawReplace(pairPos, pairPos + 1, opToCl1));
            }
            if (clToOp2 != null) {
                match = match.withCorrector(NodeCorrector.replace(node, clToOp2));
            }
        } else {
            if (clToOp1 != null) {
                match = match.withCorrector(NodeCorrector.replace(node, clToOp1).join(NodeCorrector.rawReplace(pairPos, pairPos + 1, pair2OpToCl)));
            }
            if (opToCl2 != null) {
                match = match.withCorrector(NodeCorrector.rawReplace(pairPos, pairPos + 1, opToCl2).join(NodeCorrector.replace(node, pair1ClToOp)));
            }
        }
        return match.withReportedRange(node.startOffset(), pairPos + 1, node.tree());
    }
}

