/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.util.Function;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.EvaluateResult;
import org.jetbrains.debugger.ValueModifier;
import org.jetbrains.debugger.ValueModifierUtilKt;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.values.Value;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ,\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\tJ\u001c\u0010\u0012\u001a\u00020\t2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u001a\u0010\u0017\u001a\u00020\u00182\n\u0010\u0019\u001a\u00060\u001aj\u0002`\u001b2\u0006\u0010\u001c\u001a\u00020\t\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/debugger/ValueModifierUtil;", "", "<init>", "()V", "setValue", "Lorg/jetbrains/concurrency/Promise;", "variable", "Lorg/jetbrains/debugger/Variable;", "newValue", "", "evaluateContext", "Lorg/jetbrains/debugger/EvaluateContext;", "modifier", "Lorg/jetbrains/debugger/ValueModifier;", "evaluateGet", "Lorg/jetbrains/debugger/values/Value;", "host", "selfName", "propertyNamesToString", "list", "", "quotedAware", "", "appendUnquotedName", "", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "name", "intellij.platform.scriptDebugger.backend"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nValueModifierUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ValueModifierUtil.kt\norg/jetbrains/debugger/ValueModifierUtil\n+ 2 promise.kt\norg/jetbrains/concurrency/Promises__PromiseKt\n*L\n1#1,80:1\n142#2,4:81\n*S KotlinDebug\n*F\n+ 1 ValueModifierUtil.kt\norg/jetbrains/debugger/ValueModifierUtil\n*L\n34#1:81,4\n*E\n"})
public final class ValueModifierUtil {
    @NotNull
    public static final ValueModifierUtil INSTANCE = new ValueModifierUtil();

    private ValueModifierUtil() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Promise<Object> setValue(@NotNull Variable variable, @NotNull String newValue, @NotNull EvaluateContext evaluateContext, @NotNull ValueModifier modifier) {
        void $this$thenAsyncAccept$iv;
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
        Intrinsics.checkNotNullParameter((Object)evaluateContext, (String)"evaluateContext");
        Intrinsics.checkNotNullParameter((Object)modifier, (String)"modifier");
        Promise promise = EvaluateContext.evaluate$default(evaluateContext, newValue, null, false, null, 14, null);
        boolean $i$f$thenAsyncAccept = false;
        Promise promise2 = $this$thenAsyncAccept$iv.thenAsync(new Function(modifier, variable, evaluateContext){
            final /* synthetic */ ValueModifier $modifier$inlined;
            final /* synthetic */ Variable $variable$inlined;
            final /* synthetic */ EvaluateContext $evaluateContext$inlined;
            {
                this.$modifier$inlined = valueModifier;
                this.$variable$inlined = variable;
                this.$evaluateContext$inlined = evaluateContext;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final Promise fun(Object param) {
                EvaluateResult it = (EvaluateResult)param;
                boolean bl = false;
                Promise<?> promise = this.$modifier$inlined.setValue(this.$variable$inlined, it.getValue(), this.$evaluateContext$inlined);
                Intrinsics.checkNotNull(promise, (String)"null cannot be cast to non-null type org.jetbrains.concurrency.Promise<kotlin.Any?>");
                return promise;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"thenAsync(...)");
        return promise2;
    }

    @NotNull
    public final Promise<Value> evaluateGet(@NotNull Variable variable, @NotNull Object host, @NotNull EvaluateContext evaluateContext, @NotNull String selfName) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)evaluateContext, (String)"evaluateContext");
        Intrinsics.checkNotNullParameter((Object)selfName, (String)"selfName");
        StringBuilder builder = new StringBuilder(selfName);
        String string = variable.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        this.appendUnquotedName(builder, string);
        String string2 = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        Promise promise = EvaluateContext.evaluate$default(evaluateContext, string2, Collections.singletonMap(selfName, host), false, null, 8, null).then(arg_0 -> ValueModifierUtil.evaluateGet$lambda$1(arg_0 -> ValueModifierUtil.evaluateGet$lambda$0(variable, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"then(...)");
        return promise;
    }

    @NotNull
    public final String propertyNamesToString(@NotNull List<String> list, boolean quotedAware) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        StringBuilder builder = new StringBuilder();
        int n = ((Collection)list).size() + -1;
        if (0 <= n) {
            do {
                int i = n--;
                String name = list.get(i);
                ValueModifierUtilKt.access$doAppendName(builder, name, quotedAware && (name.charAt(0) == '\"' || name.charAt(0) == '\''));
            } while (0 <= n);
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public final void appendUnquotedName(@NotNull StringBuilder builder, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ValueModifierUtilKt.access$doAppendName(builder, name, false);
    }

    private static final Value evaluateGet$lambda$0(Variable $variable, EvaluateResult it) {
        $variable.setValue(it.getValue());
        return it.getValue();
    }

    private static final Value evaluateGet$lambda$1(Function1 $tmp0, Object p0) {
        return (Value)$tmp0.invoke(p0);
    }
}

