/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.AttributeInputStream;
import com.intellij.openapi.vfs.newvfs.AttributeOutputStream;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.CachedAttributeData;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.FileAttributeService;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J;\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0012\"\u000e\b\u0000\u0010\u0013*\b\u0012\u0004\u0012\u0002H\u00130\u00142\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u0002H\u0013H\u0016\u00a2\u0006\u0002\u0010\u0018J>\u0010\u0019\u001a\n\u0012\u0004\u0012\u0002H\u0013\u0018\u00010\u0012\"\u000e\b\u0000\u0010\u0013*\b\u0012\u0004\u0012\u0002H\u00130\u00142\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00130\u001bH\u0016J&\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00100\u00122\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0010H\u0016J \u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u00122\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0016JK\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0012\"\u0004\b\u0000\u0010\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u0002H\u00132\u0018\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u0002H\u0013\u0012\u0004\u0012\u00020\u000b0 H\u0016\u00a2\u0006\u0002\u0010\"J:\u0010#\u001a\n\u0012\u0004\u0012\u0002H\u0013\u0018\u00010\u0012\"\u0004\b\u0000\u0010\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\u00062\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u0002H\u00130%H\u0016J3\u0010'\u001a\u0002H\u0013\"\u000e\b\u0000\u0010\u0013*\b\u0012\u0004\u0012\u0002H\u00130\u00142\u0006\u0010(\u001a\u00020\u000e2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00130\u001bH\u0002\u00a2\u0006\u0002\u0010)R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/idea/caches/FileAttributeServiceImpl;", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/FileAttributeService;", "<init>", "()V", "attributes", "", "", "Lcom/intellij/openapi/vfs/newvfs/FileAttribute;", "getAttributes", "()Ljava/util/Map;", "register", "", "id", "version", "", "fixedSize", "", "writeEnumAttribute", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/CachedAttributeData;", "T", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "value", "(Ljava/lang/String;Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/Enum;)Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/CachedAttributeData;", "readEnumAttribute", "klass", "Ljava/lang/Class;", "writeBooleanAttribute", "readBooleanAttribute", "write", "writeValueFun", "Lkotlin/Function2;", "Ljava/io/DataOutput;", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/String;Ljava/lang/Object;Lkotlin/jvm/functions/Function2;)Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/CachedAttributeData;", "read", "readValueFun", "Lkotlin/Function1;", "Ljava/io/DataInput;", "deserializeEnumValue", "i", "(ILjava/lang/Class;)Ljava/lang/Enum;", "kotlin.idea"})
public final class FileAttributeServiceImpl
implements FileAttributeService {
    @NotNull
    private final Map<String, FileAttribute> attributes = new ConcurrentHashMap();

    @NotNull
    public final Map<String, FileAttribute> getAttributes() {
        return this.attributes;
    }

    public void register(@NotNull String id, int version, boolean fixedSize) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.attributes.put(id, new FileAttribute(id, version, fixedSize));
    }

    @NotNull
    public <T extends Enum<T>> CachedAttributeData<T> writeEnumAttribute(@NotNull String id, @NotNull VirtualFile file, @NotNull T value) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return this.write(file, id, value, FileAttributeServiceImpl::writeEnumAttribute$lambda$0);
    }

    @Nullable
    public <T extends Enum<T>> CachedAttributeData<T> readEnumAttribute(@NotNull String id, @NotNull VirtualFile file, @NotNull Class<T> klass) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        return this.read(file, id, arg_0 -> FileAttributeServiceImpl.readEnumAttribute$lambda$0(this, klass, arg_0));
    }

    @NotNull
    public CachedAttributeData<Boolean> writeBooleanAttribute(@NotNull String id, @NotNull VirtualFile file, boolean value) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.write(file, id, value, FileAttributeServiceImpl::writeBooleanAttribute$lambda$0);
    }

    @Nullable
    public CachedAttributeData<Boolean> readBooleanAttribute(@NotNull String id, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.read(file, id, FileAttributeServiceImpl::readBooleanAttribute$lambda$0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public <T> CachedAttributeData<T> write(@NotNull VirtualFile file, @NotNull String id, T value, @NotNull Function2<? super DataOutput, ? super T, Unit> writeValueFun) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(writeValueFun, (String)"writeValueFun");
        FileAttribute fileAttribute = this.attributes.get(id);
        if (fileAttribute == null) {
            throw new IllegalArgumentException("Attribute with " + id + " wasn't registered");
        }
        FileAttribute attribute = fileAttribute;
        CachedAttributeData data = new CachedAttributeData(value, file.getTimeStamp());
        Closeable closeable = (Closeable)attribute.writeFileAttribute(file);
        Throwable throwable = null;
        try {
            AttributeOutputStream it = (AttributeOutputStream)closeable;
            boolean bl = false;
            DataInputOutputUtil.writeTIME((DataOutput)((DataOutput)it), (long)data.getTimeStamp());
            Intrinsics.checkNotNull((Object)it);
            writeValueFun.invoke((Object)it, value);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T> CachedAttributeData<T> read(@NotNull VirtualFile file, @NotNull String id, @NotNull Function1<? super DataInput, ? extends T> readValueFun) {
        CachedAttributeData cachedAttributeData;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(readValueFun, (String)"readValueFun");
        FileAttribute fileAttribute = this.attributes.get(id);
        if (fileAttribute == null) {
            throw new IllegalArgumentException("Attribute with " + id + " wasn't registered");
        }
        FileAttribute attribute = fileAttribute;
        if (!(file instanceof VirtualFileWithId)) {
            return null;
        }
        if (!file.isValid()) {
            return null;
        }
        AttributeInputStream attributeInputStream = attribute.readFileAttribute(file);
        if (attributeInputStream != null) {
            Closeable closeable = (Closeable)attributeInputStream;
            Throwable throwable = null;
            try {
                AttributeInputStream it = (AttributeInputStream)closeable;
                boolean bl = false;
                long timeStamp = DataInputOutputUtil.readTIME((DataInput)((DataInput)it));
                Object value = readValueFun.invoke((Object)it);
                CachedAttributeData cachedAttributeData2 = file.getTimeStamp() == timeStamp ? new CachedAttributeData(value, timeStamp) : null;
                cachedAttributeData = cachedAttributeData2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        } else {
            cachedAttributeData = null;
        }
        return cachedAttributeData;
    }

    private final <T extends Enum<T>> T deserializeEnumValue(int i2, Class<T> klass) {
        Method method = klass.getMethod("values", new Class[0]);
        Object object = method.invoke(null, new Object[0]);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Array<T of org.jetbrains.kotlin.idea.caches.FileAttributeServiceImpl.deserializeEnumValue>");
        Enum[] values2 = (Enum[])object;
        return (T)values2[i2];
    }

    private static final Unit writeEnumAttribute$lambda$0(DataOutput output, Enum v) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        DataInputOutputUtil.writeINT((DataOutput)output, (int)v.ordinal());
        return Unit.INSTANCE;
    }

    private static final Enum readEnumAttribute$lambda$0(FileAttributeServiceImpl this$0, Class $klass, DataInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return this$0.deserializeEnumValue(DataInputOutputUtil.readINT((DataInput)input), $klass);
    }

    private static final Unit writeBooleanAttribute$lambda$0(DataOutput output, boolean v) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        DataInputOutputUtil.writeINT((DataOutput)output, (int)(v ? 1 : 0));
        return Unit.INSTANCE;
    }

    private static final boolean readBooleanAttribute$lambda$0(DataInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return DataInputOutputUtil.readINT((DataInput)input) > 0;
    }
}

