/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.breakpoints;

import com.intellij.debugger.SourcePosition;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.base.psi.PsiLinesUtilsKt;
import org.jetbrains.kotlin.idea.debugger.base.util.KotlinDebuggerConstants;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtil;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.ApplicabilityResult;
import org.jetbrains.kotlin.idea.util.FindElementUtils;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000d\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a2\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u001a>\u0010\f\u001a\u00020\u0001*\u00020\r2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u0080@\u00a2\u0006\u0002\u0010\u000e\u001aJ\u0010\u000f\u001a\u00020\u00012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\u0018\u0010\u0010\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u0011\u0012\u0004\u0012\u00020\u00120\t2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tH\u0002\u001a \u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a \u0010\u0018\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005H\u0002\u001a\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001f\u001a+\u0010 \u001a\b\u0012\u0004\u0012\u0002H!0\u001c\"\n\b\u0000\u0010!\u0018\u0001*\u00020\n2\u0006\u0010\u0002\u001a\u00020\"2\u0006\u0010\u0004\u001a\u00020\u0005H\u0086\b\u001a\u001c\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u0002\u001a\u00020\"2\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u001e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u0002\u001a\u00020\"2\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0014\u0010$\u001a\u00020\u0001*\u00020\u001d2\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\n\u0010%\u001a\u00020\u0001*\u00020&\u00a8\u0006'"}, d2={"isBreakpointApplicable", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "line", "", "project", "Lcom/intellij/openapi/project/Project;", "checker", "Lkotlin/Function1;", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/ApplicabilityResult;", "hasExecutableCodeInsideOnLine", "Lorg/jetbrains/kotlin/psi/KtElement;", "(Lorg/jetbrains/kotlin/psi/KtElement;Lcom/intellij/openapi/vfs/VirtualFile;ILcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "hasExecutableCodeImpl", "visitElements", "Lcom/intellij/util/Processor;", "", "getParentToAnalyze", "getTopmostParentOnLineOrSelf", "element", "document", "Lcom/intellij/openapi/editor/Document;", "getTopmostParentWithinOffsetRangeOrSelf", "startOffset", "endOffset", "getLambdasAtLineIfAny", "", "Lorg/jetbrains/kotlin/psi/KtFunction;", "sourcePosition", "Lcom/intellij/debugger/SourcePosition;", "getElementsAtLineIfAny", "T", "Lorg/jetbrains/kotlin/psi/KtFile;", "getLambdasAtLine", "isStartingOrEndingOnLine", "isInlineOnly", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "intellij.kotlin.jvm.debugger.core"})
@SourceDebugExtension(value={"SMAP\nbreakpointTypeUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 breakpointTypeUtils.kt\norg/jetbrains/kotlin/idea/debugger/core/breakpoints/BreakpointTypeUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 4 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,177:1\n808#2,11:178\n774#2:189\n865#2,2:190\n774#2:193\n865#2,2:194\n1761#2,3:196\n67#3:192\n232#4:199\n*S KotlinDebug\n*F\n+ 1 breakpointTypeUtils.kt\norg/jetbrains/kotlin/idea/debugger/core/breakpoints/BreakpointTypeUtilsKt\n*L\n139#1:178,11\n143#1:189\n143#1:190,2\n164#1:193\n164#1:194,2\n175#1:196,3\n155#1:192\n73#1:199\n*E\n"})
public final class BreakpointTypeUtilsKt {
    public static final boolean isBreakpointApplicable(@NotNull VirtualFile file, int line, @NotNull Project project, @NotNull Function1<? super PsiElement, ApplicabilityResult> checker) {
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter(checker, (String)"checker");
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
                if (psiFile == null) break block4;
                VirtualFile virtualFile = psiFile.getVirtualFile();
                if (Intrinsics.areEqual((Object)(virtualFile != null ? virtualFile.getFileType() : null), (Object)KotlinFileType.INSTANCE)) break block5;
            }
            return false;
        }
        Document document = FileDocumentManager.getInstance().getDocument(file);
        if (document == null) {
            return false;
        }
        Document document2 = document;
        return (Boolean)ActionsKt.runReadAction(() -> BreakpointTypeUtilsKt.isBreakpointApplicable$lambda$0(checker, project, document2, line));
    }

    @Nullable
    public static final Object hasExecutableCodeInsideOnLine(@NotNull KtElement $this$hasExecutableCodeInsideOnLine, @NotNull VirtualFile file, int line, @NotNull Project project, @NotNull Function1<? super PsiElement, ApplicabilityResult> checker, @NotNull Continuation<? super Boolean> $completion) {
        return CoroutinesKt.readAction(() -> BreakpointTypeUtilsKt.hasExecutableCodeInsideOnLine$lambda$0(file, $this$hasExecutableCodeInsideOnLine, line, checker, project), $completion);
    }

    private static final boolean hasExecutableCodeImpl(Function1<? super PsiElement, ApplicabilityResult> checker, Function1<? super Processor<PsiElement>, Unit> visitElements, Function1<? super PsiElement, ? extends PsiElement> getParentToAnalyze) {
        Ref.BooleanRef isApplicable2 = new Ref.BooleanRef();
        HashSet checked = new HashSet();
        visitElements.invoke(arg_0 -> BreakpointTypeUtilsKt.hasExecutableCodeImpl$lambda$0(getParentToAnalyze, checked, checker, isApplicable2, arg_0));
        return isApplicable2.element;
    }

    private static final PsiElement getTopmostParentOnLineOrSelf(PsiElement element, Document document, int line) {
        int offset;
        PsiElement current = element;
        PsiElement parent = current.getParent();
        while (!(parent == null || parent instanceof PsiFile || (offset = parent.getTextOffset()) > document.getTextLength() || offset >= 0 && document.getLineNumber(offset) != line)) {
            current = parent;
            parent = current.getParent();
        }
        return current;
    }

    private static final PsiElement getTopmostParentWithinOffsetRangeOrSelf(PsiElement element, int startOffset, int endOffset) {
        PsiElement parent;
        PsiElement node = element;
        while ((parent = node.getParent()) != null && PsiUtilsKt.getStartOffset((PsiElement)parent) >= startOffset && PsiUtilsKt.getEndOffset((PsiElement)parent) <= endOffset) {
            node = parent;
        }
        return node;
    }

    @NotNull
    public static final List<KtFunction> getLambdasAtLineIfAny(@NotNull SourcePosition sourcePosition) {
        Intrinsics.checkNotNullParameter((Object)sourcePosition, (String)"sourcePosition");
        PsiFile psiFile = sourcePosition.getFile();
        KtFile ktFile2 = psiFile instanceof KtFile ? (KtFile)psiFile : null;
        if (ktFile2 == null) {
            return CollectionsKt.emptyList();
        }
        KtFile file = ktFile2;
        return BreakpointTypeUtilsKt.getLambdasAtLineIfAny(file, sourcePosition.getLine());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ <T extends PsiElement> List<T> getElementsAtLineIfAny(KtFile file, int line) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        boolean $i$f$getElementsAtLineIfAny = false;
        PsiElement psiElement = DebuggerUtil.findElementAtLine(file, line);
        KtElement ktElement = psiElement instanceof KtElement ? (KtElement)psiElement : null;
        if (ktElement == null) {
            return CollectionsKt.emptyList();
        }
        KtElement lineElement = ktElement;
        int start2 = PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)lineElement));
        int end = PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)lineElement));
        for (PsiElement nextSibling = lineElement.getNextSibling(); nextSibling != null && line == PsiLinesUtilsKt.getLineNumber$default(nextSibling, false, 1, null); nextSibling = nextSibling.getNextSibling()) {
            end = PsiUtilsKt.getEndOffset((PsiElement)nextSibling);
        }
        PsiFile psiFile = (PsiFile)file;
        Class[] classArray = new Class[1];
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        classArray[0] = PsiElement.class;
        Iterable $this$filterIsInstance$iv = FindElementUtils.findElementsOfClassInRange(psiFile, start2, end, classArray);
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            Intrinsics.reifiedOperationMarker((int)3, (String)"T");
            if (!(element$iv$iv instanceof Object)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<KtFunction> getLambdasAtLineIfAny(@NotNull KtFile file, int line) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Iterable $this$filter$iv = BreakpointTypeUtilsKt.getLambdasAtLine(file, line);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KtFunction it = (KtFunction)element$iv$iv;
            boolean bl = false;
            if (!(PsiLinesUtilsKt.getLineNumber$default((PsiElement)it, false, 1, null) == line)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<KtFunction> getLambdasAtLine(@NotNull KtFile file, int line) {
        void $this$filterTo$iv$iv;
        Iterable $this$parentOfType$iv;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Integer n = PsiLinesUtilsKt.getLineStartOffset((PsiFile)file, line);
        if (n == null) {
            return CollectionsKt.emptyList();
        }
        int start2 = n;
        Integer n2 = PsiLinesUtilsKt.getLineEndOffset((PsiFile)file, line);
        if (n2 == null) {
            return CollectionsKt.emptyList();
        }
        int end = n2;
        Set result2 = new LinkedHashSet();
        int offset = start2;
        while (offset <= end) {
            PsiElement element = file.findElementAt(offset);
            if (element != null) {
                PsiElement psiElement = element;
                boolean withSelf$iv = true;
                boolean $i$f$parentOfType = false;
                KtFunction function = (KtFunction)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, KtFunction.class, (boolean)false);
                if (function != null) {
                    result2.add(function);
                }
                offset = PsiUtilsKt.getEndOffset((PsiElement)element);
                continue;
            }
            ++offset;
        }
        Iterable $this$filter$iv = result2;
        boolean $i$f$filter = false;
        $this$parentOfType$iv = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KtFunction it = (KtFunction)element$iv$iv;
            boolean bl = false;
            if (!(it instanceof KtFunctionLiteral || it.getName() == null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static final boolean isStartingOrEndingOnLine(@NotNull KtFunction $this$isStartingOrEndingOnLine, int line) {
        Intrinsics.checkNotNullParameter((Object)$this$isStartingOrEndingOnLine, (String)"<this>");
        return line == PsiLinesUtilsKt.getLineNumber((PsiElement)$this$isStartingOrEndingOnLine, true) || line == PsiLinesUtilsKt.getLineNumber((PsiElement)$this$isStartingOrEndingOnLine, false);
    }

    public static final boolean isInlineOnly(@NotNull KtCallableDeclaration $this$isInlineOnly) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)$this$isInlineOnly, (String)"<this>");
            if (!$this$isInlineOnly.hasModifier(KtTokens.INLINE_KEYWORD)) {
                return false;
            }
            List list2 = $this$isInlineOnly.getAnnotationEntries();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAnnotationEntries(...)");
            Iterable $this$any$iv = list2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KtAnnotationEntry it = (KtAnnotationEntry)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getShortName(), (Object)KotlinDebuggerConstants.INSTANCE.getINLINE_ONLY_ANNOTATION_FQ_NAME().shortName())) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean isBreakpointApplicable$lambda$0(Function1 $checker, Project $project, Document $document, int $line) {
        return BreakpointTypeUtilsKt.hasExecutableCodeImpl((Function1<? super PsiElement, ApplicabilityResult>)$checker, (Function1<? super Processor<PsiElement>, Unit>)((Function1)arg_0 -> BreakpointTypeUtilsKt.isBreakpointApplicable$lambda$0$0($project, $document, $line, arg_0)), (Function1<? super PsiElement, ? extends PsiElement>)((Function1)arg_0 -> BreakpointTypeUtilsKt.isBreakpointApplicable$lambda$0$1($document, $line, arg_0)));
    }

    private static final Unit isBreakpointApplicable$lambda$0$0(Project $project, Document $document, int $line, Processor processor2) {
        Intrinsics.checkNotNullParameter((Object)processor2, (String)"processor");
        XDebuggerUtil.getInstance().iterateLine($project, $document, $line, processor2);
        return Unit.INSTANCE;
    }

    private static final PsiElement isBreakpointApplicable$lambda$0$1(Document $document, int $line, PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return BreakpointTypeUtilsKt.getTopmostParentOnLineOrSelf(it, $document, $line);
    }

    private static final boolean hasExecutableCodeInsideOnLine$lambda$0(VirtualFile $file, KtElement $this_hasExecutableCodeInsideOnLine, int $line, Function1 $checker, Project $project) {
        Document document = FileDocumentManager.getInstance().getDocument($file);
        if (document == null) {
            return false;
        }
        Document document2 = document;
        int minOffset = Math.max(PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)$this_hasExecutableCodeInsideOnLine)), document2.getLineStartOffset($line));
        int maxOffset = Math.min(PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)$this_hasExecutableCodeInsideOnLine)), document2.getLineEndOffset($line));
        return BreakpointTypeUtilsKt.hasExecutableCodeImpl((Function1<? super PsiElement, ApplicabilityResult>)$checker, (Function1<? super Processor<PsiElement>, Unit>)((Function1)arg_0 -> BreakpointTypeUtilsKt.hasExecutableCodeInsideOnLine$lambda$0$0($project, document2, minOffset, maxOffset, arg_0)), (Function1<? super PsiElement, ? extends PsiElement>)((Function1)arg_0 -> BreakpointTypeUtilsKt.hasExecutableCodeInsideOnLine$lambda$0$1(minOffset, maxOffset, arg_0)));
    }

    private static final Unit hasExecutableCodeInsideOnLine$lambda$0$0(Project $project, Document $document, int $minOffset, int $maxOffset, Processor processor2) {
        Intrinsics.checkNotNullParameter((Object)processor2, (String)"processor");
        XDebuggerUtil xDebuggerUtil = XDebuggerUtil.getInstance();
        Intrinsics.checkNotNull((Object)xDebuggerUtil, (String)"null cannot be cast to non-null type com.intellij.xdebugger.impl.XDebuggerUtilImpl");
        ((XDebuggerUtilImpl)xDebuggerUtil).iterateOffsetRange($project, $document, $minOffset, $maxOffset, processor2);
        return Unit.INSTANCE;
    }

    private static final PsiElement hasExecutableCodeInsideOnLine$lambda$0$1(int $minOffset, int $maxOffset, PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return BreakpointTypeUtilsKt.getTopmostParentWithinOffsetRangeOrSelf(it, $minOffset, $maxOffset);
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean hasExecutableCodeImpl$lambda$0(Function1 $getParentToAnalyze, HashSet $checked, Function1 $checker, Ref.BooleanRef $isApplicable, PsiElement element) {
        block7: {
            block6: {
                void $this$getParentOfType$iv;
                if (element instanceof PsiWhiteSpace) break block6;
                Intrinsics.checkNotNull((Object)element);
                PsiElement psiElement = element;
                boolean strict$iv = false;
                boolean $i$f$getParentOfType = false;
                if (PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, PsiComment.class, (boolean)strict$iv) == null && element.isValid()) break block7;
            }
            return true;
        }
        PsiElement parent = (PsiElement)$getParentToAnalyze.invoke((Object)element);
        if (!$checked.add(parent)) {
            return true;
        }
        ApplicabilityResult applicabilityResult = (ApplicabilityResult)$checker.invoke((Object)parent);
        if (applicabilityResult == null) {
            return true;
        }
        ApplicabilityResult result2 = applicabilityResult;
        if (result2.getShouldStop() && !result2.isApplicable()) {
            $isApplicable.element = false;
            return false;
        }
        $isApplicable.element |= result2.isApplicable();
        return !result2.getShouldStop();
    }
}

