/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.build.issue.BuildIssue;
import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.pom.java.AcceptedLanguageLevelsSettings;
import com.intellij.pom.java.LanguageLevel;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.SyncBundle;

public class NonAcceptedJavaLevelIssue
implements BuildIssue {
    private final LanguageLevel myLevel;

    public NonAcceptedJavaLevelIssue(LanguageLevel level) {
        this.myLevel = level;
    }

    @NotNull
    public String getTitle() {
        String string = SyncBundle.message("maven.language.level.unaccepted.title", this.myLevel.getPresentableText());
        if (string == null) {
            NonAcceptedJavaLevelIssue.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getDescription() {
        String string = SyncBundle.message("maven.language.level.unaccepted.description", this.myLevel.getPresentableText(), MyQuickFix.ID);
        if (string == null) {
            NonAcceptedJavaLevelIssue.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public List<BuildIssueQuickFix> getQuickFixes() {
        List<BuildIssueQuickFix> list = Collections.singletonList(new MyQuickFix(this.myLevel));
        if (list == null) {
            NonAcceptedJavaLevelIssue.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Nullable
    public Navigatable getNavigatable(@NotNull Project project) {
        if (project == null) {
            NonAcceptedJavaLevelIssue.$$$reportNull$$$0(3);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/importing/NonAcceptedJavaLevelIssue";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/importing/NonAcceptedJavaLevelIssue";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getNavigatable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3 -> new IllegalArgumentException(string);
        };
    }

    private static class MyQuickFix
    implements BuildIssueQuickFix {
        static String ID = "maven_accept_language_level_issue_quick_fix";
        private final LanguageLevel myLevel;

        MyQuickFix(LanguageLevel level) {
            this.myLevel = level;
        }

        @NotNull
        public String getId() {
            String string = ID;
            if (string == null) {
                MyQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public CompletableFuture<?> runQuickFix(@NotNull Project project, @NotNull DataContext dataContext) {
            if (project == null) {
                MyQuickFix.$$$reportNull$$$0(1);
            }
            if (dataContext == null) {
                MyQuickFix.$$$reportNull$$$0(2);
            }
            AcceptedLanguageLevelsSettings.showNotificationToAccept((Project)project, (LanguageLevel)this.myLevel);
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            if (completableFuture == null) {
                MyQuickFix.$$$reportNull$$$0(3);
            }
            return completableFuture;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/maven/importing/NonAcceptedJavaLevelIssue$MyQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getId";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/maven/importing/NonAcceptedJavaLevelIssue$MyQuickFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "runQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "runQuickFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

