/*
 * Decompiled with CFR 0.152.
 */
package kotlin.test;

import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.test.Asserter;
import kotlin.test.AssertionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001H\u0000\u001a\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0001\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a4\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0000\u001a4\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\u00102\b\u0010\u0002\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0000\u00a8\u0006\u0011"}, d2={"messagePrefix", "", "message", "overrideAsserter", "Lkotlin/test/Asserter;", "value", "checkAbsoluteTolerance", "", "absoluteTolerance", "", "checkDoublesAreEqual", "expected", "actual", "shouldFail", "", "checkFloatsAreEqual", "", "kotlin-test"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\nkotlin/test/UtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,52:1\n1#2:53\n*E\n"})
public final class UtilsKt {
    @NotNull
    public static final String messagePrefix(@Nullable String message) {
        return message == null ? "" : message + ". ";
    }

    @PublishedApi
    @Nullable
    public static final Asserter overrideAsserter(@Nullable Asserter value) {
        Asserter asserter;
        Asserter it = asserter = AssertionsKt.get_asserter();
        boolean bl = false;
        AssertionsKt.set_asserter(value);
        return asserter;
    }

    private static final void checkAbsoluteTolerance(double absoluteTolerance) {
        if (!(absoluteTolerance >= 0.0)) {
            boolean $i$a$-require-UtilsKt$checkAbsoluteTolerance$32 = false;
            String $i$a$-require-UtilsKt$checkAbsoluteTolerance$32 = "Illegal negative absolute tolerance <" + absoluteTolerance + ">.";
            throw new IllegalArgumentException($i$a$-require-UtilsKt$checkAbsoluteTolerance$32.toString());
        }
        if (!(!Double.isNaN(absoluteTolerance))) {
            boolean bl = false;
            String string = "Illegal NaN absolute tolerance <" + absoluteTolerance + ">.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public static final void checkDoublesAreEqual(double expected, double actual, double absoluteTolerance, @Nullable String message, boolean shouldFail) {
        UtilsKt.checkAbsoluteTolerance(absoluteTolerance);
        boolean equal = Double.doubleToLongBits(expected) == Double.doubleToLongBits(actual) || Math.abs(expected - actual) <= absoluteTolerance;
        AssertionsKt.getAsserter().assertTrue((Function0<String>)((Function0)() -> UtilsKt.checkDoublesAreEqual$lambda$0(message, expected, absoluteTolerance, actual)), equal != shouldFail);
    }

    public static /* synthetic */ void checkDoublesAreEqual$default(double d, double d2, double d3, String string, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        UtilsKt.checkDoublesAreEqual(d, d2, d3, string, bl);
    }

    public static final void checkFloatsAreEqual(float expected, float actual, float absoluteTolerance, @Nullable String message, boolean shouldFail) {
        UtilsKt.checkAbsoluteTolerance(absoluteTolerance);
        boolean equal = Float.floatToIntBits(expected) == Float.floatToIntBits(actual) || Math.abs(expected - actual) <= absoluteTolerance;
        AssertionsKt.getAsserter().assertTrue((Function0<String>)((Function0)() -> UtilsKt.checkFloatsAreEqual$lambda$0(message, expected, absoluteTolerance, actual)), equal != shouldFail);
    }

    public static /* synthetic */ void checkFloatsAreEqual$default(float f, float f2, float f3, String string, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        UtilsKt.checkFloatsAreEqual(f, f2, f3, string, bl);
    }

    private static final String checkDoublesAreEqual$lambda$0(String $message, double $expected, double $absoluteTolerance, double $actual) {
        return UtilsKt.messagePrefix($message) + "Expected <" + $expected + "> with absolute tolerance <" + $absoluteTolerance + ">, actual <" + $actual + ">.";
    }

    private static final String checkFloatsAreEqual$lambda$0(String $message, float $expected, float $absoluteTolerance, float $actual) {
        return UtilsKt.messagePrefix($message) + "Expected <" + $expected + "> with absolute tolerance <" + $absoluteTolerance + ">, actual <" + $actual + ">.";
    }
}

