/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.ConsumerGroupDescribeResponseData;
import org.apache.kafka.common.protocol.MessageUtil;

public class ConsumerGroupDescribeResponseDataJsonConverter {
    public static ConsumerGroupDescribeResponseData read(JsonNode _node, short _version) {
        ConsumerGroupDescribeResponseData _object = new ConsumerGroupDescribeResponseData();
        JsonNode _throttleTimeMsNode = _node.get("throttleTimeMs");
        if (_throttleTimeMsNode == null) {
            throw new RuntimeException("ConsumerGroupDescribeResponseData: unable to locate field 'throttleTimeMs', which is mandatory in version " + _version);
        }
        _object.throttleTimeMs = MessageUtil.jsonNodeToInt(_throttleTimeMsNode, "ConsumerGroupDescribeResponseData");
        JsonNode _groupsNode = _node.get("groups");
        if (_groupsNode == null) {
            throw new RuntimeException("ConsumerGroupDescribeResponseData: unable to locate field 'groups', which is mandatory in version " + _version);
        }
        if (!_groupsNode.isArray()) {
            throw new RuntimeException("ConsumerGroupDescribeResponseData expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
        }
        ArrayList<ConsumerGroupDescribeResponseData.DescribedGroup> _collection = new ArrayList<ConsumerGroupDescribeResponseData.DescribedGroup>(_groupsNode.size());
        _object.groups = _collection;
        for (JsonNode _element : _groupsNode) {
            _collection.add(DescribedGroupJsonConverter.read(_element, _version));
        }
        return _object;
    }

    public static JsonNode write(ConsumerGroupDescribeResponseData _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("throttleTimeMs", (JsonNode)new IntNode(_object.throttleTimeMs));
        ArrayNode _groupsArray = new ArrayNode(JsonNodeFactory.instance);
        for (ConsumerGroupDescribeResponseData.DescribedGroup _element : _object.groups) {
            _groupsArray.add(DescribedGroupJsonConverter.write(_element, _version, _serializeRecords));
        }
        _node.set("groups", (JsonNode)_groupsArray);
        return _node;
    }

    public static JsonNode write(ConsumerGroupDescribeResponseData _object, short _version) {
        return ConsumerGroupDescribeResponseDataJsonConverter.write(_object, _version, true);
    }

    public static class DescribedGroupJsonConverter {
        public static ConsumerGroupDescribeResponseData.DescribedGroup read(JsonNode _node, short _version) {
            ConsumerGroupDescribeResponseData.DescribedGroup _object = new ConsumerGroupDescribeResponseData.DescribedGroup();
            JsonNode _errorCodeNode = _node.get("errorCode");
            if (_errorCodeNode == null) {
                throw new RuntimeException("DescribedGroup: unable to locate field 'errorCode', which is mandatory in version " + _version);
            }
            _object.errorCode = MessageUtil.jsonNodeToShort(_errorCodeNode, "DescribedGroup");
            JsonNode _errorMessageNode = _node.get("errorMessage");
            if (_errorMessageNode == null) {
                throw new RuntimeException("DescribedGroup: unable to locate field 'errorMessage', which is mandatory in version " + _version);
            }
            if (_errorMessageNode.isNull()) {
                _object.errorMessage = null;
            } else {
                if (!_errorMessageNode.isTextual()) {
                    throw new RuntimeException("DescribedGroup expected a string type, but got " + String.valueOf(_node.getNodeType()));
                }
                _object.errorMessage = _errorMessageNode.asText();
            }
            JsonNode _groupIdNode = _node.get("groupId");
            if (_groupIdNode == null) {
                throw new RuntimeException("DescribedGroup: unable to locate field 'groupId', which is mandatory in version " + _version);
            }
            if (!_groupIdNode.isTextual()) {
                throw new RuntimeException("DescribedGroup expected a string type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.groupId = _groupIdNode.asText();
            JsonNode _groupStateNode = _node.get("groupState");
            if (_groupStateNode == null) {
                throw new RuntimeException("DescribedGroup: unable to locate field 'groupState', which is mandatory in version " + _version);
            }
            if (!_groupStateNode.isTextual()) {
                throw new RuntimeException("DescribedGroup expected a string type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.groupState = _groupStateNode.asText();
            JsonNode _groupEpochNode = _node.get("groupEpoch");
            if (_groupEpochNode == null) {
                throw new RuntimeException("DescribedGroup: unable to locate field 'groupEpoch', which is mandatory in version " + _version);
            }
            _object.groupEpoch = MessageUtil.jsonNodeToInt(_groupEpochNode, "DescribedGroup");
            JsonNode _assignmentEpochNode = _node.get("assignmentEpoch");
            if (_assignmentEpochNode == null) {
                throw new RuntimeException("DescribedGroup: unable to locate field 'assignmentEpoch', which is mandatory in version " + _version);
            }
            _object.assignmentEpoch = MessageUtil.jsonNodeToInt(_assignmentEpochNode, "DescribedGroup");
            JsonNode _assignorNameNode = _node.get("assignorName");
            if (_assignorNameNode == null) {
                throw new RuntimeException("DescribedGroup: unable to locate field 'assignorName', which is mandatory in version " + _version);
            }
            if (!_assignorNameNode.isTextual()) {
                throw new RuntimeException("DescribedGroup expected a string type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.assignorName = _assignorNameNode.asText();
            JsonNode _membersNode = _node.get("members");
            if (_membersNode == null) {
                throw new RuntimeException("DescribedGroup: unable to locate field 'members', which is mandatory in version " + _version);
            }
            if (!_membersNode.isArray()) {
                throw new RuntimeException("DescribedGroup expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
            }
            ArrayList<ConsumerGroupDescribeResponseData.Member> _collection = new ArrayList<ConsumerGroupDescribeResponseData.Member>(_membersNode.size());
            _object.members = _collection;
            for (JsonNode _element : _membersNode) {
                _collection.add(MemberJsonConverter.read(_element, _version));
            }
            JsonNode _authorizedOperationsNode = _node.get("authorizedOperations");
            if (_authorizedOperationsNode == null) {
                throw new RuntimeException("DescribedGroup: unable to locate field 'authorizedOperations', which is mandatory in version " + _version);
            }
            _object.authorizedOperations = MessageUtil.jsonNodeToInt(_authorizedOperationsNode, "DescribedGroup");
            return _object;
        }

        public static JsonNode write(ConsumerGroupDescribeResponseData.DescribedGroup _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("errorCode", (JsonNode)new ShortNode(_object.errorCode));
            if (_object.errorMessage == null) {
                _node.set("errorMessage", (JsonNode)NullNode.instance);
            } else {
                _node.set("errorMessage", (JsonNode)new TextNode(_object.errorMessage));
            }
            _node.set("groupId", (JsonNode)new TextNode(_object.groupId));
            _node.set("groupState", (JsonNode)new TextNode(_object.groupState));
            _node.set("groupEpoch", (JsonNode)new IntNode(_object.groupEpoch));
            _node.set("assignmentEpoch", (JsonNode)new IntNode(_object.assignmentEpoch));
            _node.set("assignorName", (JsonNode)new TextNode(_object.assignorName));
            ArrayNode _membersArray = new ArrayNode(JsonNodeFactory.instance);
            for (ConsumerGroupDescribeResponseData.Member _element : _object.members) {
                _membersArray.add(MemberJsonConverter.write(_element, _version, _serializeRecords));
            }
            _node.set("members", (JsonNode)_membersArray);
            _node.set("authorizedOperations", (JsonNode)new IntNode(_object.authorizedOperations));
            return _node;
        }

        public static JsonNode write(ConsumerGroupDescribeResponseData.DescribedGroup _object, short _version) {
            return DescribedGroupJsonConverter.write(_object, _version, true);
        }
    }

    public static class TopicPartitionsJsonConverter {
        public static ConsumerGroupDescribeResponseData.TopicPartitions read(JsonNode _node, short _version) {
            ConsumerGroupDescribeResponseData.TopicPartitions _object = new ConsumerGroupDescribeResponseData.TopicPartitions();
            JsonNode _topicIdNode = _node.get("topicId");
            if (_topicIdNode == null) {
                throw new RuntimeException("TopicPartitions: unable to locate field 'topicId', which is mandatory in version " + _version);
            }
            if (!_topicIdNode.isTextual()) {
                throw new RuntimeException("TopicPartitions expected a JSON string type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.topicId = Uuid.fromString(_topicIdNode.asText());
            JsonNode _topicNameNode = _node.get("topicName");
            if (_topicNameNode == null) {
                throw new RuntimeException("TopicPartitions: unable to locate field 'topicName', which is mandatory in version " + _version);
            }
            if (!_topicNameNode.isTextual()) {
                throw new RuntimeException("TopicPartitions expected a string type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.topicName = _topicNameNode.asText();
            JsonNode _partitionsNode = _node.get("partitions");
            if (_partitionsNode == null) {
                throw new RuntimeException("TopicPartitions: unable to locate field 'partitions', which is mandatory in version " + _version);
            }
            if (!_partitionsNode.isArray()) {
                throw new RuntimeException("TopicPartitions expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
            }
            ArrayList<Integer> _collection = new ArrayList<Integer>(_partitionsNode.size());
            _object.partitions = _collection;
            for (JsonNode _element : _partitionsNode) {
                _collection.add(MessageUtil.jsonNodeToInt(_element, "TopicPartitions element"));
            }
            return _object;
        }

        public static JsonNode write(ConsumerGroupDescribeResponseData.TopicPartitions _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("topicId", (JsonNode)new TextNode(_object.topicId.toString()));
            _node.set("topicName", (JsonNode)new TextNode(_object.topicName));
            ArrayNode _partitionsArray = new ArrayNode(JsonNodeFactory.instance);
            for (Integer _element : _object.partitions) {
                _partitionsArray.add((JsonNode)new IntNode(_element.intValue()));
            }
            _node.set("partitions", (JsonNode)_partitionsArray);
            return _node;
        }

        public static JsonNode write(ConsumerGroupDescribeResponseData.TopicPartitions _object, short _version) {
            return TopicPartitionsJsonConverter.write(_object, _version, true);
        }
    }

    public static class MemberJsonConverter {
        public static ConsumerGroupDescribeResponseData.Member read(JsonNode _node, short _version) {
            ConsumerGroupDescribeResponseData.Member _object = new ConsumerGroupDescribeResponseData.Member();
            JsonNode _memberIdNode = _node.get("memberId");
            if (_memberIdNode == null) {
                throw new RuntimeException("Member: unable to locate field 'memberId', which is mandatory in version " + _version);
            }
            if (!_memberIdNode.isTextual()) {
                throw new RuntimeException("Member expected a string type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.memberId = _memberIdNode.asText();
            JsonNode _instanceIdNode = _node.get("instanceId");
            if (_instanceIdNode == null) {
                throw new RuntimeException("Member: unable to locate field 'instanceId', which is mandatory in version " + _version);
            }
            if (_instanceIdNode.isNull()) {
                _object.instanceId = null;
            } else {
                if (!_instanceIdNode.isTextual()) {
                    throw new RuntimeException("Member expected a string type, but got " + String.valueOf(_node.getNodeType()));
                }
                _object.instanceId = _instanceIdNode.asText();
            }
            JsonNode _rackIdNode = _node.get("rackId");
            if (_rackIdNode == null) {
                throw new RuntimeException("Member: unable to locate field 'rackId', which is mandatory in version " + _version);
            }
            if (_rackIdNode.isNull()) {
                _object.rackId = null;
            } else {
                if (!_rackIdNode.isTextual()) {
                    throw new RuntimeException("Member expected a string type, but got " + String.valueOf(_node.getNodeType()));
                }
                _object.rackId = _rackIdNode.asText();
            }
            JsonNode _memberEpochNode = _node.get("memberEpoch");
            if (_memberEpochNode == null) {
                throw new RuntimeException("Member: unable to locate field 'memberEpoch', which is mandatory in version " + _version);
            }
            _object.memberEpoch = MessageUtil.jsonNodeToInt(_memberEpochNode, "Member");
            JsonNode _clientIdNode = _node.get("clientId");
            if (_clientIdNode == null) {
                throw new RuntimeException("Member: unable to locate field 'clientId', which is mandatory in version " + _version);
            }
            if (!_clientIdNode.isTextual()) {
                throw new RuntimeException("Member expected a string type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.clientId = _clientIdNode.asText();
            JsonNode _clientHostNode = _node.get("clientHost");
            if (_clientHostNode == null) {
                throw new RuntimeException("Member: unable to locate field 'clientHost', which is mandatory in version " + _version);
            }
            if (!_clientHostNode.isTextual()) {
                throw new RuntimeException("Member expected a string type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.clientHost = _clientHostNode.asText();
            JsonNode _subscribedTopicNamesNode = _node.get("subscribedTopicNames");
            if (_subscribedTopicNamesNode == null) {
                throw new RuntimeException("Member: unable to locate field 'subscribedTopicNames', which is mandatory in version " + _version);
            }
            if (!_subscribedTopicNamesNode.isArray()) {
                throw new RuntimeException("Member expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
            }
            ArrayList<String> _collection = new ArrayList<String>(_subscribedTopicNamesNode.size());
            _object.subscribedTopicNames = _collection;
            for (JsonNode _element : _subscribedTopicNamesNode) {
                if (!_element.isTextual()) {
                    throw new RuntimeException("Member element expected a string type, but got " + String.valueOf(_node.getNodeType()));
                }
                _collection.add(_element.asText());
            }
            JsonNode _subscribedTopicRegexNode = _node.get("subscribedTopicRegex");
            if (_subscribedTopicRegexNode == null) {
                throw new RuntimeException("Member: unable to locate field 'subscribedTopicRegex', which is mandatory in version " + _version);
            }
            if (_subscribedTopicRegexNode.isNull()) {
                _object.subscribedTopicRegex = null;
            } else {
                if (!_subscribedTopicRegexNode.isTextual()) {
                    throw new RuntimeException("Member expected a string type, but got " + String.valueOf(_node.getNodeType()));
                }
                _object.subscribedTopicRegex = _subscribedTopicRegexNode.asText();
            }
            JsonNode _assignmentNode = _node.get("assignment");
            if (_assignmentNode == null) {
                throw new RuntimeException("Member: unable to locate field 'assignment', which is mandatory in version " + _version);
            }
            _object.assignment = AssignmentJsonConverter.read(_assignmentNode, _version);
            JsonNode _targetAssignmentNode = _node.get("targetAssignment");
            if (_targetAssignmentNode == null) {
                throw new RuntimeException("Member: unable to locate field 'targetAssignment', which is mandatory in version " + _version);
            }
            _object.targetAssignment = AssignmentJsonConverter.read(_targetAssignmentNode, _version);
            JsonNode _memberTypeNode = _node.get("memberType");
            if (_memberTypeNode == null) {
                if (_version >= 1) {
                    throw new RuntimeException("Member: unable to locate field 'memberType', which is mandatory in version " + _version);
                }
                _object.memberType = (byte)-1;
            } else {
                _object.memberType = MessageUtil.jsonNodeToByte(_memberTypeNode, "Member");
            }
            return _object;
        }

        public static JsonNode write(ConsumerGroupDescribeResponseData.Member _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("memberId", (JsonNode)new TextNode(_object.memberId));
            if (_object.instanceId == null) {
                _node.set("instanceId", (JsonNode)NullNode.instance);
            } else {
                _node.set("instanceId", (JsonNode)new TextNode(_object.instanceId));
            }
            if (_object.rackId == null) {
                _node.set("rackId", (JsonNode)NullNode.instance);
            } else {
                _node.set("rackId", (JsonNode)new TextNode(_object.rackId));
            }
            _node.set("memberEpoch", (JsonNode)new IntNode(_object.memberEpoch));
            _node.set("clientId", (JsonNode)new TextNode(_object.clientId));
            _node.set("clientHost", (JsonNode)new TextNode(_object.clientHost));
            ArrayNode _subscribedTopicNamesArray = new ArrayNode(JsonNodeFactory.instance);
            for (String _element : _object.subscribedTopicNames) {
                _subscribedTopicNamesArray.add((JsonNode)new TextNode(_element));
            }
            _node.set("subscribedTopicNames", (JsonNode)_subscribedTopicNamesArray);
            if (_object.subscribedTopicRegex == null) {
                _node.set("subscribedTopicRegex", (JsonNode)NullNode.instance);
            } else {
                _node.set("subscribedTopicRegex", (JsonNode)new TextNode(_object.subscribedTopicRegex));
            }
            _node.set("assignment", AssignmentJsonConverter.write(_object.assignment, _version, _serializeRecords));
            _node.set("targetAssignment", AssignmentJsonConverter.write(_object.targetAssignment, _version, _serializeRecords));
            if (_version >= 1) {
                _node.set("memberType", (JsonNode)new ShortNode((short)_object.memberType));
            }
            return _node;
        }

        public static JsonNode write(ConsumerGroupDescribeResponseData.Member _object, short _version) {
            return MemberJsonConverter.write(_object, _version, true);
        }
    }

    public static class AssignmentJsonConverter {
        public static ConsumerGroupDescribeResponseData.Assignment read(JsonNode _node, short _version) {
            ConsumerGroupDescribeResponseData.Assignment _object = new ConsumerGroupDescribeResponseData.Assignment();
            JsonNode _topicPartitionsNode = _node.get("topicPartitions");
            if (_topicPartitionsNode == null) {
                throw new RuntimeException("Assignment: unable to locate field 'topicPartitions', which is mandatory in version " + _version);
            }
            if (!_topicPartitionsNode.isArray()) {
                throw new RuntimeException("Assignment expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
            }
            ArrayList<ConsumerGroupDescribeResponseData.TopicPartitions> _collection = new ArrayList<ConsumerGroupDescribeResponseData.TopicPartitions>(_topicPartitionsNode.size());
            _object.topicPartitions = _collection;
            for (JsonNode _element : _topicPartitionsNode) {
                _collection.add(TopicPartitionsJsonConverter.read(_element, _version));
            }
            return _object;
        }

        public static JsonNode write(ConsumerGroupDescribeResponseData.Assignment _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            ArrayNode _topicPartitionsArray = new ArrayNode(JsonNodeFactory.instance);
            for (ConsumerGroupDescribeResponseData.TopicPartitions _element : _object.topicPartitions) {
                _topicPartitionsArray.add(TopicPartitionsJsonConverter.write(_element, _version, _serializeRecords));
            }
            _node.set("topicPartitions", (JsonNode)_topicPartitionsArray);
            return _node;
        }

        public static JsonNode write(ConsumerGroupDescribeResponseData.Assignment _object, short _version) {
            return AssignmentJsonConverter.write(_object, _version, true);
        }
    }
}

